/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.AllDifferent;
import constraints.hard.global.Matcher;
import utility.Kit;
import utility.sets.SetSparse;
import variables.domains.Domain;

public class MatcherAllDifferent
extends Matcher {
    private final int[] valToVar;

    public MatcherAllDifferent(AllDifferent ctr) {
        super(ctr, ctr.scp);
        this.queueBFS = new SetSparse(this.arity);
        this.predBFS = Kit.repeat(-1, this.arity);
        this.valToVar = Kit.repeat(-1, this.intervalSize);
    }

    private boolean findMatchingFor(int x) {
        ++this.time;
        this.predBFS[x] = -1;
        this.queueBFS.resetTo(x);
        while (!this.queueBFS.isEmpty()) {
            int y = this.queueBFS.shift();
            Domain dom = this.scp[y].dom;
            int a = dom.first();
            while (a != -1) {
                int v = this.normalizedValueOf(dom.toVal(a));
                int z = this.valToVar[v];
                assert (z == -1 || this.varToVal[z] == v);
                if (z == -1) {
                    while (this.predBFS[y] != -1) {
                        int w = this.varToVal[y];
                        this.varToVal[y] = v;
                        this.valToVar[v] = y;
                        v = w;
                        y = this.predBFS[y];
                    }
                    this.varToVal[y] = v;
                    this.valToVar[v] = y;
                    return true;
                }
                if (this.visitTime[z] < this.time) {
                    this.visitTime[z] = this.time;
                    this.predBFS[z] = y;
                    this.queueBFS.add(z);
                }
                a = dom.next(a);
            }
        }
        return false;
    }

    @Override
    public boolean findMaximumMatching() {
        this.unmatchedVars.clear();
        for (int x = 0; x < this.arity; ++x) {
            int u = this.varToVal[x];
            if (u == -1) {
                this.unmatchedVars.add(x);
                continue;
            }
            assert (this.valToVar[u] == x);
            if (!this.scp[x].dom.isPresentValue(this.domainValueOf(u))) {
                this.valToVar[u] = -1;
                this.varToVal[x] = -1;
                this.unmatchedVars.add(x);
            }
            if (this.scp[x].dom.size() != 1 || !this.unfixedVars.isPresent(x)) continue;
            this.unfixedVars.remove(x, this.ctr.pb.solver.depth());
        }
        while (!this.unmatchedVars.isEmpty()) {
            if (this.findMatchingFor(this.unmatchedVars.pop())) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void computeNeighbors() {
        for (SetSparse set : this.neighborsOfValues) {
            set.clear();
        }
        for (int x = 0; x < this.arity; ++x) {
            Domain dom = this.scp[x].dom;
            int a = dom.first();
            while (a != -1) {
                int u = this.normalizedValueOf(dom.toVal(a));
                if (this.valToVar[u] == x) {
                    this.neighborsOfValues[u].add(this.arity);
                } else if (this.valToVar[u] != -1) {
                    this.neighborsOfT.remove(u);
                } else {
                    this.neighborsOfValues[u].remove(this.arity);
                    this.neighborsOfT.add(u);
                }
                this.neighborsOfValues[u].add(x);
                a = dom.next(a);
            }
        }
    }

    public String toString() {
        return "varToVal: " + Kit.join((Object)this.varToVal, new String[0]) + "\nvalToVar: " + Kit.join((Object)this.valToVar, new String[0]);
    }
}

