/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.Constraint;
import java.util.stream.Stream;
import utility.Kit;
import utility.observers.ObserverConstructionProblem;
import utility.sets.SetSparse;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public abstract class Matcher
implements ObserverConstructionProblem {
    protected final Constraint ctr;
    protected final Variable[] scp;
    protected final int arity;
    protected int minValue;
    protected int maxValue;
    protected int intervalSize;
    protected int time;
    protected SetSparseReversible unfixedVars;
    protected final SetSparse unmatchedVars;
    protected final int[] varToVal;
    protected int[] visitTime;
    protected int nVisitedNodes;
    protected int[] numDFS;
    protected int[] lowLink;
    protected SetSparse stackTarjan;
    protected SetSparse[] neighborsOfValues;
    protected SetSparse neighborsOfT;
    protected boolean splitSCC;
    protected SetSparse currValsSCC;
    protected SetSparse currVarsSCC;
    protected SetSparse queueBFS;
    protected int[] predBFS;

    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.unfixedVars.restoreLimitAtLevel(depthBeforeBacktrack);
    }

    public Matcher(Constraint ctr, Variable[] scp) {
        this.ctr = ctr;
        this.scp = scp;
        this.arity = scp.length;
        this.unmatchedVars = new SetSparse(this.arity);
        this.varToVal = Kit.repeat(-1, this.arity);
        this.currVarsSCC = new SetSparse(this.arity);
        this.minValue = Stream.of(scp).mapToInt(x -> x.dom.firstValue()).min().getAsInt();
        this.maxValue = Stream.of(scp).mapToInt(x -> x.dom.lastValue()).max().getAsInt();
        this.intervalSize = this.maxValue - this.minValue + 1;
        ctr.pb.rs.observersConstructionProblem.add(this);
    }

    @Override
    public void onConstructionProblemFinished() {
        this.unfixedVars = new SetSparseReversible(this.arity, this.ctr.pb.variables.length + 1);
        this.neighborsOfValues = SetSparse.factoryArray(this.arity + 1, this.intervalSize);
        this.neighborsOfT = new SetSparse(this.intervalSize);
        this.currValsSCC = new SetSparse(this.intervalSize);
        int nNodes = this.arity + this.intervalSize + 1;
        this.visitTime = Kit.repeat(-1, nNodes);
        this.stackTarjan = new SetSparse(nNodes);
        this.numDFS = new int[nNodes];
        this.lowLink = new int[nNodes];
    }

    protected abstract boolean findMaximumMatching();

    protected abstract void computeNeighbors();

    private void update(int adjacentNode, int node) {
        if (this.visitTime[adjacentNode] == this.time) {
            if (this.stackTarjan.isPresent(adjacentNode) && this.numDFS[adjacentNode] < this.lowLink[node]) {
                this.lowLink[node] = this.numDFS[adjacentNode];
            }
        } else {
            this.tarjanRemoveValues(adjacentNode);
            if (this.lowLink[adjacentNode] < this.lowLink[node]) {
                this.lowLink[node] = this.lowLink[adjacentNode];
            }
        }
    }

    protected final void tarjanRemoveValues(int node) {
        int i;
        assert (this.visitTime[node] < this.time);
        this.visitTime[node] = this.time;
        this.lowLink[node] = ++this.nVisitedNodes;
        this.numDFS[node] = this.nVisitedNodes;
        this.stackTarjan.add(node);
        if (node < this.arity) {
            this.update(this.arity + this.varToVal[node], node);
        } else if (node < this.arity + this.intervalSize) {
            SetSparse neighbors = this.neighborsOfValues[node - this.arity];
            for (i = 0; i <= neighbors.limit; ++i) {
                this.update(neighbors.dense[i] == this.arity ? this.arity + this.intervalSize : neighbors.dense[i], node);
            }
        } else {
            assert (node == this.arity + this.intervalSize);
            for (int i2 = 0; i2 <= this.neighborsOfT.limit; ++i2) {
                this.update(this.arity + this.neighborsOfT.dense[i2], node);
            }
        }
        if (this.lowLink[node] == this.numDFS[node]) {
            boolean bl = this.splitSCC = this.splitSCC || this.lowLink[node] > 1 || this.nVisitedNodes < this.visitTime.length;
            if (this.splitSCC) {
                this.currVarsSCC.clear();
                for (int j = 0; j <= this.unfixedVars.limit; ++j) {
                    this.currVarsSCC.add(this.unfixedVars.dense[j]);
                }
                this.currValsSCC.clear();
                int nodeSCC = -1;
                while (nodeSCC != node) {
                    nodeSCC = this.stackTarjan.pop();
                    if (nodeSCC < this.arity) {
                        this.currVarsSCC.remove(nodeSCC);
                        continue;
                    }
                    if (this.arity > nodeSCC || nodeSCC >= this.arity + this.intervalSize) continue;
                    this.currValsSCC.add(nodeSCC - this.arity);
                }
                if (this.currVarsSCC.size() > 0) {
                    for (i = 0; i <= this.currValsSCC.limit; ++i) {
                        int u = this.currValsSCC.dense[i];
                        for (int j = 0; j <= this.currVarsSCC.limit; ++j) {
                            int x = this.currVarsSCC.dense[j];
                            int a = this.scp[x].dom.toPresentIdx(this.domainValueOf(u));
                            if (a < 0 || this.varToVal[x] == u) continue;
                            this.scp[x].dom.remove(a);
                        }
                    }
                }
            }
        }
    }

    public final void removeInconsistentValues() {
        ++this.time;
        this.computeNeighbors();
        this.stackTarjan.clear();
        this.splitSCC = false;
        this.nVisitedNodes = 0;
        for (int x = 0; x < this.arity; ++x) {
            if (this.visitTime[x] < this.time) {
                this.tarjanRemoveValues(x);
            }
            Domain dom = this.scp[x].dom;
            int a = dom.first();
            while (a != -1) {
                int u = this.normalizedValueOf(dom.toVal(a));
                if (this.visitTime[this.arity + u] < this.time) {
                    this.tarjanRemoveValues(this.arity + u);
                }
                a = dom.next(a);
            }
        }
    }

    protected int domainValueOf(int normalizedValue) {
        return normalizedValue + this.minValue;
    }

    protected int normalizedValueOf(int domainValue) {
        return domainValue - this.minValue;
    }
}

