/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.CardinalityAbstract;
import constraints.hard.global.MatcherCardinality;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import variables.Variable;

public class CardinalityConstant
extends CardinalityAbstract
implements TagCompleteFilteringAtEachCall,
TagGuaranteedGAC,
ICtr.ICtrCardinality {
    private int[] values;
    private int[] minOccs;
    private int[] maxOccs;

    @Override
    public boolean checkValues(int[] t) {
        for (int i = 0; i < this.values.length; ++i) {
            int nOccurrences = 0;
            for (int j = 0; j < t.length; ++j) {
                if (t[j] != this.values[i]) continue;
                ++nOccurrences;
            }
            if (nOccurrences >= this.minOccs[i] && nOccurrences <= this.maxOccs[i]) continue;
            return false;
        }
        return true;
    }

    public CardinalityConstant(Problem pb, Variable[] scp, int[] values, int[] minOccs, int[] maxOccs) {
        super(pb, scp);
        Kit.control(values.length == minOccs.length && values.length == maxOccs.length);
        this.values = values;
        this.minOccs = minOccs;
        this.maxOccs = maxOccs;
        this.defineKey(new Object[0]);
        this.matcher = new MatcherCardinality(this, scp, values, minOccs, maxOccs);
    }

    public CardinalityConstant(Problem problem, Variable[] scope, int[] values, int[] nOccs) {
        this(problem, scope, values, nOccs, nOccs);
    }

    public CardinalityConstant(Problem problem, Variable[] scope, int zeroValue) {
        super(problem, scope);
        this.values = Kit.sort(Kit.intArray(Variable.setOfvaluesIn(scope)));
        this.minOccs = Kit.repeat(0, this.values.length);
        this.maxOccs = Kit.repeat(1, this.values.length);
        int position = Utilities.indexOf((int)zeroValue, (int[])this.values);
        Kit.control(position >= 0);
        this.maxOccs[position] = Integer.MAX_VALUE;
        this.defineKey(new Object[0]);
        this.matcher = new MatcherCardinality(this, scope, this.values, this.minOccs, this.maxOccs);
    }

    public Map<String, Object> mapXCSP() {
        String o = IntStream.range(0, this.minOccs.length).mapToObj(i -> this.minOccs[i] == this.maxOccs[i] ? this.minOccs[i] + "" : this.minOccs[i] + ".." + this.maxOccs[i]).collect(Collectors.joining(" "));
        return IRootForCtrAndObj.map((String)"scope", (Object)this.scp, (String)LIST, (Object)this.compact(this.scp), (String)VALUES, (Object)Kit.join((Object)this.values, new String[0]), (String)"closed", null, (String)OCCURS, (Object)o);
    }
}

