/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.CtrGlobal;
import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagCompleteFilteringAtEachCall;
import utility.interfaces.TagGuaranteedGAC;
import utility.interfaces.TagSymmetric;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public final class Among
extends CtrGlobal
implements TagSymmetric,
TagGuaranteedGAC,
TagCompleteFilteringAtEachCall {
    private static final int SEARCH_THRESHOLD = 10;
    private final int[] values;
    private final int k;
    private final SetSparse mixedVariables;
    private final boolean linearSearch;

    @Override
    public boolean checkValues(int[] t) {
        return IntStream.of(t).filter(v -> this.isPresentInValues(v)).count() == (long)this.k;
    }

    private boolean isPresentInValues(int value) {
        return this.linearSearch ? Kit.isPresent(value, this.values) : Arrays.binarySearch(this.values, value) >= 0;
    }

    public Among(Problem pb, Variable[] list, int[] values, int k) {
        super(pb, list);
        this.values = values;
        this.k = k;
        this.mixedVariables = new SetSparse(list.length);
        this.linearSearch = values.length < 10;
        this.defineKey(Kit.join((Object)values, new String[0]), k);
        Kit.control(Kit.isStrictlyIncreasing(values), () -> "Values must be given in increasing order");
        Kit.control(0 < k && k < list.length, () -> "Bad value of k=" + k);
        Kit.control(Stream.of(list).allMatch(x -> x.dom.size() > 1 && IntStream.of(values).anyMatch(v -> x.dom.isPresentValue(v))), () -> "Badly formed scope.");
    }

    @Override
    public boolean runPropagator(Variable x) {
        Domain dom;
        int i;
        int nGuaranteedVars = 0;
        int nPossibleVars = 0;
        this.mixedVariables.clear();
        for (i = 0; i < this.scp.length; ++i) {
            dom = this.scp[i].dom;
            boolean atLeastOnePresentValue = false;
            boolean atLeastOneAbsentValue = false;
            int a2 = dom.first();
            while (!(a2 == -1 || atLeastOnePresentValue && atLeastOneAbsentValue)) {
                boolean b = this.isPresentInValues(dom.toVal(a2));
                atLeastOnePresentValue = atLeastOnePresentValue || b;
                atLeastOneAbsentValue = atLeastOneAbsentValue || !b;
                a2 = dom.next(a2);
            }
            if (!atLeastOnePresentValue) continue;
            ++nPossibleVars;
            if (!atLeastOneAbsentValue && ++nGuaranteedVars > this.k) {
                return dom.fail();
            }
            if (!atLeastOneAbsentValue) continue;
            this.mixedVariables.add(i);
        }
        if (nGuaranteedVars == this.k) {
            for (i = this.mixedVariables.limit; i >= 0; --i) {
                dom = this.scp[this.mixedVariables.dense[i]].dom;
                dom.removeIndexesChecking(a -> this.isPresentInValues(dom.toVal((int)a)));
            }
            return true;
        }
        if (nPossibleVars < this.k) {
            return x.dom.fail();
        }
        if (nPossibleVars == this.k) {
            for (i = this.mixedVariables.limit; i >= 0; --i) {
                dom = this.scp[this.mixedVariables.dense[i]].dom;
                dom.removeIndexesChecking(a -> !this.isPresentInValues(dom.toVal((int)a)));
            }
        }
        return true;
    }
}

