/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.AllDifferentAbstract;
import java.util.Arrays;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.interfaces.TagUnguaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public final class AllDifferentPermutation
extends AllDifferentAbstract
implements TagUnguaranteedGAC,
TagPartialFilteringAtEachCall,
ObserverBacktrackingSystematic {
    private SetSparseReversible unfixedVars;
    private SetSparseReversible unfixedIdxs;
    private Variable[] residues1;
    private Variable[] residues2;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.unfixedVars.restoreLimitAtLevel(depthBeforeBacktrack);
        this.unfixedIdxs.restoreLimitAtLevel(depthBeforeBacktrack);
    }

    private Variable findAnotherWatchedUnifxedVariable(int idx, Variable otherWatchedVariable) {
        int[] dense = this.unfixedVars.dense;
        for (int i = this.unfixedVars.limit; i >= 0; --i) {
            Variable var = this.scp[dense[i]];
            if (var == otherWatchedVariable || !var.dom.isPresent(idx)) continue;
            return var;
        }
        return null;
    }

    public AllDifferentPermutation(Problem pb, Variable[] scp) {
        super(pb, scp);
        Kit.control(Variable.isPermutationElligible(scp));
        this.residues1 = new Variable[scp[0].dom.initSize()];
        this.residues2 = new Variable[scp[0].dom.initSize()];
        Arrays.fill(this.residues1, scp[0]);
        Arrays.fill(this.residues2, scp[scp.length - 1]);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.unfixedVars = new SetSparseReversible(this.scp.length, this.pb.variables.length + 1);
        this.unfixedIdxs = new SetSparseReversible(this.scp[0].dom.initSize(), this.pb.variables.length + 1);
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        int i;
        int level = this.pb.solver.depth();
        int[] dense = this.unfixedVars.dense;
        for (i = this.unfixedVars.limit; i >= 0; --i) {
            Variable x = this.scp[dense[i]];
            if (x.dom.size() != 1) continue;
            int a = x.dom.unique();
            this.unfixedVars.remove(dense[i], level);
            this.unfixedIdxs.remove(a, level);
            for (int j = this.unfixedVars.limit; j >= 0; --j) {
                Variable y = this.scp[dense[j]];
                Domain dy = y.dom;
                if (!dy.isPresent(a)) continue;
                if (!dy.remove(a)) {
                    return false;
                }
                if (dy.size() != 1) continue;
                i = Math.max(i, j + 1);
            }
        }
        dense = this.unfixedIdxs.dense;
        for (i = this.unfixedIdxs.limit; i >= 0; --i) {
            Variable x;
            int a = dense[i];
            if (!this.residues1[a].dom.isPresent(a)) {
                x = this.findAnotherWatchedUnifxedVariable(a, this.residues2[a]);
                if (x != null) {
                    this.residues1[a] = x;
                } else {
                    x = this.residues2[a];
                    if (!x.dom.reduceTo(a)) {
                        return false;
                    }
                    this.unfixedVars.remove(this.positionOf(x), level);
                    this.unfixedIdxs.remove(a, level);
                }
            }
            assert (this.residues1[a].dom.size() > 1) : this.residues1[a] + " " + a + " " + this.residues1[a].dom.size();
            if (this.residues2[a].dom.isPresent(a)) continue;
            x = this.findAnotherWatchedUnifxedVariable(a, this.residues1[a]);
            if (x != null) {
                this.residues2[a] = x;
                continue;
            }
            x = this.residues1[a];
            x.dom.reduceTo(a);
            this.unfixedVars.remove(this.positionOf(x), level);
            this.unfixedIdxs.remove(a, level);
        }
        return true;
    }
}

