/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.global;

import constraints.hard.global.AllDifferentAbstract;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Utilities;
import problem.Problem;
import utility.Kit;
import utility.interfaces.TagPartialFilteringAtEachCall;
import utility.interfaces.TagUnguaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetSparse;
import utility.sets.SetSparseReversible;
import variables.Variable;
import variables.domains.Domain;

public class AllDifferentBound
extends AllDifferentAbstract
implements ObserverBacktrackingSystematic,
TagUnguaranteedGAC,
TagPartialFilteringAtEachCall {
    static int nb = 0;
    int time;
    int d;
    long nDecisionsAtLastCall;
    SetSparseReversible fixedIdxs;
    BoundReasoner minReasoner;
    BoundReasoner maxReasoner;
    HallIntervalStored storer;
    int[] storedMins;
    int[] storedMaxs;

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.fixedIdxs.restoreLimitAtLevel(depthBeforeBacktrack);
        this.storer.restoreAtDepthBefore(depthBeforeBacktrack);
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.fixedIdxs = new SetSparseReversible(this.scp[0].dom.initSize(), false, this.pb.variables.length + 1);
        this.storer = new HallIntervalStored(this.scp[0].dom.initSize(), this.pb.variables.length + 1);
    }

    public AllDifferentBound(Problem pb, Variable[] scp) {
        super(pb, scp);
        Kit.control(Variable.haveSameDomainType(scp));
        this.d = scp[0].dom.initSize();
        this.minReasoner = new MinBoundReasoner();
        this.maxReasoner = new MaxBoundReasoner();
        this.storedMins = Stream.of(scp).mapToInt(x -> x.dom.first()).toArray();
        this.storedMaxs = Stream.of(scp).mapToInt(x -> x.dom.last()).toArray();
    }

    @Override
    public boolean runPropagator(Variable x) {
        if (x.dom.size() == 1) {
            int a = x.dom.unique();
            if (!this.fixedIdxs.isPresent(a)) {
                this.fixedIdxs.add(a, this.pb.solver.depth());
            }
            int v = x.dom.uniqueValue();
            for (int i = this.futvars.limit; i >= 0; --i) {
                Variable y = this.scp[this.futvars.dense[i]];
                if (y == x || y.dom.removeValue(v, false)) continue;
                return false;
            }
        }
        int pos = this.positionOf(x);
        if (x.dom.first() == this.storedMins[pos] && x.dom.last() == this.storedMaxs[pos]) {
            return true;
        }
        this.nDecisionsAtLastCall = this.pb.solver.stats.nDecisions;
        ++this.time;
        this.minReasoner.initialize();
        this.maxReasoner.initialize();
        if (!this.minReasoner.findIntervals(x)) {
            return false;
        }
        if (!this.maxReasoner.findIntervals(x)) {
            return false;
        }
        for (int i = this.futvars.limit; i >= 0; --i) {
            int y = this.futvars.dense[i];
            this.storedMins[y] = this.scp[y].dom.first();
            this.storedMaxs[y] = this.scp[y].dom.last();
        }
        return true;
    }

    class HallIntervalStored {
        boolean[][] matrix;
        ArrayList<Integer>[] t;

        void restoreAtDepthBefore(int depthBeforeBacktrack) {
            ArrayList<Integer> list = this.t[depthBeforeBacktrack];
            for (int i = 0; i < list.get(0); ++i) {
                assert (this.matrix[list.get(i * 2 + 1)][list.get(i * 2 + 2)]);
                this.matrix[list.get((int)(i * 2 + 1)).intValue()][list.get((int)(i * 2 + 2)).intValue()] = false;
            }
            list.clear();
            list.add(0);
        }

        HallIntervalStored(int d, int nLevels) {
            this.matrix = new boolean[d][d];
            this.t = (ArrayList[])IntStream.range(0, nLevels).mapToObj(i -> new ArrayList<Integer>(Arrays.asList(0))).toArray(ArrayList[]::new);
        }

        void add(int a, int b, int level) {
            assert (!this.matrix[a][b]);
            this.matrix[a][b] = true;
            ArrayList<Integer> list = this.t[level];
            list.set(0, list.get(0) + 1);
            list.add(a);
            list.add(b);
        }

        public String toString() {
            String s = IntStream.rangeClosed(0, AllDifferentBound.this.pb.solver.depth()).mapToObj(i -> this.t[i]).filter(l -> l.size() > 0).map(l -> l.toString()).collect(Collectors.joining(" "));
            return s;
        }
    }

    class MaxBoundReasoner
    extends BoundReasoner {
        MaxBoundReasoner() {
        }

        @Override
        boolean findIntervals(Variable x) {
            for (int b = this.from; b <= this.to; ++b) {
                Fixed1 f1 = this.fixed1[b];
                if (!f1.isPresent()) continue;
                this.collectedVars.clear();
                int nFixed = 0;
                int end = b;
                for (int a = f1.to; a >= f1.from; --a) {
                    assert (a < b);
                    Fixed2 edge = f1.edges[a];
                    if (!edge.isPresent()) continue;
                    edge.addCollectedVarsToSet(this.collectedVars);
                    end = a - 1;
                    this.absentIdxs.clear();
                    int nVals = b - a + 1 - (nFixed += this.nFixedBetween(a, end)) - this.absentIdxs.size();
                    if (this.collectedVars.size() > nVals) {
                        return x.dom.fail();
                    }
                    if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                    AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.pb.solver.depth());
                    int nValuesBefore = AllDifferentBound.this.pb.nValuesRemoved;
                    for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                        int y = AllDifferentBound.this.futvars.dense[i];
                        if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                        return false;
                    }
                    int nRemoved = AllDifferentBound.this.pb.nValuesRemoved - nValuesBefore;
                    nb += nRemoved;
                }
                int nV = b - f1.from + 1 - nFixed - this.absentIdxs.size();
                if (nV + 1 < this.collectedVars.size()) continue;
                int a = f1.from;
                for (int bb = b - 1; bb > a; --bb) {
                    Fixed2 edge;
                    f1 = this.fixed1[bb];
                    if (!f1.isPresent() || !(edge = f1.edges[a]).isPresent()) continue;
                    edge.addCollectedVarsToSet(this.collectedVars);
                    this.absentIdxs.clear();
                    this.collectAbsentBetween(a, b);
                    int nVals = b - a + 1 - nFixed - this.absentIdxs.size();
                    if (this.collectedVars.size() > nVals) {
                        return x.dom.fail();
                    }
                    if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                    AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.pb.solver.depth());
                    int nValuesBefore = AllDifferentBound.this.pb.nValuesRemoved;
                    for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                        int y = AllDifferentBound.this.futvars.dense[i];
                        if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                        return false;
                    }
                    int nRemoved = AllDifferentBound.this.pb.nValuesRemoved - nValuesBefore;
                    nb += nRemoved;
                }
            }
            return true;
        }
    }

    class MinBoundReasoner
    extends BoundReasoner {
        MinBoundReasoner() {
        }

        @Override
        boolean findIntervals(Variable x) {
            for (int a = this.to; a >= this.from; --a) {
                Fixed1 f1 = this.fixed1[a];
                if (!f1.isPresent()) continue;
                this.collectedVars.clear();
                int nFixed = 0;
                int start = a;
                for (int b = f1.from; b <= f1.to; ++b) {
                    Fixed2 edge = f1.edges[b];
                    if (!edge.isPresent()) continue;
                    edge.addCollectedVarsToSet(this.collectedVars);
                    start = b + 1;
                    this.absentIdxs.clear();
                    int nVals = b - a + 1 - (nFixed += this.nFixedBetween(start, b)) - this.absentIdxs.size();
                    if (this.collectedVars.size() > nVals) {
                        return x.dom.fail();
                    }
                    if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                    AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.pb.solver.depth());
                    int nValuesBefore = AllDifferentBound.this.pb.nValuesRemoved;
                    for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                        int y = AllDifferentBound.this.futvars.dense[i];
                        if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                        return false;
                    }
                    int nRemoved = AllDifferentBound.this.pb.nValuesRemoved - nValuesBefore;
                    nb += nRemoved;
                }
                int nV = f1.to - a + 1 - nFixed - this.absentIdxs.size();
                if (nV + 1 < this.collectedVars.size()) continue;
                int b = f1.to;
                for (int aa = a + 1; aa < b; ++aa) {
                    Fixed2 edge;
                    f1 = this.fixed1[aa];
                    if (!f1.isPresent() || !(edge = f1.edges[b]).isPresent()) continue;
                    edge.addCollectedVarsToSet(this.collectedVars);
                    this.absentIdxs.clear();
                    this.collectAbsentBetween(a, b);
                    int nVals = b - a + 1 - nFixed - this.absentIdxs.size();
                    if (this.collectedVars.size() > nVals) {
                        return x.dom.fail();
                    }
                    if (nVals >= AllDifferentBound.this.scp.length || this.collectedVars.size() != nVals || AllDifferentBound.this.storer.matrix[a][b]) continue;
                    AllDifferentBound.this.storer.add(a, b, AllDifferentBound.this.pb.solver.depth());
                    int nValuesBefore = AllDifferentBound.this.pb.nValuesRemoved;
                    for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                        int y = AllDifferentBound.this.futvars.dense[i];
                        if (this.collectedVars.isPresent(y) || AllDifferentBound.this.scp[y].dom.size() <= 1 || this.remove(AllDifferentBound.this.scp[y].dom, a, b)) continue;
                        return false;
                    }
                    int nRemoved = AllDifferentBound.this.pb.nValuesRemoved - nValuesBefore;
                    nb += nRemoved;
                }
            }
            return true;
        }
    }

    abstract class BoundReasoner {
        SetSparse collectedVars;
        SetSparse absentIdxs;
        final Fixed1[] fixed1;
        int from;
        int to;

        BoundReasoner() {
            this.collectedVars = new SetSparse(AllDifferentBound.this.scp.length);
            this.absentIdxs = new SetSparse(AllDifferentBound.this.scp.length);
            this.fixed1 = new Fixed1[AllDifferentBound.this.d];
            if (this instanceof MinBoundReasoner) {
                IntStream.range(0, AllDifferentBound.this.d - 1).forEach(i -> {
                    this.fixed1[i] = new Fixed1(i + 1, AllDifferentBound.this.d - 1);
                });
            } else {
                IntStream.range(1, AllDifferentBound.this.d).forEach(i -> {
                    this.fixed1[i] = new Fixed1(0, i - 1);
                });
            }
        }

        void initialize() {
            this.from = AllDifferentBound.this.scp.length;
            this.to = -1;
            for (int i = AllDifferentBound.this.futvars.limit; i >= 0; --i) {
                int b;
                int x = AllDifferentBound.this.futvars.dense[i];
                if (AllDifferentBound.this.scp[x].dom.size() == 1) continue;
                int first = AllDifferentBound.this.scp[x].dom.first();
                int last = AllDifferentBound.this.scp[x].dom.last();
                int a = this instanceof MinBoundReasoner ? first : last;
                int n = b = a == first ? last : first;
                if (a < this.from) {
                    this.from = a;
                }
                if (a > this.to) {
                    this.to = a;
                }
                this.fixed1[a].add(b, x);
            }
        }

        int nFixedBetween(int a, int b) {
            int nb = 0;
            for (int k = a; k <= b; ++k) {
                if (!AllDifferentBound.this.fixedIdxs.isPresent(k)) continue;
                ++nb;
            }
            return nb;
        }

        boolean isAlwaysAbsent(int k) {
            for (int i = this.collectedVars.limit; i >= 0; --i) {
                if (!AllDifferentBound.this.scp[this.collectedVars.dense[i]].dom.isPresent(k)) continue;
                return false;
            }
            return true;
        }

        void collectAbsentBetween(int a, int b) {
            for (int k = a; k <= b; ++k) {
                if (AllDifferentBound.this.fixedIdxs.isPresent(k) || !this.isAlwaysAbsent(k)) continue;
                this.absentIdxs.add(k);
            }
        }

        abstract boolean findIntervals(Variable var1);

        public String toString() {
            return "minToMax=" + (this instanceof MinBoundReasoner) + " from=" + this.from + " to=" + this.to + "\n" + IntStream.rangeClosed(this.from, this.to).filter(i -> this.fixed1[i].isPresent()).mapToObj(i -> i + "-> " + this.fixed1[i]).collect(Collectors.joining("\n\n"));
        }

        boolean remove(Domain dom, int from, int to) {
            for (int a = from; a <= to; ++a) {
                if (this.absentIdxs.isPresent(a) || dom.remove(a, false)) continue;
                return false;
            }
            return true;
        }
    }

    class Fixed1 {
        int time;
        int from;
        int to;
        final Fixed2[] edges;

        Fixed1(int possibleFrom, int possibleTo) {
            this.edges = (Fixed2[])IntStream.range(0, AllDifferentBound.this.d).mapToObj(i -> possibleFrom <= i && i <= possibleTo ? new Fixed2() : null).toArray(Fixed2[]::new);
        }

        boolean isPresent() {
            return this.time == AllDifferentBound.this.time;
        }

        void add(int bnd, int x) {
            if (!this.isPresent()) {
                this.time = AllDifferentBound.this.time;
                this.from = AllDifferentBound.this.scp.length;
                this.to = -1;
            }
            if (bnd < this.from) {
                this.from = bnd;
            }
            if (bnd > this.to) {
                this.to = bnd;
            }
            this.edges[bnd].add(x);
        }

        public String toString() {
            return !this.isPresent() ? "" : "from=" + this.from + " to=" + this.to + "\n\t" + IntStream.rangeClosed(this.from, this.to).filter(i -> this.edges[i].isPresent()).mapToObj(i -> i + ": " + this.edges[i]).collect(Collectors.joining("\n\t"));
        }
    }

    class Fixed2 {
        int time;
        int cnt;
        int[] collectedVarPositions;

        Fixed2() {
            this.collectedVarPositions = new int[AllDifferentBound.this.scp.length];
        }

        boolean isPresent() {
            return this.time == AllDifferentBound.this.time;
        }

        void addCollectedVarsToSet(SetSparse set) {
            for (int i = 0; i < this.cnt; ++i) {
                set.add(this.collectedVarPositions[i]);
            }
        }

        void add(int x) {
            if (!this.isPresent()) {
                this.time = AllDifferentBound.this.time;
                this.cnt = 0;
            }
            assert (!Utilities.contains((int[])this.collectedVarPositions, (int)x, (int)0, (int)(this.cnt - 1)));
            this.collectedVarPositions[this.cnt++] = x;
        }

        public String toString() {
            return !this.isPresent() ? "" : "time=" + this.time + " cnt=" + this.cnt + " vars=" + Kit.join((Object)this.collectedVarPositions, this.cnt, new String[0]);
        }
    }
}

