/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.ExtensionStructureHard;
import variables.Variable;

public class Tries
extends ExtensionStructureHard {
    private Node[] trieRoots;
    private int currentTrieIndex;
    private int[] tmp;
    private boolean directAccess;
    private int[] current;

    private void addTuple(Node node, int[] tuple, int position) {
        if (position == tuple.length) {
            return;
        }
        int adjustedPosition = position == 0 ? this.currentTrieIndex : (position <= this.currentTrieIndex ? position - 1 : position);
        int idx = this.firstRegisteredCtr().indexesMatchValues ? tuple[adjustedPosition] : this.firstRegisteredCtr().scp[adjustedPosition].dom.toIdx(tuple[adjustedPosition]);
        Node previousChild = null;
        Node currentChild = node.firstChild;
        while (currentChild != null && currentChild.idx <= idx) {
            previousChild = currentChild;
            currentChild = currentChild.firstSibling;
        }
        Node child = null;
        if (previousChild == null) {
            node.firstChild = child = new Node(idx, node, node.firstChild);
        } else if (previousChild.idx == idx) {
            child = previousChild;
        } else {
            previousChild.firstSibling = child = new Node(idx, node, previousChild.firstSibling);
        }
        this.addTuple(child, tuple, position + 1);
    }

    private void buildChildsArrays(Node node, int position) {
        if (position == this.trieRoots.length) {
            return;
        }
        int adjustedPosition = position == 0 ? this.currentTrieIndex : (position <= this.currentTrieIndex ? position - 1 : position);
        Variable var = this.firstRegisteredCtr().scp[adjustedPosition];
        node.childs = new Node[var.dom.initSize()];
        Node child = node.firstChild;
        while (child != null) {
            node.childs[child.idx] = child;
            this.buildChildsArrays(child, position + 1);
            child = child.firstSibling;
        }
    }

    @Override
    public void storeTuples(int[][] tuples, boolean allowedTuples) {
        int i;
        for (i = 0; i < this.trieRoots.length; ++i) {
            this.currentTrieIndex = i;
            for (int[] tuple : tuples) {
                this.addTuple(this.trieRoots[i], tuple, 0);
            }
        }
        assert (this.controlNode(this.trieRoots[0].firstChild, 0));
        if (this.directAccess) {
            for (i = 0; i < this.trieRoots.length; ++i) {
                this.currentTrieIndex = i;
                this.buildChildsArrays(this.trieRoots[i], 0);
            }
        }
    }

    public Tries(Constraint ctr, boolean directAccess) {
        super(ctr);
        this.directAccess = directAccess;
        this.trieRoots = new Node[ctr.scp.length];
        for (int i = 0; i < this.trieRoots.length; ++i) {
            this.trieRoots[i] = new Node(-1, null);
        }
        this.tmp = new int[this.trieRoots.length];
    }

    @Override
    public boolean checkIdxs(int[] idxs) {
        return this.nextSupport(0, idxs[0], idxs) == idxs;
    }

    private int[] seekNextTuple(Node node, int position) {
        int i;
        int[] t;
        if (position == this.current.length) {
            return this.current;
        }
        int realPosition = position <= this.currentTrieIndex ? position - 1 : position;
        int idx = this.current[realPosition];
        Node child = null;
        if (this.directAccess) {
            child = node.childs[idx];
            if (child != null) {
                t = this.seekNextTuple(child, position + 1);
                if (t != null) {
                    return t;
                }
                child = child.firstSibling;
                if (child == null) {
                    return null;
                }
            } else {
                child = node.firstChild;
                while (child != null && child.idx < idx) {
                    child = child.firstSibling;
                }
                if (child == null) {
                    return null;
                }
            }
        } else {
            child = node.firstChild;
            while (child != null && child.idx < idx) {
                child = child.firstSibling;
            }
            if (child != null && child.idx == idx) {
                t = this.seekNextTuple(child, position + 1);
                if (t != null) {
                    return t;
                }
                child = child.firstSibling;
            }
            if (child == null) {
                return null;
            }
        }
        for (i = 1; i < position; ++i) {
            realPosition = i <= this.currentTrieIndex ? i - 1 : i;
            this.tmp[realPosition] = this.current[realPosition];
        }
        for (i = position; i < this.current.length; ++i) {
            this.tmp[i <= this.currentTrieIndex ? i - 1 : i] = child.idx;
            child = child.firstChild;
        }
        return this.tmp;
    }

    @Override
    public int[] nextSupport(int vap, int idx, int[] current) {
        this.currentTrieIndex = vap;
        this.current = current;
        this.tmp[vap] = idx;
        if (this.directAccess) {
            Node child = this.trieRoots[this.currentTrieIndex].childs[idx];
            if (child == null) {
                return null;
            }
            return this.seekNextTuple(child, 1);
        }
        Node child = this.trieRoots[this.currentTrieIndex].firstChild;
        while (child != null && child.idx < idx) {
            child = child.firstSibling;
        }
        if (child == null || child.idx > idx) {
            return null;
        }
        return this.seekNextTuple(child, 1);
    }

    public int display(Node node, int position) {
        System.out.println(position + " " + node.idx);
        int sum = position == this.trieRoots.length - 1 ? 1 : 0;
        Node child = node.firstChild;
        while (child != null) {
            sum += this.display(child, position + 1);
            child = child.firstSibling;
        }
        return sum;
    }

    public void display() {
        for (int i = 0; i < this.trieRoots.length; ++i) {
            System.out.println(" Position " + i);
            int cpt = this.display(this.trieRoots[i], -1);
            System.out.println("Nb tuples = " + cpt);
        }
    }

    private boolean controlNode(Node node, int position) {
        if (node == null) {
            return true;
        }
        if (!this.firstRegisteredCtr().scp[position].dom.isPresent(node.idx)) {
            return false;
        }
        if (!this.controlNode(node.firstSibling, position)) {
            return false;
        }
        return this.controlNode(node.firstChild, position + 1);
    }

    class Node {
        int idx;
        Node parent;
        Node firstChild;
        Node firstSibling;
        Node[] childs;

        Node(int idx, Node parent) {
            this.idx = idx;
            this.parent = parent;
        }

        Node(int idx, Node parent, Node firstSibling) {
            this(idx, parent);
            this.firstSibling = firstSibling;
        }
    }
}

