/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.Table;
import java.util.Arrays;
import java.util.List;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import utility.Kit;
import variables.Variable;

public class TableWithSubtables
extends Table {
    public int[][][][] subtables;

    @Override
    public int[] nextSupport(int x, int a, int[] current) {
        int[][] subtable = this.subtables[x][a];
        int res = Arrays.binarySearch(subtable, current, Utilities.lexComparatorInt);
        if (res >= 0) {
            return current;
        }
        int point = -res - 1;
        return point == subtable.length ? null : subtable[point];
    }

    protected void buildStructures() {
        int j;
        int i;
        Constraint c = this.firstRegisteredCtr();
        List<E>[][] tmp = Variable.litterals(c.scp).listArray();
        for (i = 0; i < this.tuples.length; ++i) {
            for (j = 0; j < this.tuples[i].length; ++j) {
                tmp[j][this.tuples[i][j]].add(this.tuples[i]);
            }
        }
        this.subtables = new int[c.scp.length][][][];
        for (i = 0; i < this.subtables.length; ++i) {
            this.subtables[i] = new int[c.scp[i].dom.initSize()][][];
            for (j = 0; j < this.subtables[i].length; ++j) {
                this.subtables[i][j] = (int[][])tmp[i][j].toArray((T[])new int[tmp[i][j].size()][]);
            }
        }
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        super.storeTuples(tuples, positive);
        this.buildStructures();
        assert (this.controlOrder());
    }

    public TableWithSubtables(Constraint c) {
        super(c);
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder(super.toString());
        sb.append("Subtables\n");
        for (int i = 0; i < this.subtables.length; ++i) {
            sb.append("Variable " + this.firstRegisteredCtr().scp[i] + "\n");
            for (int j = 0; j < this.subtables[i].length; ++j) {
                sb.append("  " + j + " :");
                for (int k = 0; k < this.subtables[i][j].length; ++k) {
                    sb.append(" (" + Kit.join((Object)this.subtables[i][j][k], new String[0]) + ")");
                }
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    protected boolean controlOrder() {
        return IntStream.range(0, this.subtables.length).allMatch(i -> IntStream.range(0, this.subtables[i].length).allMatch(j -> Kit.isLexIncreasing(this.subtables[i][j])));
    }
}

