/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.Table;
import java.util.Arrays;
import java.util.TreeSet;
import org.xcsp.common.Utilities;
import utility.Kit;
import variables.Variable;
import variables.domains.Domain;

public final class TableCompressed3
extends Table {
    private static final int MINIMAL_PATTERN_SIZE = 3;
    private int scoreThreshold = 50;
    private int nPatterns = 500;
    public int[][] patterns;
    private int[] tmp;
    public static int compression;

    private TreeSet<Kit.IntArrayWithScore> buildPatterns(int[][] tuples, int nbDifferentValues) {
        int i;
        Node[] roots = new Node[tuples[0].length];
        int minSize = 3;
        int maxSize = roots.length - 1;
        for (i = minSize; i <= maxSize; ++i) {
            roots[i] = new Node(nbDifferentValues);
        }
        for (i = 0; i < tuples.length; ++i) {
            for (int size = minSize; size <= maxSize; ++size) {
                for (int position = 0; position <= tuples[i].length - size; ++position) {
                    roots[size].add(i, tuples[i], position, position + size, size);
                }
            }
        }
        TreeSet<Kit.IntArrayWithScore> patternsTree = new TreeSet<Kit.IntArrayWithScore>();
        for (int i2 = minSize; i2 <= maxSize; ++i2) {
            roots[i2].collectPatterns(patternsTree, new int[i2], 0);
        }
        return patternsTree;
    }

    private int search(int[] tuple, int position) {
        for (int i = 1; i < this.patterns.length; ++i) {
            if (!Kit.isSubtuple(this.patterns[i], tuple, position)) continue;
            return i;
        }
        return -1;
    }

    public void compressTableFrom(TreeSet<Kit.IntArrayWithScore> patternsTree) {
        this.patterns = new int[patternsTree.size() + 1][];
        int cnt = 1;
        for (Kit.IntArrayWithScore o : patternsTree) {
            this.patterns[cnt++] = o.t;
        }
        int[] tmp = new int[this.tuples[0].length];
        for (int i = 0; i < this.tuples.length; ++i) {
            int length = 0;
            int position = 0;
            while (position < this.tuples[i].length) {
                int patternIndex = this.search(this.tuples[i], position);
                if (patternIndex != -1) {
                    tmp[length++] = -patternIndex;
                    position += this.patterns[patternIndex].length;
                    continue;
                }
                tmp[length++] = this.tuples[i][position++];
            }
            if (length == this.tuples[i].length) continue;
            compression += this.tuples[i].length - length;
            assert (this.controlCompression(this.tuples[i], tmp, length));
            this.tuples[i] = new int[length];
            System.arraycopy(tmp, 0, this.tuples[i], 0, length);
        }
    }

    private boolean controlCompression(int[] tuple, int[] tmp, int length) {
        int[] compressedTuple = new int[length];
        System.arraycopy(tmp, 0, compressedTuple, 0, length);
        return Utilities.lexComparatorInt.compare(this.decompress(compressedTuple), tuple) == 0;
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        Constraint ctr = this.firstRegisteredCtr();
        if (tuples.length == 0) {
            this.tuples = tuples;
        } else if (ctr.indexesMatchValues) {
            this.tuples = Kit.cloneDeeply(tuples);
        } else {
            this.tuples = new int[tuples.length][tuples[0].length];
            for (int j = 0; j < tuples[0].length; ++j) {
                Domain dom = ctr.scp[j].dom;
                for (int i = 0; i < tuples.length; ++i) {
                    this.tuples[i][j] = dom.toIdx(tuples[i][j]);
                }
            }
        }
        this.positive = positive;
        this.tmp = new int[ctr.scp.length];
        Arrays.sort(this.tuples, Utilities.lexComparatorInt);
        TreeSet<Kit.IntArrayWithScore> patternsTree = this.buildPatterns(tuples, Variable.maxInitDomSize(this.firstRegisteredCtr().scp));
        this.compressTableFrom(patternsTree);
    }

    public TableCompressed3(Constraint ctr) {
        super(ctr);
    }

    public int[] decompress(int[] tuple) {
        int gap = 0;
        for (int pos = 0; pos < tuple.length; ++pos) {
            int val = tuple[pos];
            if (val >= 0) {
                this.tmp[gap + pos] = val;
                continue;
            }
            int[] pattern = this.patterns[-val];
            for (int i = pattern.length - 1; i >= 0; --i) {
                this.tmp[gap + pos + i] = pattern[i];
            }
            gap += pattern.length - 1;
        }
        return this.tmp;
    }

    @Override
    public boolean checkIdxs(int[] t) {
        int min = 0;
        int max = this.tuples.length - 1;
        while (min <= max) {
            int med = (min + max) / 2;
            int res = Utilities.lexComparatorInt.compare(t, this.decompress(this.tuples[med]));
            if (res == 0) {
                return true;
            }
            if (res < 0) {
                max = med - 1;
            }
            if (res <= 0) continue;
            min = med + 1;
        }
        return false;
    }

    @Override
    public String toString() {
        return "Tuples : " + Kit.join((Object)this.tuples, new String[0]);
    }

    class Leaf
    extends Node {
        private int lastTupleId;
        private int lastPosition;
        private int[] ranks;

        protected Leaf(int length) {
            this.lastTupleId = -1;
            this.lastPosition = -1;
            this.ranks = new int[length];
        }

        @Override
        protected void add(int tupleId, int[] tuple, int position, int limit, int size) {
            assert (position == limit);
            if (tupleId != this.lastTupleId) {
                this.lastTupleId = tupleId;
                int n = this.lastPosition = position - size;
                this.ranks[n] = this.ranks[n] + 1;
            } else if (this.lastPosition + size - 1 < position - size) {
                int n = this.lastPosition = position - size;
                this.ranks[n] = this.ranks[n] + 1;
            }
        }

        private int computeScoreFromRanks() {
            int sum = 0;
            for (int val : this.ranks) {
                sum += Math.max(0, val - 1);
            }
            return sum;
        }

        @Override
        protected void collectPatterns(TreeSet<Kit.IntArrayWithScore> patternsTree, int[] collect, int dummy) {
            int score = collect.length * this.computeScoreFromRanks();
            if (score >= TableCompressed3.this.scoreThreshold) {
                if (patternsTree.size() < TableCompressed3.this.nPatterns) {
                    patternsTree.add(new Kit.IntArrayWithScore((int[])collect.clone(), score));
                } else {
                    Kit.IntArrayWithScore o = patternsTree.first();
                    if (score > o.score) {
                        patternsTree.pollFirst();
                        patternsTree.add(new Kit.IntArrayWithScore((int[])collect.clone(), score));
                    }
                }
            }
        }
    }

    class Node {
        private Node[] childs;

        protected Node() {
        }

        Node(int nbChilds) {
            this.childs = new Node[nbChilds];
        }

        protected void add(int tupleId, int[] tuple, int position, int limit, int size) {
            if (this.childs[tuple[position]] == null) {
                this.childs[tuple[position]] = position == limit - 1 ? new Leaf(tuple.length) : new Node(this.childs.length);
            }
            this.childs[tuple[position]].add(tupleId, tuple, position + 1, limit, size);
        }

        protected void collectPatterns(TreeSet<Kit.IntArrayWithScore> patternsTree, int[] collect, int position) {
            for (int i = 0; i < this.childs.length; ++i) {
                if (this.childs[i] == null) continue;
                collect[position] = i;
                this.childs[i].collectPatterns(patternsTree, collect, position + 1);
            }
        }
    }
}

