/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.MDD;
import constraints.hard.extension.structures.MDDNode;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import variables.Variable;

public class TableCompressed1
extends ExtensionStructureHard {
    protected boolean positive;
    protected int[][][] compressedTuples;
    Map<Kit.IntArrayHashKey, MDDNode> map;

    public boolean isPositive() {
        return this.positive;
    }

    public int[][][] getCompressedTuples() {
        return this.compressedTuples;
    }

    public int[][] getCompressedTuple(int i) {
        return this.compressedTuples[i];
    }

    private MDDNode rec(MDDNode node) {
        if (node.isLeaf()) {
            return node;
        }
        MDDNode[] childs = node.sons;
        for (int i = 0; i < childs.length; ++i) {
            childs[i] = this.rec(childs[i]);
        }
        int[] t = new int[childs.length];
        for (int i = 0; i < childs.length; ++i) {
            t[i] = childs[i].id;
        }
        Kit.IntArrayHashKey hk = new Kit.IntArrayHashKey(t);
        return this.map.computeIfAbsent(hk, k -> node);
    }

    private void reduce(MDDNode node, int[] previousTuple, int[] currentTuple) {
        int i = 0;
        while (previousTuple[i] == currentTuple[i]) {
            node = node.sons[previousTuple[i]];
            ++i;
        }
        node.sons[previousTuple[i]] = this.rec(node.sons[previousTuple[i]]);
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        int i;
        Kit.control(positive && tuples.length > 0);
        Constraint ctr = this.firstRegisteredCtr();
        int[] domainSizes = Variable.domSizeArrayOf(ctr.scp, true);
        this.map = new HashMap<Kit.IntArrayHashKey, MDDNode>(2000);
        int[] previousTuple = null;
        int[] currentTuple = new int[tuples[0].length];
        MDD mdd = new MDD(null);
        MDDNode root = new MDDNode(mdd, 0, domainSizes[0], positive);
        if (ctr.indexesMatchValues) {
            for (i = 0; i < tuples.length; ++i) {
                currentTuple = tuples[i];
                root.addTuple(currentTuple, positive, domainSizes);
                if (previousTuple == null) {
                    previousTuple = (int[])currentTuple.clone();
                    continue;
                }
                this.reduce(root, previousTuple, currentTuple);
                int[] tmp = previousTuple;
                previousTuple = currentTuple;
                currentTuple = tmp;
            }
        } else {
            for (i = 0; i < tuples.length; ++i) {
                for (int j = 0; j < currentTuple.length; ++j) {
                    currentTuple[j] = ctr.scp[j].dom.toIdx(tuples[i][j]);
                }
                root.addTuple(currentTuple, positive, domainSizes);
                if (previousTuple == null) {
                    previousTuple = (int[])currentTuple.clone();
                    continue;
                }
                this.reduce(root, previousTuple, currentTuple);
                int[] tmp = previousTuple;
                previousTuple = currentTuple;
                currentTuple = tmp;
            }
            System.out.println("mapsize = " + this.map.size());
        }
        this.positive = positive;
        root.buildSonsClasses();
        LinkedList<int[][]> list = new LinkedList<int[][]>();
        root.collectCompressedTuples(list, new int[ctr.scp.length][], 0);
        System.out.println("cnt=" + list.size());
        this.compressedTuples = Kit.intArray3D(list);
    }

    private void display(int[][][] compressedTuples) {
        for (int i = 0; i < compressedTuples.length; ++i) {
            for (int j = 0; j < compressedTuples[i].length; ++j) {
                System.out.print("{" + Kit.join((Object)compressedTuples[i][j], new String[0]) + "}" + (j < compressedTuples[i].length - 1 ? "x" : ""));
            }
            System.out.println();
        }
    }

    public TableCompressed1(Constraint ctr) {
        super(ctr);
    }

    public TableCompressed1(Constraint ctr, TableCompressed1 t) {
        this(ctr);
        this.compressedTuples = Kit.cloneDeeply(t.compressedTuples);
        this.positive = t.positive;
    }

    @Override
    public boolean checkIdxs(int[] idxs) {
        throw new MissingImplementationException();
    }
}

