/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.Table;
import java.util.List;
import utility.Kit;
import variables.Variable;

public class SubTable
extends Table {
    public int[][][] subtables;
    public short[][][] subtablesShort;

    protected void buildSubtables() {
        Constraint ctr = this.firstRegisteredCtr();
        if (this.tuples.length >= Short.MAX_VALUE) {
            List<E>[][] tmp = Variable.litterals(ctr.scp).listArray();
            for (int i = 0; i < this.tuples.length; ++i) {
                for (int j = 0; j < this.tuples[i].length; ++j) {
                    tmp[j][this.tuples[i][j]].add(i);
                }
            }
            this.subtables = Kit.intArray3D(tmp);
        } else {
            List<E>[][] tmp = Variable.litterals(ctr.scp).listArray();
            for (int i = 0; i < this.tuples.length; ++i) {
                for (int j = 0; j < this.tuples[i].length; ++j) {
                    tmp[j][this.tuples[i][j]].add((short)i);
                }
            }
            this.subtablesShort = Kit.shortArray3D(tmp);
        }
    }

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        super.storeTuples(tuples, positive);
        this.buildSubtables();
    }

    public SubTable(Constraint c) {
        super(c);
    }

    @Override
    public String toString() {
        int j;
        int i;
        StringBuilder sb = new StringBuilder();
        if (this.subtables != null) {
            for (i = 0; i < this.subtables.length; ++i) {
                sb.append("Variable " + this.firstRegisteredCtr().scp[i] + "\n");
                for (j = 0; j < this.subtables[i].length; ++j) {
                    sb.append("  " + j + " : " + Kit.join((Object)this.subtables[i][j], new String[0]) + "\n");
                }
            }
        }
        if (this.subtablesShort != null) {
            for (i = 0; i < this.subtablesShort.length; ++i) {
                sb.append("Variable " + this.firstRegisteredCtr().scp[i] + "\n");
                for (j = 0; j < this.subtablesShort[i].length; ++j) {
                    sb.append("  " + j + " : " + Kit.join((Object)this.subtablesShort[i][j], new String[0]) + "\n");
                }
            }
        }
        return sb.toString();
    }
}

