/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import constraints.Constraint;
import constraints.hard.extension.structures.ExtensionStructureHard;
import utility.Kit;

public class Matrix3D
extends ExtensionStructureHard {
    protected boolean[][][] supports;

    @Override
    public void storeTuples(int[][] tuples, boolean positive) {
        Constraint c = this.firstRegisteredCtr();
        this.supports = new boolean[c.doms[0].initSize()][c.doms[1].initSize()][c.doms[2].initSize()];
        if (!positive) {
            for (int i = 0; i < this.supports.length; ++i) {
                for (int j = 0; j < this.supports[i].length; ++j) {
                    for (int k = 0; k < this.supports[i][j].length; ++k) {
                        this.supports[i][j][k] = true;
                    }
                }
            }
        }
        if (c.indexesMatchValues) {
            for (int[] tuple : tuples) {
                this.supports[tuple[0]][tuple[1]][tuple[2]] = positive;
            }
        } else {
            for (int[] tuple : tuples) {
                this.supports[c.doms[0].toIdx((int)tuple[0])][c.doms[1].toIdx((int)tuple[1])][c.doms[2].toIdx((int)tuple[2])] = positive;
            }
        }
    }

    public Matrix3D(Constraint c) {
        super(c);
        assert (c.scp.length == 3);
    }

    public Matrix3D(Constraint c, Matrix3D matrix3D) {
        this(c);
        this.supports = Kit.cloneDeeply(matrix3D.supports);
    }

    @Override
    public final boolean checkIdxs(int[] t) {
        return this.supports[t[0]][t[1]][t[2]];
    }

    @Override
    public boolean removeTuple(int[] tuple) {
        assert (this.registeredCtrs().size() == 1);
        int a = tuple[0];
        int b = tuple[1];
        int c = tuple[2];
        if (!this.supports[a][b][c]) {
            return false;
        }
        this.supports[a][b][c] = false;
        this.incrementNbTuplesRemoved();
        return true;
    }
}

