/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension.structures;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.structures.Transitions;
import utility.Kit;

public final class MDDNodeCD {
    public static int nBuiltNodes;
    public static final MDDNodeCD nodeF;
    public static final MDDNodeCD nodeT;
    public static final int N_SONS = 27;
    private static boolean discardClassForNodeF;
    public int id = nBuiltNodes++;
    public MDDNodeCD[] sons = new MDDNodeCD[27];
    public int[] dense;
    public int size;
    public int[][] sonsClasses;
    private Integer nSonsDifferentFromNodeF;

    public static MDDNodeCD copy(MDDNodeCD node) {
        return node == nodeT ? nodeT : new MDDNodeCD(node, new HashMap<Integer, MDDNodeCD>());
    }

    public static MDDNodeCD or(int level, MDDNodeCD node1, MDDNodeCD node2) {
        int v1;
        MDDNodeCD node = new MDDNodeCD();
        int i1 = 0;
        int i2 = 0;
        while (i1 < node1.size && i2 < node2.size) {
            v1 = node1.dense[i1];
            int v2 = node2.dense[i2];
            if (v1 < v2) {
                node.insert(v1, MDDNodeCD.copy(node1.sons[v1]));
                ++i1;
                continue;
            }
            if (v1 > v2) {
                node.insert(v2, MDDNodeCD.copy(node2.sons[v2]));
                ++i2;
                continue;
            }
            node.insert(v1, MDDNodeCD.or(level + 1, node1.sons[v1], node2.sons[v2]));
            ++i1;
            ++i2;
        }
        while (i1 < node1.size) {
            v1 = node1.dense[i1];
            node.insert(v1, MDDNodeCD.copy(node1.sons[v1]));
            ++i1;
        }
        while (i2 < node2.size) {
            int v2 = node2.dense[i2];
            node.insert(v2, MDDNodeCD.copy(node2.sons[v2]));
            ++i2;
        }
        return node;
    }

    public int nSonsDifferentFromNodeF() {
        return this.nSonsDifferentFromNodeF != null ? this.nSonsDifferentFromNodeF : (this.nSonsDifferentFromNodeF = Integer.valueOf((int)Stream.of(this.sons).filter(c -> c != nodeF).count()));
    }

    public void insert(int v, MDDNodeCD node) {
        if (this.sons[v] == nodeF) {
            int i;
            for (i = 0; i < this.size && this.dense[i] < v; ++i) {
            }
            assert (i >= this.size || this.dense[i] != v) : v + " " + i;
            for (int j = this.size; j > i; --j) {
                this.dense[j] = this.dense[j - 1];
            }
            this.dense[i] = v;
            ++this.size;
        }
        this.sons[v] = node;
    }

    public String name() {
        return this == nodeF ? "nodeF" : (this == nodeT ? "nodeT" : "n" + this.id);
    }

    public final boolean isLeaf() {
        return this == nodeF || this == nodeT;
    }

    public MDDNodeCD() {
        Arrays.fill(this.sons, nodeF);
        this.dense = new int[27];
        this.size = 0;
    }

    public MDDNodeCD(MDDNodeCD node, Map<Integer, MDDNodeCD> map) {
        this();
        for (int i = 0; i < node.size; ++i) {
            int v = node.dense[i];
            MDDNodeCD son = node.sons[v];
            assert (son != nodeF);
            if (son == nodeT) {
                this.insert(v, nodeT);
                continue;
            }
            if (map.containsKey(son.id)) {
                this.insert(v, map.get(son.id));
                continue;
            }
            MDDNodeCD clone = new MDDNodeCD(son, map);
            map.put(son.id, clone);
            this.insert(v, clone);
        }
    }

    public void buildSonsClasses() {
        if (this.isLeaf() || this.sonsClasses != null) {
            return;
        }
        Map<MDDNodeCD, List<Integer>> map = IntStream.range(0, this.sons.length).filter(i -> !discardClassForNodeF || this.sons[i] != nodeF).boxed().collect(Collectors.groupingBy(i -> this.sons[i]));
        this.sonsClasses = (int[][])map.values().stream().map(list -> Kit.intArray(list)).toArray(x$0 -> new int[x$0][]);
        Stream.of(this.sons).forEach(s -> s.buildSonsClasses());
    }

    public boolean similarTo(MDDNodeCD other) {
        if (this.size != other.size) {
            return false;
        }
        for (int i = 0; i < this.size; ++i) {
            if (this.dense[i] == other.dense[i] && this.sons[this.dense[i]].id == other.sons[this.dense[i]].id) continue;
            return false;
        }
        return true;
    }

    public int signature() {
        int result = 1;
        for (int i = 0; i < this.size; ++i) {
            result = 31 * result + this.dense[i];
            result = 31 * result + this.sons[this.dense[i]].id;
        }
        return result;
    }

    private void addTuple(int level, int[] tuple) {
        int v = tuple[level];
        if (level == tuple.length - 1) {
            this.insert(v, nodeT);
        } else {
            if (this.sons[v] == nodeF) {
                this.insert(v, new MDDNodeCD());
            }
            this.sons[v].addTuple(level + 1, tuple);
        }
    }

    public void addTuple(int[] tuple) {
        this.addTuple(0, tuple);
    }

    public void renameNodeIds(int offset, Map<Integer, MDDNodeCD> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return;
        }
        this.id += offset;
        map.put(this.id, this);
        for (int i = 0; i < this.size; ++i) {
            this.sons[this.dense[i]].renameNodeIds(offset, map);
        }
    }

    public void replaceTrueNode(MDDNodeCD newNode) {
        if (this.isLeaf()) {
            return;
        }
        for (int i = 0; i < this.size; ++i) {
            int v = this.dense[i];
            if (this.sons[v] == nodeT) {
                this.sons[v] = newNode;
                continue;
            }
            if (this.sons[v] == newNode) continue;
            this.sons[v].replaceTrueNode(newNode);
        }
    }

    public int renameNodes(int lastId, Map<Integer, MDDNodeCD> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return lastId;
        }
        this.id = ++lastId;
        map.put(this.id, this);
        for (int i = 0; i < this.size; ++i) {
            lastId = this.sons[this.dense[i]].renameNodes(lastId, map);
        }
        return lastId;
    }

    public int nInternalNodes(Set<Integer> set) {
        if (this.isLeaf() || set.contains(this.id)) {
            return 0;
        }
        set.add(this.id);
        int sum = 1;
        for (int i = 0; i < this.size; ++i) {
            sum += this.sons[this.dense[i]].nInternalNodes(set);
        }
        return sum;
    }

    public void transitions(Transitions trs, Map<Integer, MDDNodeCD> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return;
        }
        map.put(this.id, this);
        for (int i = 0; i < this.size; ++i) {
            int v = this.dense[i];
            trs.add(this.id == 2 ? "r" : "n" + this.id, (Object)v, "n" + this.sons[v].id);
            this.sons[v].transitions(trs, map);
        }
    }

    public int displayTuples(int cnt, List<Integer> list) {
        if (this.isLeaf()) {
            System.out.println(Kit.join(list, new String[0]));
            return cnt + 1;
        }
        for (int i = 0; i < this.size; ++i) {
            int v = this.dense[i];
            list.add(v);
            cnt = this.sons[v].displayTuples(cnt, list);
            list.remove(list.size() - 1);
        }
        return cnt;
    }

    public void display(int level, Map<Integer, MDDNodeCD> map) {
        if (this.isLeaf() || map.get(this.id) == this) {
            return;
        }
        map.put(this.id, this);
        System.out.println(this.id + "@" + level + " => {" + IntStream.range(0, this.size).mapToObj(i -> this.dense[i] + ":" + this.sons[this.dense[i]].id).collect(Collectors.joining(",")) + "}");
        IntStream.range(0, this.size).filter(i -> this.sons[this.dense[i]].id > this.id).forEach(i -> this.sons[this.dense[i]].display(level + 1, map));
    }

    static {
        nodeF = new MDDNodeCD();
        nodeT = new MDDNodeCD();
        discardClassForNodeF = true;
    }
}

