/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.Constraint;
import constraints.hard.CtrExtension;
import constraints.hard.extension.structures.ExtensionStructureHard;
import constraints.hard.extension.structures.SmartTuple;
import constraints.hard.extension.structures.TableSmart;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.modeler.definitions.DefXCSP;
import org.xcsp.modeler.definitions.ICtr;
import org.xcsp.modeler.definitions.IRootForCtrAndObj;
import problem.Problem;
import propagation.order1.StrongConsistency;
import utility.Kit;
import utility.interfaces.FilteringGlobal;
import utility.interfaces.TagGuaranteedGAC;
import utility.observers.ObserverBacktrackingSystematic;
import utility.sets.SetDenseReversible;
import utility.sets.SetSparse;
import variables.Variable;
import variables.domains.Domain;

public final class CtrExtensionSmart
extends CtrExtension
implements FilteringGlobal,
TagGuaranteedGAC,
ObserverBacktrackingSystematic,
ICtr.ICtrSmart {
    private static final int UNINITIALIZED_VALUE = Integer.MAX_VALUE;
    protected int lastDepth;
    protected int[] lastSizes;
    protected int[][] lastSizesStack;
    private boolean backtrack;
    public final SmartTuple[] smartTuples;
    protected SetDenseReversible set;
    public SetSparse[] unsupported;
    protected int sValSize;
    protected int[] sVal;
    protected int sSupSize;
    protected int[] sSup;
    protected long lastCallNode;

    public static Constraint buildAllEqual(Problem pb, Variable[] list) {
        SmartTuple st = new SmartTuple(IntStream.range(1, list.length).mapToObj(i -> XNodeParent.eq((Object[])new Object[]{list[0], list[i]})).collect(Collectors.toList()));
        return new CtrExtensionSmart(pb, list, st);
    }

    public static Constraint buildNotAllEqual(Problem pb, Variable[] list) {
        SmartTuple[] sts = (SmartTuple[])IntStream.range(1, list.length).mapToObj(i -> new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ne((Object[])new Object[]{list[0], list[i]}))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, list, sts);
    }

    public static Constraint buildAtMost1(Problem pb, Variable[] list, Variable value) {
        Kit.control(!Kit.isPresent(value, list), () -> "Not handled for the moment");
        SmartTuple[] smartTuples = (SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new SmartTuple(IntStream.range(0, list.length).filter(j -> j != i).mapToObj(j -> XNodeParent.ne((Object[])new Object[]{value, list[j]})).collect(Collectors.toList()))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, (Variable[])pb.distinctSorted(pb.vars(new Object[]{list, value})), smartTuples);
    }

    public static Constraint buildElement(Problem pb, Variable[] list, Variable index, Variable value) {
        Kit.control(index.dom.firstValue() == 0 && !Kit.isPresent(value, list), () -> "Not handled for the moment");
        SmartTuple[] sts = (SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{index, i}), (XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{list[i], value}))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, (Variable[])pb.distinctSorted(pb.vars(new Object[]{list, index, value})), sts);
    }

    public static Constraint buildMinimum(Problem pb, Variable[] list, Variable min) {
        Kit.control(!Kit.isPresent(min, list), () -> "Not handled for the moment");
        SmartTuple[] smartTuples = (SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new SmartTuple(IntStream.range(0, list.length).mapToObj(j -> j != i ? XNodeParent.le((Object)list[i], (Object)list[j]) : XNodeParent.eq((Object[])new Object[]{list[i], min})).collect(Collectors.toList()))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, (Variable[])pb.distinctSorted(pb.vars(new Object[]{list, min})), smartTuples);
    }

    public static Constraint buildMaximum(Problem pb, Variable[] list, Variable max) {
        Kit.control(!Kit.isPresent(max, list), () -> "Not handled for the moment");
        SmartTuple[] smartTuples = (SmartTuple[])IntStream.range(0, list.length).mapToObj(i -> new SmartTuple(IntStream.range(0, list.length).mapToObj(j -> j != i ? XNodeParent.ge((Object)list[i], (Object)list[j]) : XNodeParent.eq((Object[])new Object[]{list[i], max})).collect(Collectors.toList()))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, (Variable[])pb.distinctSorted(pb.vars(new Object[]{list, max})), smartTuples);
    }

    public static Constraint buildLexicographicL(Problem pb, Variable[] t1, Variable[] t2, boolean strict) {
        Kit.control(t1.length == t2.length);
        SmartTuple[] smartTuples = (SmartTuple[])IntStream.range(0, t1.length).mapToObj(i -> new SmartTuple(IntStream.range(0, i + 1).mapToObj(j -> j < i ? XNodeParent.eq((Object[])new Object[]{t1[j], t2[j]}) : (i == t1.length - 1 ? XNodeParent.le((Object)t1[i], (Object)t2[i]) : XNodeParent.lt((Object)t1[i], (Object)t2[i]))).collect(Collectors.toList()))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, (Variable[])pb.distinctSorted(pb.vars(new Object[]{t1, t2})), smartTuples);
    }

    public static Constraint buildNoOverlap(Problem pb, Variable x1, Variable x2, int w1, int w2) {
        SmartTuple st1 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ge((Object)x2, (Object)XNodeParent.add((Object[])new Object[]{x1, w1})));
        SmartTuple st2 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ge((Object)x1, (Object)XNodeParent.add((Object[])new Object[]{x2, w2})));
        return new CtrExtensionSmart(pb, (Variable[])pb.vars(new Object[]{x1, x2}), st1, st2);
    }

    public static Constraint buildNoOverlap(Problem pb, Variable x1, Variable y1, Variable x2, Variable y2, int w1, int h1, int w2, int h2) {
        SmartTuple st1 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ge((Object)x2, (Object)XNodeParent.add((Object[])new Object[]{x1, w1})));
        SmartTuple st2 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ge((Object)x1, (Object)XNodeParent.add((Object[])new Object[]{x2, w2})));
        SmartTuple st3 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ge((Object)y2, (Object)XNodeParent.add((Object[])new Object[]{y1, h1})));
        SmartTuple st4 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ge((Object)y1, (Object)XNodeParent.add((Object[])new Object[]{y2, h2})));
        return new CtrExtensionSmart(pb, (Variable[])pb.vars(new Object[]{x1, y1, x2, y2}), st1, st2, st3, st4);
    }

    public static Constraint buildNoOverlap(Problem pb, Variable x1, Variable y1, Variable x2, Variable y2, Variable w1, Variable h1, Variable w2, Variable h2) {
        Kit.control(w1.dom.size() == 2 && h1.dom.size() == 2 && w2.dom.size() == 2 && h2.dom.size() == 2);
        SmartTuple st1 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{w1, w1.dom.firstValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)x2, (Object)XNodeParent.add((Object[])new Object[]{x1, w1.dom.firstValue()})));
        SmartTuple st2 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{w1, w1.dom.lastValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)x2, (Object)XNodeParent.add((Object[])new Object[]{x1, w1.dom.lastValue()})));
        SmartTuple st3 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{w2, w2.dom.firstValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)x1, (Object)XNodeParent.add((Object[])new Object[]{x2, w2.dom.firstValue()})));
        SmartTuple st4 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{w2, w2.dom.lastValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)x1, (Object)XNodeParent.add((Object[])new Object[]{x2, w2.dom.lastValue()})));
        SmartTuple st5 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{h1, h1.dom.firstValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)y2, (Object)XNodeParent.add((Object[])new Object[]{y1, h1.dom.firstValue()})));
        SmartTuple st6 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{h1, h1.dom.lastValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)y2, (Object)XNodeParent.add((Object[])new Object[]{y1, h1.dom.lastValue()})));
        SmartTuple st7 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{h2, h2.dom.firstValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)y1, (Object)XNodeParent.add((Object[])new Object[]{y2, h2.dom.firstValue()})));
        SmartTuple st8 = new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.eq((Object[])new Object[]{h2, h2.dom.lastValue()}), (XNodeParent<? extends IVar>)XNodeParent.ge((Object)y1, (Object)XNodeParent.add((Object[])new Object[]{y2, h2.dom.lastValue()})));
        return new CtrExtensionSmart(pb, (Variable[])pb.vars(new Object[]{x1, y1, x2, y2, w1, h1, w2, h2}), st1, st2, st3, st4, st5, st6, st7, st8);
    }

    public static Constraint buildDistinctVectors(Problem pb, Variable[] t1, Variable[] t2) {
        Kit.control(t1.length == t2.length);
        Variable[] tt1 = IntStream.range(0, t1.length).anyMatch(i -> t1[i] == t2[i]) ? (Variable[])IntStream.range(0, t1.length).filter(i -> t1[i] != t2[i]).mapToObj(i -> t1[i]).toArray(Variable[]::new) : t1;
        Variable[] tt2 = IntStream.range(0, t1.length).anyMatch(i -> t1[i] == t2[i]) ? (Variable[])IntStream.range(0, t1.length).filter(i -> t1[i] != t2[i]).mapToObj(i -> t2[i]).toArray(Variable[]::new) : t2;
        Kit.control(tt1.length == tt2.length);
        SmartTuple[] smartTuples = (SmartTuple[])IntStream.range(0, tt1.length).mapToObj(i -> new SmartTuple((XNodeParent<? extends IVar>)XNodeParent.ne((Object[])new Object[]{tt1[i], tt2[i]}))).toArray(SmartTuple[]::new);
        return new CtrExtensionSmart(pb, (Variable[])pb.distinctSorted(pb.vars(new Object[]{tt1, tt2})), smartTuples);
    }

    protected void initRestorationStructuresBeforeFiltering() {
        int depth = this.pb.solver.depth();
        assert (depth >= this.lastDepth && this.lastDepth >= 0) : depth + " " + this.lastDepth;
        for (int i = this.lastDepth + 1; i <= depth; ++i) {
            System.arraycopy(this.lastSizesStack[this.lastDepth], 0, this.lastSizesStack[i], 0, this.lastSizesStack[this.lastDepth].length);
        }
        this.lastSizes = this.lastSizesStack[depth];
        this.lastDepth = depth;
    }

    @Override
    public void restoreAtDepthBefore(int depthBeforeBacktrack) {
        this.set.restoreLimitAtLevel(depthBeforeBacktrack);
        this.lastDepth = Math.max(0, Math.min(this.lastDepth, depthBeforeBacktrack - 1));
        this.backtrack = true;
    }

    public CtrExtensionSmart(Problem pb, Variable[] scp, SmartTuple ... smartTuples) {
        super(pb, scp);
        this.smartTuples = smartTuples;
        this.extStructure = this.buildExtensionStructure();
        this.unsupported = (SetSparse[])IntStream.range(0, scp.length).mapToObj(i -> new SetSparse(scp[i].dom.initSize(), true)).toArray(SetSparse[]::new);
        Stream.of(smartTuples).forEach(st -> st.attach(this));
        this.sVal = new int[scp.length];
        this.sSup = new int[scp.length];
    }

    @Override
    public void onConstructionProblemFinished() {
        super.onConstructionProblemFinished();
        this.set = new SetDenseReversible(this.smartTuples.length, this.pb.variables.length + 1);
        this.lastSizesStack = new int[this.pb.variables.length + 1][this.scp.length];
        Arrays.fill(this.lastSizesStack[0], Integer.MAX_VALUE);
    }

    @Override
    public ExtensionStructureHard buildExtensionStructure() {
        return new TableSmart(this, this.smartTuples);
    }

    protected void manageLastPastVariable() {
        if (this.lastCallNode != this.pb.solver.stats.nAssignments || this.pb.solver.propagation instanceof StrongConsistency) {
            int x;
            this.lastCallNode = this.pb.solver.stats.nAssignments;
            Variable lastPast = this.pb.solver.futVars.lastPast();
            int n = x = lastPast == null ? -1 : this.positionOf(lastPast);
            if (x != -1) {
                this.sVal[this.sValSize++] = x;
            }
        }
    }

    protected void beforeFiltering() {
        this.initRestorationStructuresBeforeFiltering();
        this.sSupSize = 0;
        this.sValSize = 0;
        this.manageLastPastVariable();
        for (int i = this.futvars.limit; i >= 0; --i) {
            int x = this.futvars.dense[i];
            Domain dom = this.scp[x].dom;
            if (dom.size() == this.lastSizes[x]) {
                this.unsupported[x].limit = this.lastSizes[x] - 1;
            } else {
                this.unsupported[x].clear();
                int a = dom.first();
                while (a != -1) {
                    this.unsupported[x].add(a);
                    a = dom.next(a);
                }
                this.backtrack = false;
            }
            int domSize = dom.size();
            if (this.lastSizes[x] != domSize) {
                this.sVal[this.sValSize++] = x;
                this.lastSizes[x] = domSize;
            }
            this.sSup[this.sSupSize++] = x;
        }
    }

    protected boolean updateDomains() {
        for (int i = 0; i < this.sSupSize; ++i) {
            int x = this.sSup[i];
            assert (!this.unsupported[x].isEmpty());
            if (!this.scp[x].dom.remove(this.unsupported[x])) {
                return false;
            }
            this.unsupported[x].moveElementsAt(this.lastSizes[x] - 1);
            this.lastSizes[x] = this.scp[x].dom.size();
        }
        return true;
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        for (int i = this.set.limit; i >= 0; --i) {
            SmartTuple st = this.smartTuples[this.set.dense[i]];
            boolean valid = st.isValid(this.sVal, this.sValSize);
            if (valid) {
                this.sSupSize = st.collect(this.sSup, this.sSupSize);
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        return this.updateDomains();
    }

    @Override
    public Map<String, Object> mapXCSP() {
        String[] rows = (String[])Stream.of(this.smartTuples).map(st -> " (" + IntStream.of(st.prefixWithValues).mapToObj(v -> v == 0x7FFFFFFE ? "*" : v + "").collect(Collectors.joining(",")) + ") : " + st.collectedTreeRestrictions.stream().map(t -> t.toString()).collect(Collectors.joining(" "))).toArray(String[]::new);
        return IRootForCtrAndObj.map((String)"scope", (Object)this.scp, (String)LIST, (Object)this.compactOrdered(this.scp), (String)"rows", (Object)rows);
    }

    public DefXCSP defXCSP() {
        return super.defXCSP();
    }
}

