/*
 * Decompiled with CFR 0.152.
 */
package constraints.hard.extension;

import constraints.hard.extension.CtrExtensionSTR1;
import java.util.List;
import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import problem.Problem;
import propagation.order1.MaxRPWC;
import utility.Kit;
import utility.sets.SetDense;
import utility.sets.SetSparse;
import variables.Variable;

public class CtrExtensionRPWC
extends CtrExtensionSTR1 {
    protected MaxRPWC.Intersection[] intersections;
    private int[] intersectionPositions;
    private int[] lastTargetTimes;
    protected int lastCallTime;
    private SetDense intersectionsToBeChecked;
    private SetSparse leavesToBeUpdated;
    private boolean test = false;

    public void addIntersections(List<MaxRPWC.Intersection> list) {
        this.intersections = list.toArray(new MaxRPWC.Intersection[list.size()]);
        this.intersectionPositions = IntStream.range(0, this.intersections.length).map(i -> Utilities.indexOf((Object)this, (Object[])this.intersections[i].ctrs)).toArray();
        this.lastTargetTimes = Kit.repeat(-1, this.intersections.length);
        this.intersectionsToBeChecked = new SetDense(this.intersections.length);
        this.leavesToBeUpdated = new SetSparse(this.intersections.length, true);
    }

    public CtrExtensionRPWC(Problem pb, Variable[] scp) {
        super(pb, scp);
    }

    protected final boolean checkStampsFor(int[] tuple) {
        int source;
        int i;
        int cursor;
        if (this.intersections == null) {
            return true;
        }
        if (this.test) {
            this.leavesToBeUpdated.fill();
        }
        for (cursor = this.intersectionsToBeChecked.limit; cursor >= 0; --cursor) {
            i = this.intersectionsToBeChecked.dense[cursor];
            source = this.intersectionPositions[i];
            int target = source == 0 ? 1 : 0;
            MaxRPWC.Intersection.Leaf leaf = this.intersections[i].getLeafFor(tuple, source);
            if (leaf.stamps[target] != this.intersections[i].ctrs[target].lastCallTime) {
                return false;
            }
            if (!this.test || leaf.stamps[source] != this.lastCallTime) continue;
            this.leavesToBeUpdated.remove(i);
        }
        if (this.test) {
            for (cursor = this.leavesToBeUpdated.limit; cursor >= 0; --cursor) {
                i = this.leavesToBeUpdated.dense[cursor];
                source = this.intersectionPositions[i];
                this.intersections[i].getLeafFor((int[])tuple, (int)source).stamps[source] = this.lastCallTime;
            }
        } else {
            for (int i2 = 0; i2 < this.intersections.length; ++i2) {
                int source2 = this.intersectionPositions[i2];
                this.intersections[i2].getLeafFor((int[])tuple, (int)source2).stamps[source2] = this.lastCallTime;
            }
        }
        assert (this.controlStamps(tuple));
        return true;
    }

    private boolean controlStamps(int[] tuple) {
        return IntStream.range(0, this.intersections.length).allMatch(i -> this.intersections[i].getLeafFor((int[])tuple, (int)this.intersectionPositions[i]).stamps[this.intersectionPositions[i]] == this.lastCallTime);
    }

    protected final void setIntersectionsToBeChecked() {
        MaxRPWC maxRPWC = (MaxRPWC)this.pb.solver.propagation;
        if (this.intersections != null) {
            this.lastCallTime = maxRPWC.incrementSpecificTime();
            this.intersectionsToBeChecked.clear();
            for (int i = 0; i < this.intersections.length; ++i) {
                int target;
                int n = target = this.intersectionPositions[i] == 0 ? 1 : 0;
                if (this.intersections[i].ctrs[target].lastCallTime <= maxRPWC.lastBacktrackSpecificTime || this.lastTargetTimes[i] == this.intersections[i].ctrs[target].lastCallTime) continue;
                this.intersectionsToBeChecked.add(i);
            }
        }
    }

    protected final void updateLastTargetTimes() {
        if (this.intersections != null) {
            for (int cursor = this.intersectionsToBeChecked.limit; cursor >= 0; --cursor) {
                int i = this.intersectionsToBeChecked.dense[cursor];
                int target = this.intersectionPositions[i] == 0 ? 1 : 0;
                this.lastTargetTimes[i] = this.intersections[i].ctrs[target].lastCallTime;
            }
        }
    }

    @Override
    public boolean runPropagator(Variable dummy) {
        this.pb.stuff.updateStatsForSTR(this.set);
        int depth = this.pb.solver.depth();
        this.beforeFiltering();
        this.setIntersectionsToBeChecked();
        for (int i = this.set.limit; i >= 0; --i) {
            int[] tuple = this.tuples[this.set.dense[i]];
            if (this.isValid(tuple) && this.checkStampsFor(tuple)) {
                for (int j = this.futvars.limit; j >= 0; --j) {
                    int x = this.futvars.dense[j];
                    int a = tuple[x];
                    if (this.ac[x][a]) continue;
                    --this.cnt;
                    int n = x;
                    this.cnts[n] = this.cnts[n] - 1;
                    this.ac[x][a] = true;
                }
                continue;
            }
            this.set.removeAtPosition(i, depth);
        }
        this.updateLastTargetTimes();
        return this.updateDomains();
    }
}

