/*
 * Decompiled with CFR 0.152.
 */
package constraints;

import constraints.Constraint;
import dashboard.ControlPanel;
import problem.Problem;
import propagation.Propagation;
import propagation.soft.sac.SoftAC;
import propagation.structures.supporters.SupporterSoftBary;
import propagation.structures.supporters.SupporterSoftNary;
import utility.Kit;
import utility.exceptions.MissingImplementationException;
import utility.interfaces.FilteringSpecific;
import variables.Variable;

public abstract class CtrSoft
extends Constraint {
    public CtrSoft(Problem problem, Variable[] scope) {
        super(problem, scope);
        this.buildSupporter();
    }

    @Override
    public void buildSupporter() {
        ControlPanel cfg = this.pb.rs.cp;
        if (cfg.propagating.residues != (this.supporter != null)) {
            this.supporter = cfg.propagating.residues && this.scp.length > 1 && !(this instanceof FilteringSpecific) ? (this.scp.length == 2 ? new SupporterSoftBary(this) : new SupporterSoftNary(this)) : null;
        }
    }

    public abstract long getHighestInitialCost();

    public int[] getMinCostTupleFor(int vap, int idx) {
        throw new MissingImplementationException();
    }

    public int[] getMinFullCostTupleFor(int targetPosition, int targetIndex, int sourcePosition) {
        throw new MissingImplementationException();
    }

    public long getDiffCostOfIndexes(int[] tuple, int vap, int idx, long ub) {
        throw new MissingImplementationException();
    }

    public long getMinDiffCostTupleFor(int vap, int idx1, int idx2, long ub, long breakLimit) {
        throw new MissingImplementationException();
    }

    @Override
    public final boolean filterFrom(Variable evt) {
        Propagation propagation = this.pb.solver.propagation;
        if (propagation instanceof SoftAC && this.futvars.size() == 0) {
            assert (evt == this.pb.solver.futVars.lastPast());
            return true;
        }
        if (this instanceof FilteringSpecific) {
            if (this.timestamp > evt.timestamp && this.completeFilteringAtEachCall()) {
                return true;
            }
            if (!((FilteringSpecific)((Object)this)).runPropagator(evt)) {
                return false;
            }
        } else if (propagation instanceof SoftAC) {
            for (int i = this.futvars.limit; i >= 0; --i) {
                if (((SoftAC)propagation).revise(this, this.scp[this.futvars.dense[i]])) continue;
                return false;
            }
        }
        this.timestamp = propagation.incrementTime();
        return true;
    }

    public boolean controlCosts() {
        this.tupleManager.firstValidTuple();
        return !this.tupleManager.findValidTupleSuchThat(t -> this.costOfIdxs((int[])t) < 0L);
    }

    public void displayCosts() {
        Kit.log.info(this.toString());
        this.tupleManager.firstValidTuple();
        this.tupleManager.overValidTuples(t -> Kit.log.info(Kit.join(t, new String[0]) + " c=" + this.costOfIdxs((int[])t) + (this.costOfIdxs((int[])t) < 0L ? "************** " : "")));
    }

    @Override
    public boolean isSubstitutableBy(Variable var, int idx1, int idx2) {
        throw new MissingImplementationException();
    }
}

