/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.parser.loaders;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Condition;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Domains;
import org.xcsp.common.domains.Values;
import org.xcsp.common.predicates.EvaluationManager;
import org.xcsp.common.predicates.XNode;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.parser.callbacks.XCallbacks;
import org.xcsp.parser.entries.XConstraints;
import org.xcsp.parser.entries.XVariables;
import org.xcsp.parser.loaders.ConstraintRecognizer;

public class CtrLoaderInteger {
    public static final int N_MAX_VALUES = 10000000;
    private XCallbacks xc;
    private ConstraintRecognizer recognizer;

    static int trInteger(Object l) {
        return Utilities.safeLong2Int((Number)l, true);
    }

    static int[] trIntegers(Object value) {
        if (value instanceof int[]) {
            return (int[])value;
        }
        if (value instanceof Values.IntegerEntity[]) {
            int[] values = Values.IntegerEntity.toIntArray((Values.IntegerEntity[])value, 10000000);
            Utilities.control(values != null, "Too many values. The parser needs an extension.");
            return values;
        }
        return IntStream.range(0, Array.getLength(value)).map(i -> CtrLoaderInteger.trInteger((long)((Long)Array.get(value, i)))).toArray();
    }

    static int[][] build(int size1, int size2, BiFunction<Integer, Integer, Integer> f) {
        return (int[][])IntStream.range(0, size1).mapToObj(i -> IntStream.range(0, size2).map(j -> (Integer)f.apply(i, j)).toArray()).toArray(n -> new int[n][]);
    }

    static int[][] trIntegers2D(Object value) {
        if (value instanceof int[][]) {
            return (int[][])value;
        }
        if (value instanceof byte[][]) {
            byte[][] m = (byte[][])value;
            return CtrLoaderInteger.build(m.length, m[0].length, (i, j) -> m[i][j] == 126 ? 0x7FFFFFFE : m[i][j]);
        }
        if (value instanceof short[][]) {
            short[][] m = (short[][])value;
            return CtrLoaderInteger.build(m.length, m[0].length, (i, j) -> m[i][j] == 32766 ? 0x7FFFFFFE : m[i][j]);
        }
        if (value instanceof long[][]) {
            long[][] m = (long[][])value;
            return CtrLoaderInteger.build(m.length, m[0].length, (i, j) -> m[i][j] == 0x7FFFFFFFFFFFFFFEL ? 0x7FFFFFFE : CtrLoaderInteger.trInteger(m[i][j]));
        }
        if (value instanceof Long[][]) {
            Long[][] m = (Long[][])value;
            return CtrLoaderInteger.build(m.length, m[0].length, (i, j) -> m[i][j] == 0x7FFFFFFFFFFFFFFEL ? 0x7FFFFFFE : CtrLoaderInteger.trInteger(m[i][j]));
        }
        return (int[][])Utilities.exit(value + " was expected to be an object denoting a 2-dimensional array of integers");
    }

    public CtrLoaderInteger(XCallbacks xc) {
        this.xc = xc;
        this.recognizer = new ConstraintRecognizer(xc);
    }

    public void load(XConstraints.XCtr c) {
        switch (c.getType()) {
            case intension: {
                this.intension(c);
                break;
            }
            case extension: {
                this.extension(c);
                break;
            }
            case regular: {
                this.regular(c);
                break;
            }
            case mdd: {
                this.mdd(c);
                break;
            }
            case allDifferent: {
                this.allDifferent(c);
                break;
            }
            case allEqual: {
                this.allEqual(c);
                break;
            }
            case ordered: {
                this.ordered(c);
                break;
            }
            case lex: {
                this.lex(c);
                break;
            }
            case sum: {
                this.sum(c);
                break;
            }
            case count: {
                this.count(c);
                break;
            }
            case nValues: {
                this.nValues(c);
                break;
            }
            case cardinality: {
                this.cardinality(c);
                break;
            }
            case maximum: {
                this.maximum(c);
                break;
            }
            case minimum: {
                this.minimum(c);
                break;
            }
            case element: {
                this.element(c);
                break;
            }
            case channel: {
                this.channel(c);
                break;
            }
            case stretch: {
                this.stretch(c);
                break;
            }
            case noOverlap: {
                this.noOverlap(c);
                break;
            }
            case cumulative: {
                this.cumulative(c);
                break;
            }
            case instantiation: {
                this.instantiation(c);
                break;
            }
            case clause: {
                this.clause(c);
                break;
            }
            case circuit: {
                this.circuit(c);
                break;
            }
            case binPacking: {
                this.binPacking(c);
                break;
            }
            default: {
                this.xc.unimplementedCase(c);
            }
        }
    }

    private boolean intensionToExtension(String id, XVariables.XVarInteger[] scp, XNodeParent<XVariables.XVarInteger> root) {
        int arityLimit = (Integer)this.xc.implem().currParameters.get((Object)XCallbacks.XCallbacksParameters.CONVERT_INTENSION_TO_EXTENSION_ARITY_LIMIT);
        if (scp.length > arityLimit) {
            return false;
        }
        long spaceLimit = (Long)this.xc.implem().currParameters.get((Object)XCallbacks.XCallbacksParameters.CONVERT_INTENSION_TO_EXTENSION_SPACE_LIMIT);
        long size = XVariables.XVarInteger.domainCartesianProductSize(scp);
        if (size == -1L || size > spaceLimit) {
            return false;
        }
        int[][] domValues = (int[][])Stream.of(scp).map(x -> Values.IntegerEntity.toIntArray((Values.IntegerEntity[])((Domains.Dom)x.dom).values, Integer.MAX_VALUE)).toArray(n -> new int[n][]);
        Utilities.ModifiableBoolean b = new Utilities.ModifiableBoolean(null);
        int[][] tuples = new EvaluationManager(root).generateTuples(domValues, b);
        assert (b.value != null);
        if (tuples.length == 0) {
            if (b.value.booleanValue()) {
                this.xc.buildCtrFalse(id, scp);
            } else {
                this.xc.buildCtrTrue(id, scp);
            }
        } else if (scp.length == 1) {
            this.xc.buildCtrExtension(id, scp[0], Stream.of(tuples).mapToInt(t -> t[0]).toArray(), (boolean)b.value, new HashSet<Types.TypeFlag>());
        } else {
            this.xc.buildCtrExtension(id, scp, tuples, (boolean)b.value, new HashSet<Types.TypeFlag>());
        }
        return true;
    }

    private void intension(XConstraints.XCtr c) {
        XNode r = ((XNode)c.childs[0].value).canonization();
        if (r.type == Types.TypeExpr.LONG) {
            Utilities.control(r.val(0) == 0 || r.val(0) == 1, "Bad form of the predicate obtained after canonization");
            if (r.val(0) == 0) {
                this.xc.buildCtrFalse(c.id, c.vars());
            } else {
                this.xc.buildCtrTrue(c.id, c.vars());
            }
            return;
        }
        XNodeParent root = (XNodeParent)r;
        XVariables.XVarInteger[] scope = (XVariables.XVarInteger[])root.vars();
        if (this.xc.implem().currParameters.get((Object)XCallbacks.XCallbacksParameters.RECOGNIZING_BEFORE_CONVERTING) == Boolean.FALSE && this.intensionToExtension(c.id, scope, root)) {
            return;
        }
        if (this.recognizer.specificIntensionCases(c.id, root, scope.length)) {
            return;
        }
        if (this.xc.implem().currParameters.get((Object)XCallbacks.XCallbacksParameters.RECOGNIZING_BEFORE_CONVERTING) == Boolean.TRUE && this.intensionToExtension(c.id, scope, root)) {
            return;
        }
        this.xc.buildCtrIntension(c.id, scope, root);
    }

    private void extension(XConstraints.XCtr c) {
        boolean positive;
        XConstraints.CChild c1 = c.childs[1];
        boolean bl = positive = c1.type == Types.TypeChild.supports;
        if (c1.value == null || Array.getLength(c1.value) == 0) {
            if (positive) {
                this.xc.buildCtrFalse(c.id, c.vars());
            } else {
                this.xc.buildCtrTrue(c.id, c.vars());
            }
        } else {
            XVariables.XVarInteger[] list = (XVariables.XVarInteger[])c.childs[0].value;
            if (list.length == 1) {
                this.xc.buildCtrExtension(c.id, list[0], CtrLoaderInteger.trIntegers(c1.value), positive, (Set<Types.TypeFlag>)c1.flags);
            } else {
                int[][] tuples = this.xc.implem().cache4Tuples.computeIfAbsent(c1.value, k -> CtrLoaderInteger.trIntegers2D(cChild.value));
                this.xc.buildCtrExtension(c.id, list, tuples, positive, (Set<Types.TypeFlag>)c1.flags);
            }
        }
    }

    private void regular(XConstraints.XCtr c) {
        this.xc.buildCtrRegular(c.id, (XVariables.XVarInteger[])c.childs[0].value, (Object[][])c.childs[1].value, (String)c.childs[2].value, (String[])c.childs[3].value);
    }

    private void mdd(XConstraints.XCtr c) {
        this.xc.buildCtrMDD(c.id, (XVariables.XVarInteger[])c.childs[0].value, (Object[][])c.childs[1].value);
    }

    private void allDifferent(XConstraints.XCtr c) {
        XConstraints.CChild[] childs = c.childs;
        if (childs[0].value instanceof XNode[]) {
            Utilities.control(childs.length == 1 && childs[0].type == Types.TypeChild.list, "Other forms not implemented");
            XNode[] trees = (XNode[])childs[0].value;
            this.xc.buildCtrAllDifferent(c.id, trees);
        } else if (childs[0].type == Types.TypeChild.matrix) {
            Utilities.control(childs.length == 1, "Other forms of allDifferent-matrix not implemented");
            this.xc.buildCtrAllDifferentMatrix(c.id, (XVariables.XVarInteger[][])childs[0].value);
        } else if (childs[0].type == Types.TypeChild.list) {
            if (childs.length == 1) {
                this.xc.buildCtrAllDifferent(c.id, (XVariables.XVarInteger[])childs[0].value);
            } else if (childs[1].type == Types.TypeChild.except) {
                this.xc.buildCtrAllDifferentExcept(c.id, (XVariables.XVarInteger[])childs[0].value, CtrLoaderInteger.trIntegers(childs[1].value));
            } else if (childs[childs.length - 1].type == Types.TypeChild.list) {
                this.xc.buildCtrAllDifferentList(c.id, (XVariables.XVarInteger[][])Stream.of(childs).map(p -> p.value).toArray(n -> new XVariables.XVarInteger[n][]));
            } else {
                this.xc.unimplementedCase(c);
            }
        } else {
            this.xc.unimplementedCase(c);
        }
    }

    private void allEqual(XConstraints.XCtr c) {
        if (c.childs[0].type == Types.TypeChild.list) {
            if (c.childs.length == 1) {
                this.xc.buildCtrAllEqual(c.id, (XVariables.XVarInteger[])c.childs[0].value);
            } else {
                this.xc.unimplementedCase(c);
            }
        } else {
            this.xc.unimplementedCase(c);
        }
    }

    private void ordered(XConstraints.XCtr c) {
        if (c.childs[0].type == Types.TypeChild.list) {
            if (c.childs.length == 2) {
                this.xc.buildCtrOrdered(c.id, (XVariables.XVarInteger[])c.childs[0].value, ((Types.TypeOperator)((Object)c.childs[1].value)).toRel());
            } else if (c.childs.length == 3 && c.childs[1].type == Types.TypeChild.lengths) {
                if (c.childs[1].value instanceof XVariables.XVarInteger[]) {
                    this.xc.buildCtrOrdered(c.id, (XVariables.XVarInteger[])c.childs[0].value, (XVariables.XVarInteger[])c.childs[1].value, ((Types.TypeOperator)((Object)c.childs[2].value)).toRel());
                } else {
                    this.xc.buildCtrOrdered(c.id, (XVariables.XVarInteger[])c.childs[0].value, CtrLoaderInteger.trIntegers(c.childs[1].value), ((Types.TypeOperator)((Object)c.childs[2].value)).toRel());
                }
            } else {
                this.xc.unimplementedCase(c);
            }
        } else {
            this.xc.unimplementedCase(c);
        }
    }

    private void lex(XConstraints.XCtr c) {
        Types.TypeOperatorRel op = ((Types.TypeOperator)((Object)c.childs[c.childs.length - 1].value)).toRel();
        if (c.childs[0].type == Types.TypeChild.matrix) {
            this.xc.buildCtrLexMatrix(c.id, (XVariables.XVarInteger[][])c.childs[0].value, op);
        } else {
            this.xc.buildCtrLex(c.id, (XVariables.XVarInteger[][])IntStream.range(0, c.childs.length - 1).mapToObj(i -> xCtr.childs[i].value).toArray(n -> new XVariables.XVarInteger[n][]), op);
        }
    }

    private void sum(XConstraints.XCtr c) {
        Condition condition = (Condition)c.childs[c.childs.length - 1].value;
        if (c.childs[0].value instanceof XNode[]) {
            XNode[] trees = (XNode[])c.childs[0].value;
            if (c.childs.length == 2) {
                this.xc.buildCtrSum(c.id, trees, condition);
            } else if (c.childs[1].value instanceof XVariables.XVarInteger[]) {
                this.xc.buildCtrSum(c.id, trees, (XVariables.XVarInteger[])c.childs[1].value, condition);
            } else {
                this.xc.buildCtrSum(c.id, trees, CtrLoaderInteger.trIntegers(c.childs[1].value), condition);
            }
        } else if (c.childs[0].value instanceof XVariables.XVarInteger[]) {
            XVariables.XVarInteger[] list = (XVariables.XVarInteger[])c.childs[0].value;
            if (c.childs.length == 2) {
                this.xc.buildCtrSum(c.id, list, condition);
            } else if (c.childs[1].value instanceof XVariables.XVarInteger[]) {
                this.xc.buildCtrSum(c.id, list, (XVariables.XVarInteger[])c.childs[1].value, condition);
            } else {
                this.xc.buildCtrSum(c.id, list, CtrLoaderInteger.trIntegers(c.childs[1].value), condition);
            }
        } else {
            XNode[] trees = (XNode[])Stream.of((Object[])c.childs[0].value).map(obj -> obj instanceof XVariables.XVarInteger ? new XNodeLeaf(Types.TypeExpr.VAR, obj) : (XNode)obj).toArray(XNode[]::new);
            this.xc.buildCtrSum(c.id, trees, CtrLoaderInteger.trIntegers(c.childs[1].value), condition);
        }
    }

    private void count(XConstraints.XCtr c) {
        XVariables.XVarInteger[] list = (XVariables.XVarInteger[])c.childs[0].value;
        Condition condition = (Condition)c.childs[2].value;
        if (c.childs[1].value instanceof Long[] && condition instanceof Condition.ConditionRel) {
            Long[] values = (Long[])c.childs[1].value;
            Types.TypeConditionOperatorRel op = ((Condition.ConditionRel)condition).operator;
            if (this.recognizer.specificCountCases(c.id, list, values, op, condition)) {
                return;
            }
            this.xc.buildCtrCount(c.id, list, CtrLoaderInteger.trIntegers(c.childs[1].value), condition);
        } else {
            this.xc.buildCtrCount(c.id, list, (XVariables.XVarInteger[])c.childs[1].value, condition);
        }
    }

    private void nValues(XConstraints.XCtr c) {
        XVariables.XVarInteger[] list = (XVariables.XVarInteger[])c.childs[0].value;
        Condition condition = (Condition)c.childs[c.childs.length - 1].value;
        if (c.childs.length == 2 && this.recognizer.specificNvaluesCases(c.id, list, condition)) {
            return;
        }
        if (c.childs.length == 2) {
            this.xc.buildCtrNValues(c.id, list, condition);
        } else {
            this.xc.buildCtrNValuesExcept(c.id, list, CtrLoaderInteger.trIntegers(c.childs[1].value), condition);
        }
    }

    private void cardinality(XConstraints.XCtr c) {
        XConstraints.CChild[] childs = c.childs;
        Utilities.control(childs[1].value instanceof Long[], "unimplemented case");
        boolean closed = childs[1].getAttributeValue(Types.TypeAtt.closed, false);
        if (childs[1].value instanceof Long[]) {
            if (childs[2].value instanceof Long[]) {
                this.xc.buildCtrCardinality(c.id, (XVariables.XVarInteger[])childs[0].value, closed, CtrLoaderInteger.trIntegers(childs[1].value), CtrLoaderInteger.trIntegers(childs[2].value));
            } else if (childs[2].value instanceof XVariables.XVar[]) {
                this.xc.buildCtrCardinality(c.id, (XVariables.XVarInteger[])childs[0].value, closed, CtrLoaderInteger.trIntegers(childs[1].value), (XVariables.XVarInteger[])childs[2].value);
            } else {
                Utilities.control(childs[2].value instanceof Values.IntegerInterval[], "Pb");
                int[] occursMin = Stream.of((Values.IntegerInterval[])childs[2].value).mapToInt(ii -> Utilities.safeLong2Int(ii.inf, true)).toArray();
                int[] occursMax = Stream.of((Values.IntegerInterval[])childs[2].value).mapToInt(ii -> Utilities.safeLong2Int(ii.sup, true)).toArray();
                this.xc.buildCtrCardinality(c.id, (XVariables.XVarInteger[])childs[0].value, closed, CtrLoaderInteger.trIntegers(childs[1].value), occursMin, occursMax);
            }
        } else if (childs[2].value instanceof Long[]) {
            this.xc.buildCtrCardinality(c.id, (XVariables.XVarInteger[])childs[0].value, closed, (XVariables.XVarInteger[])childs[1].value, CtrLoaderInteger.trIntegers(childs[2].value));
        } else if (childs[2].value instanceof XVariables.XVar[]) {
            this.xc.buildCtrCardinality(c.id, (XVariables.XVarInteger[])childs[0].value, closed, (XVariables.XVarInteger[])childs[1].value, (XVariables.XVarInteger[])childs[2].value);
        } else {
            Utilities.control(childs[2].value instanceof Values.IntegerInterval[], "Pb");
            int[] occursMin = Stream.of((Values.IntegerInterval[])childs[2].value).mapToInt(ii -> Utilities.safeLong2Int(ii.inf, true)).toArray();
            int[] occursMax = Stream.of((Values.IntegerInterval[])childs[2].value).mapToInt(ii -> Utilities.safeLong2Int(ii.sup, true)).toArray();
            this.xc.buildCtrCardinality(c.id, (XVariables.XVarInteger[])childs[0].value, closed, (XVariables.XVarInteger[])childs[1].value, occursMin, occursMax);
        }
    }

    private void minimumMaximum(XConstraints.XCtr c) {
        Condition condition;
        XConstraints.CChild[] childs = c.childs;
        Condition condition2 = condition = childs[childs.length - 1].type == Types.TypeChild.condition ? (Condition)childs[childs.length - 1].value : null;
        if (childs[1].type == Types.TypeChild.condition) {
            if (Arrays.stream((Object[])childs[0].value).allMatch(o -> o instanceof XNode)) {
                XNode[] trees = (XNode[])Arrays.stream((Object[])childs[0].value).map(o -> (XNode)o).toArray(XNode[]::new);
                if (c.getType() == Types.TypeCtr.maximum) {
                    this.xc.buildCtrMaximum(c.id, trees, condition);
                } else {
                    this.xc.buildCtrMinimum(c.id, trees, condition);
                }
            } else {
                XVariables.XVarInteger[] list = (XVariables.XVarInteger[])childs[0].value;
                if (c.getType() == Types.TypeCtr.maximum) {
                    this.xc.buildCtrMaximum(c.id, list, condition);
                } else {
                    this.xc.buildCtrMinimum(c.id, list, condition);
                }
            }
        } else {
            XVariables.XVarInteger[] list = (XVariables.XVarInteger[])childs[0].value;
            int startIndex = childs[0].getAttributeValue(Types.TypeAtt.startIndex, 0);
            Types.TypeRank rank = childs[1].getAttributeValue(Types.TypeAtt.rank, Types.TypeRank.class, Types.TypeRank.ANY);
            if (c.getType() == Types.TypeCtr.maximum) {
                this.xc.buildCtrMaximum(c.id, list, startIndex, (XVariables.XVarInteger)childs[1].value, rank, condition);
            } else {
                this.xc.buildCtrMinimum(c.id, list, startIndex, (XVariables.XVarInteger)childs[1].value, rank, condition);
            }
        }
    }

    private void maximum(XConstraints.XCtr c) {
        this.minimumMaximum(c);
    }

    private void minimum(XConstraints.XCtr c) {
        this.minimumMaximum(c);
    }

    private void element(XConstraints.XCtr c) {
        XConstraints.CChild[] childs = c.childs;
        if (childs[0].value instanceof XVariables.XVarInteger[]) {
            XVariables.XVarInteger[] list = (XVariables.XVarInteger[])childs[0].value;
            if (childs[1].type == Types.TypeChild.value) {
                if (childs[1].value instanceof XVariables.XVar) {
                    this.xc.buildCtrElement(c.id, list, (XVariables.XVarInteger)childs[1].value);
                } else {
                    this.xc.buildCtrElement(c.id, list, CtrLoaderInteger.trInteger(childs[1].value));
                }
            } else {
                int startIndex = childs[0].getAttributeValue(Types.TypeAtt.startIndex, 0);
                Types.TypeRank rank = childs[1].getAttributeValue(Types.TypeAtt.rank, Types.TypeRank.class, Types.TypeRank.ANY);
                if (childs[2].value instanceof XVariables.XVar) {
                    this.xc.buildCtrElement(c.id, list, startIndex, (XVariables.XVarInteger)childs[1].value, rank, (XVariables.XVarInteger)childs[2].value);
                } else {
                    this.xc.buildCtrElement(c.id, list, startIndex, (XVariables.XVarInteger)childs[1].value, rank, CtrLoaderInteger.trInteger(childs[2].value));
                }
            }
        } else if (childs[0].value instanceof Long[]) {
            int[] list = CtrLoaderInteger.trIntegers(c.childs[0].value);
            int startIndex = childs[0].getAttributeValue(Types.TypeAtt.startIndex, 0);
            Types.TypeRank rank = childs[1].getAttributeValue(Types.TypeAtt.rank, Types.TypeRank.class, Types.TypeRank.ANY);
            this.xc.buildCtrElement(c.id, list, startIndex, (XVariables.XVarInteger)childs[1].value, rank, (XVariables.XVarInteger)childs[2].value);
        } else if (childs[0].value instanceof XVariables.XVarInteger[][]) {
            XVariables.XVarInteger[][] matrix = (XVariables.XVarInteger[][])childs[0].value;
            int startRowIndex = childs[0].getAttributeValue(Types.TypeAtt.startRowIndex, 0);
            int startColIndex = childs[0].getAttributeValue(Types.TypeAtt.startColIndex, 0);
            XVariables.XVarInteger[] t = (XVariables.XVarInteger[])childs[1].value;
            assert (t.length == 2);
            if (childs[2].value instanceof XVariables.XVar) {
                this.xc.buildCtrElement(c.id, matrix, startRowIndex, t[0], startColIndex, t[1], (XVariables.XVarInteger)childs[2].value);
            } else {
                this.xc.buildCtrElement(c.id, matrix, startRowIndex, t[0], startColIndex, t[1], CtrLoaderInteger.trInteger(childs[2].value));
            }
        } else {
            assert (childs[0].value instanceof Long[][]);
            int[][] matrix = CtrLoaderInteger.trIntegers2D(childs[0].value);
            int startRowIndex = childs[0].getAttributeValue(Types.TypeAtt.startRowIndex, 0);
            int startColIndex = childs[0].getAttributeValue(Types.TypeAtt.startColIndex, 0);
            XVariables.XVarInteger[] t = (XVariables.XVarInteger[])childs[1].value;
            assert (t.length == 2);
            assert (childs[2].value instanceof XVariables.XVar);
            this.xc.buildCtrElement(c.id, matrix, startRowIndex, t[0], startColIndex, t[1], (XVariables.XVarInteger)childs[2].value);
        }
    }

    private void channel(XConstraints.XCtr c) {
        XVariables.XVarInteger[] list = (XVariables.XVarInteger[])c.childs[0].value;
        int startIndex0 = c.childs[0].getAttributeValue(Types.TypeAtt.startIndex, 0);
        if (c.childs.length == 1) {
            this.xc.buildCtrChannel(c.id, list, startIndex0);
        } else if (c.childs[1].type == Types.TypeChild.list) {
            int startIndex1 = c.childs[1].getAttributeValue(Types.TypeAtt.startIndex, 0);
            this.xc.buildCtrChannel(c.id, list, startIndex0, (XVariables.XVarInteger[])c.childs[1].value, startIndex1);
        } else {
            this.xc.buildCtrChannel(c.id, list, startIndex0, (XVariables.XVarInteger)c.childs[1].value);
        }
    }

    private void stretch(XConstraints.XCtr c) {
        XVariables.XVarInteger[] list = (XVariables.XVarInteger[])c.childs[0].value;
        int[] values = CtrLoaderInteger.trIntegers(c.childs[1].value);
        int[] widthsMin = Stream.of((Values.IntegerInterval[])c.childs[2].value).mapToInt(ii -> Utilities.safeLong2Int(ii.inf, true)).toArray();
        int[] widthsMax = Stream.of((Values.IntegerInterval[])c.childs[2].value).mapToInt(ii -> Utilities.safeLong2Int(ii.sup, true)).toArray();
        if (c.childs.length == 3) {
            this.xc.buildCtrStretch(c.id, list, values, widthsMin, widthsMax);
        } else {
            this.xc.buildCtrStretch(c.id, list, values, widthsMin, widthsMax, CtrLoaderInteger.trIntegers2D(c.childs[3].value));
        }
    }

    private void noOverlap(XConstraints.XCtr c) {
        boolean zeroIgnored = c.getAttributeValue(Types.TypeAtt.zeroIgnored, true);
        if (c.childs[0].value instanceof XVariables.XVarInteger[][]) {
            if (c.childs[1].value instanceof XVariables.XVarInteger[][]) {
                this.xc.buildCtrNoOverlap(c.id, (XVariables.XVarInteger[][])c.childs[0].value, (XVariables.XVarInteger[][])c.childs[1].value, zeroIgnored);
            } else {
                this.xc.buildCtrNoOverlap(c.id, (XVariables.XVarInteger[][])c.childs[0].value, CtrLoaderInteger.trIntegers2D(c.childs[1].value), zeroIgnored);
            }
        } else if (c.childs[1].value instanceof XVariables.XVarInteger[]) {
            this.xc.buildCtrNoOverlap(c.id, (XVariables.XVarInteger[])c.childs[0].value, (XVariables.XVarInteger[])c.childs[1].value, zeroIgnored);
        } else {
            this.xc.buildCtrNoOverlap(c.id, (XVariables.XVarInteger[])c.childs[0].value, CtrLoaderInteger.trIntegers(c.childs[1].value), zeroIgnored);
        }
    }

    private void cumulative(XConstraints.XCtr c) {
        XConstraints.CChild[] childs = c.childs;
        XVariables.XVarInteger[] origins = (XVariables.XVarInteger[])childs[0].value;
        Condition condition = (Condition)childs[childs.length - 1].value;
        if (childs.length == 4) {
            if (childs[1].value instanceof Long[] && childs[2].value instanceof Long[]) {
                this.xc.buildCtrCumulative(c.id, origins, CtrLoaderInteger.trIntegers(childs[1].value), CtrLoaderInteger.trIntegers(childs[2].value), condition);
            } else if (childs[1].value instanceof Long[] && !(childs[2].value instanceof Long[])) {
                this.xc.buildCtrCumulative(c.id, origins, CtrLoaderInteger.trIntegers(childs[1].value), (XVariables.XVarInteger[])childs[2].value, condition);
            } else if (!(childs[1].value instanceof Long[]) && childs[2].value instanceof Long[]) {
                this.xc.buildCtrCumulative(c.id, origins, (XVariables.XVarInteger[])childs[1].value, CtrLoaderInteger.trIntegers(childs[2].value), condition);
            } else {
                this.xc.buildCtrCumulative(c.id, origins, (XVariables.XVarInteger[])childs[1].value, (XVariables.XVarInteger[])childs[2].value, condition);
            }
        } else {
            XVariables.XVarInteger[] ends = (XVariables.XVarInteger[])childs[2].value;
            if (childs[1].value instanceof Long[] && childs[3].value instanceof Long[]) {
                this.xc.buildCtrCumulative(c.id, origins, CtrLoaderInteger.trIntegers(childs[1].value), ends, CtrLoaderInteger.trIntegers(childs[3].value), condition);
            } else if (childs[1].value instanceof Long[] && !(childs[3].value instanceof Long[])) {
                this.xc.buildCtrCumulative(c.id, origins, CtrLoaderInteger.trIntegers(childs[1].value), ends, (XVariables.XVarInteger[])childs[3].value, condition);
            } else if (!(childs[1].value instanceof Long[]) && childs[3].value instanceof Long[]) {
                this.xc.buildCtrCumulative(c.id, origins, (XVariables.XVarInteger[])childs[1].value, ends, CtrLoaderInteger.trIntegers(childs[3].value), condition);
            } else {
                this.xc.buildCtrCumulative(c.id, origins, (XVariables.XVarInteger[])childs[1].value, ends, (XVariables.XVarInteger[])childs[3].value, condition);
            }
        }
    }

    private void instantiation(XConstraints.XCtr c) {
        this.xc.buildCtrInstantiation(c.id, (XVariables.XVarInteger[])c.childs[0].value, CtrLoaderInteger.trIntegers(c.childs[1].value));
    }

    private void clause(XConstraints.XCtr c) {
        Object[] t = (Object[])c.childs[0].value;
        XVariables.XVarInteger[] pos = (XVariables.XVarInteger[])Stream.of(t).filter(o -> o instanceof XVariables.XVar).map(o -> (XVariables.XVar)o).toArray(XVariables.XVarInteger[]::new);
        XVariables.XVarInteger[] neg = (XVariables.XVarInteger[])Stream.of(t).filter(o -> !(o instanceof XVariables.XVar)).map(o -> (XVariables.XVar)((XNodeLeaf)((XNodeParent)o).sons[0]).value).toArray(XVariables.XVarInteger[]::new);
        this.xc.buildCtrClause(c.id, pos, neg);
    }

    private void circuit(XConstraints.XCtr c) {
        XConstraints.CChild[] childs = c.childs;
        XVariables.XVarInteger[] list = (XVariables.XVarInteger[])childs[0].value;
        int startIndex = childs[0].getAttributeValue(Types.TypeAtt.startIndex, 0);
        if (childs.length == 1) {
            this.xc.buildCtrCircuit(c.id, list, startIndex);
        } else if (childs[1].value instanceof XVariables.XVar) {
            this.xc.buildCtrCircuit(c.id, list, startIndex, (XVariables.XVarInteger)childs[1].value);
        } else {
            this.xc.buildCtrCircuit(c.id, list, startIndex, Utilities.safeLong2Int((Long)childs[1].value, true));
        }
    }

    private void binPacking(XConstraints.XCtr c) {
        XConstraints.CChild[] childs = c.childs;
        XVariables.XVarInteger[] list = (XVariables.XVarInteger[])childs[0].value;
        int[] sizes = CtrLoaderInteger.trIntegers(c.childs[1].value);
        if (childs[2].type == Types.TypeChild.condition) {
            this.xc.buildBinPacking(c.id, list, sizes, (Condition)childs[2].value);
        } else {
            this.xc.buildBinPacking(c.id, list, sizes, (Condition[])childs[2].value, childs[2].getAttributeValue(Types.TypeAtt.startIndex, 0));
        }
    }
}

