/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.predicates;

import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.IVar;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.predicates.MatcherInterface;
import org.xcsp.common.predicates.XNodeLeaf;
import org.xcsp.common.predicates.XNodeParent;
import org.xcsp.common.predicates.XNodeParentSpecial;

public abstract class XNode<V extends IVar>
implements Comparable<XNode<V>> {
    public final Types.TypeExpr type;
    public final XNode<V>[] sons;

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, XNode<V> left, XNode<V> right) {
        return new XNodeParent<V>(type, left, right);
    }

    public static <V extends IVar> XNodeParent<V> node(MatcherInterface.AbstractOperation type, XNode<V> left, XNode<V> right) {
        return new XNodeParentSpecial<V>(type.name(), left, right);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, XNode<V> son) {
        return new XNodeParent<V>(type, son);
    }

    public static <V extends IVar> XNodeParent<V> node(MatcherInterface.AbstractOperation type, XNode<V> son) {
        return new XNodeParentSpecial<V>(type.name(), son);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, XNode<V>[] sons) {
        return new XNodeParent<V>(type, sons);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, List<XNode<V>> sons) {
        return new XNodeParent<V>(type, sons);
    }

    public static <V extends IVar> XNodeParent<V> node(Types.TypeExpr type, Stream<XNode<V>> sons) {
        return new XNodeParent(type, (XNode[])sons.toArray(XNode[]::new));
    }

    public static <V extends IVar> XNodeLeaf<V> longLeaf(long value) {
        return new XNodeLeaf(Types.TypeExpr.LONG, value);
    }

    public static <V extends IVar> XNodeLeaf<V> specialLeaf(String value) {
        return new XNodeLeaf(Types.TypeExpr.SPECIAL, value);
    }

    protected XNode(Types.TypeExpr type, XNode<V>[] sons) {
        this.type = type;
        this.sons = sons;
    }

    public final Types.TypeExpr getType() {
        return this.type;
    }

    public final int arity() {
        return this.sons.length;
    }

    public abstract int size();

    public abstract int maxParameterNumber();

    public abstract XNode<V> firstNodeSuchThat(Predicate<XNode<V>> var1);

    public abstract LinkedList<XNode<V>> allNodesSuchThat(Predicate<XNode<V>> var1, LinkedList<XNode<V>> var2);

    public LinkedList<XNode<V>> allNodesSuchThat(Predicate<XNode<V>> p) {
        return this.allNodesSuchThat(p, new LinkedList<XNode<V>>());
    }

    public final LinkedList<V> listOfVars() {
        return this.allNodesSuchThat(s -> s.type == Types.TypeExpr.VAR).stream().map(n -> (IVar)((XNodeLeaf)n).value).collect(Collectors.toCollection(LinkedList::new));
    }

    public final LinkedList<Long> listOfVals() {
        return this.allNodesSuchThat(s -> s.type == Types.TypeExpr.LONG).stream().map(n -> (Long)((XNodeLeaf)n).value).collect(Collectors.toCollection(LinkedList::new));
    }

    public final V[] arrayOfVars() {
        LinkedList list = this.listOfVars();
        return list.size() == 0 ? null : (IVar[])list.stream().toArray(s -> (IVar[])Utilities.buildArray(((IVar)list.iterator().next()).getClass(), s));
    }

    public final int[] arrayOfVals() {
        LinkedList<Long> list = this.listOfVals();
        return list.size() == 0 ? new int[]{} : list.stream().mapToInt(l -> Utilities.safeLong2Int(l, true)).toArray();
    }

    public final V var(int i) {
        if (i == 0) {
            XNodeLeaf f = (XNodeLeaf)this.firstNodeSuchThat(n -> n.type == Types.TypeExpr.VAR);
            return (V)(f == null ? null : (IVar)f.value);
        }
        LinkedList<V> list = this.listOfVars();
        return (V)(i >= list.size() ? null : (IVar)list.get(i));
    }

    public final Integer val(int i) {
        if (i == 0) {
            XNodeLeaf f = (XNodeLeaf)this.firstNodeSuchThat(n -> n.type == Types.TypeExpr.LONG);
            return f == null ? null : Integer.valueOf(Utilities.safeLong2Int((Long)f.value, true));
        }
        LinkedList<Long> list = this.listOfVals();
        return i >= list.size() ? null : Integer.valueOf(Utilities.safeLong2Int(list.get(i), true));
    }

    public final Types.TypeConditionOperatorRel relop(int i) {
        if (i == 0) {
            XNode<V> f = this.firstNodeSuchThat(n -> n.type.isRelationalOperator());
            return f == null ? null : f.type.toRelop();
        }
        LinkedList list = this.allNodesSuchThat(s -> s.type.isRelationalOperator()).stream().map(n -> n.type.toRelop()).collect(Collectors.toCollection(LinkedList::new));
        return i >= list.size() ? null : (Types.TypeConditionOperatorRel)((Object)list.get(i));
    }

    public final Types.TypeArithmeticOperator ariop(int i) {
        if (i == 0) {
            XNode<V> f = this.firstNodeSuchThat(n -> n.type.isArithmeticOperator());
            return f == null ? null : f.type.toAriop();
        }
        LinkedList list = this.allNodesSuchThat(s -> s.type.isArithmeticOperator()).stream().map(n -> n.type.toAriop()).collect(Collectors.toCollection(LinkedList::new));
        return i >= list.size() ? null : (Types.TypeArithmeticOperator)((Object)list.get(i));
    }

    public final V[] vars() {
        LinkedHashSet set = new LinkedHashSet();
        this.listOfVars().stream().forEach(x -> {
            boolean bl = set.add(x);
        });
        return set.size() == 0 ? null : (IVar[])set.stream().toArray(s -> (IVar[])Utilities.buildArray(((IVar)set.iterator().next()).getClass(), s));
    }

    public final boolean exactlyVars(V[] t) {
        IVar[] vars = this.vars();
        return t.length == vars.length && IntStream.range(0, t.length).allMatch(i -> t[i] == vars[i]);
    }

    public final LinkedHashSet<V> collectVarsToSet(LinkedHashSet<V> set) {
        this.listOfVars().stream().forEach(x -> {
            boolean bl = set.add(x);
        });
        return set;
    }

    public abstract XNode<V> replaceSymbols(Map<String, Integer> var1);

    public abstract XNode<V> replaceLeafValues(Function<Object, Object> var1);

    public abstract XNode<V> replacePartiallyParameters(Object[] var1);

    public abstract XNode<V> canonization();

    public abstract XNode<V> abstraction(List<Object> var1, boolean var2, boolean var3);

    public abstract XNode<V> concretization(Object[] var1);

    public abstract String toPostfixExpression(IVar[] var1);

    public abstract String toFunctionalExpression(Object[] var1);

    public String toString() {
        return this.toFunctionalExpression(null);
    }
}

