/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.enumerations;

import java.util.stream.IntStream;
import org.xcsp.common.Utilities;
import org.xcsp.common.enumerations.EnumerationCartesian;

public class EnumerationOfCombinations
extends EnumerationCartesian {
    private final boolean uniform;

    public EnumerationOfCombinations(int[] nValues) {
        super(nValues);
        this.uniform = IntStream.range(1, nValues.length).allMatch(i -> nValues[i] == nValues[0]);
        Utilities.control(IntStream.range(0, nValues.length - 1).allMatch(i -> nValues[i] <= nValues[i + 1]), "Numbers are not in an increasing order");
    }

    public EnumerationOfCombinations(int nValues, int tupleLength) {
        this(IntStream.range(0, tupleLength).map(i -> nValues).toArray());
    }

    @Override
    protected void computeFirstTuple() {
        int i = 0;
        while (this.nextTuple == Boolean.TRUE && i < this.values.length) {
            if (i >= this.values[i].length) {
                this.nextTuple = Boolean.FALSE;
            } else {
                this.currTupleOfIdxs[i] = i;
            }
            ++i;
        }
    }

    private boolean isExtensibleFrom(int pos) {
        if (this.uniform) {
            return this.values[pos].length - this.currTupleOfIdxs[pos] > this.values.length - pos;
        }
        int value = this.currTupleOfIdxs[pos];
        int i = pos;
        while (i < this.currTupleOfIdxs.length) {
            if (++value >= this.values[i].length) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean hasNext() {
        if (this.nextTuple != null) {
            return this.nextTuple == Boolean.TRUE;
        }
        for (int last = this.values.length - 1; last >= 0; --last) {
            if (!this.isExtensibleFrom(last)) {
                continue;
            }
            this.currTupleOfIdxs[last] = this.currTupleOfIdxs[last] + 1;
            int i = last + 1;
            while (i < this.values.length) {
                this.currTupleOfIdxs[i] = this.currTupleOfIdxs[i - 1] + 1;
                ++i;
            }
            this.nextTuple = Boolean.TRUE;
            return true;
        }
        this.nextTuple = Boolean.FALSE;
        return false;
    }

    public static void main(String[] args) {
        new EnumerationOfCombinations(7, 4).displayAllTuples();
        new EnumerationOfCombinations(new int[]{3, 4, 4, 5}).displayAllTuples();
    }
}

