/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common.domains;

import java.util.Arrays;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.Types;
import org.xcsp.common.Utilities;
import org.xcsp.common.domains.Values;

public class Domains {

    public static final class Dom
    extends DomBasic {
        private Long nValues;

        public static String compactFormOf(int[] values) {
            int prevVal;
            StringBuilder sb = new StringBuilder();
            if (values.length == 2) {
                return String.valueOf(values[0]) + " " + values[1];
            }
            int startInterval = prevVal = values[0];
            int i = 1;
            while (i < values.length) {
                int currVal = values[i];
                if (currVal != prevVal + 1) {
                    sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : String.valueOf(startInterval) + (prevVal == startInterval + 1 ? " " : "..") + prevVal).append(" ");
                    startInterval = currVal;
                }
                prevVal = currVal;
                ++i;
            }
            return sb.append(prevVal == startInterval ? Integer.valueOf(prevVal) : String.valueOf(startInterval) + (prevVal == startInterval + 1 ? " " : "..") + prevVal).toString();
        }

        protected Dom(String seq) {
            super(Values.IntegerEntity.parseSeq(seq));
        }

        public Dom(int[] values) {
            super(IntStream.of(values).mapToObj(v -> new Values.IntegerValue(v)).toArray(Values.IntegerEntity[]::new));
        }

        public Dom(int min, int max) {
            super(new Values.IntegerEntity[]{new Values.IntegerInterval(min, max)});
        }

        public long firstValue() {
            return ((Values.IntegerEntity)this.values[0]).smallest();
        }

        public long lastValue() {
            return ((Values.IntegerEntity)this.values[this.values.length - 1]).greatest();
        }

        public boolean contains(long v) {
            int left = 0;
            int right = this.values.length - 1;
            while (left <= right) {
                int center = (left + right) / 2;
                int res = ((Values.IntegerEntity)this.values[center]).compareContains(v);
                if (res == 0) {
                    return true;
                }
                if (res == -1) {
                    left = center + 1;
                    continue;
                }
                right = center - 1;
            }
            return false;
        }

        public long nValues() {
            return this.nValues != null ? this.nValues : (this.nValues = Long.valueOf(Values.IntegerEntity.nValues((Values.IntegerEntity[])this.values)));
        }

        public Dom when(boolean condition) {
            return condition ? this : null;
        }
    }

    public static class DomBasic
    implements IDom {
        public final Object[] values;

        public static DomBasic parse(String s, Types.TypeVar type) {
            return type == Types.TypeVar.integer ? new Dom(s) : (type == Types.TypeVar.symbolic ? new DomSymbolic(s) : (type == Types.TypeVar.real ? new DomReal(s) : DomStochastic.parse(s, type)));
        }

        protected DomBasic(Object[] values) {
            this.values = values;
        }

        public String toString() {
            return this.values.length == 2 ? this.values[0] + " " + this.values[1] : Utilities.join(this.values);
        }
    }

    public static interface DomComplex
    extends IDom {
    }

    public static final class DomGraph
    implements DomComplex {
        public final String[] requiredV;
        public final String[] possibleV;
        public final String[][] requiredE;
        public final String[][] possibleE;

        public static DomGraph parse(String reqV, String reqE, String posV, String posE, Types.TypeVar type) {
            String[] rV = reqV.split("\\s+");
            String[] pV = posV.split("\\s+");
            String[][] rE = (String[][])Stream.of(reqE.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).toArray(n -> new String[n][]);
            String[][] pE = (String[][])Stream.of(posE.split("\\s*\\)\\s*\\(\\s*|\\s*\\(\\s*|\\s*\\)\\s*")).skip(1L).map(tok -> tok.split("\\s*,\\s*")).toArray(n -> new String[n][]);
            return new DomGraph(rV, pV, rE, pE);
        }

        protected DomGraph(String[] requiredV, String[] possibleV, String[][] requiredE, String[][] possibleE) {
            this.requiredV = requiredV;
            this.possibleV = possibleV;
            this.requiredE = requiredE;
            this.possibleE = possibleE;
        }

        public String toString() {
            return "[{" + Utilities.join(this.requiredV) + "-" + Utilities.join(this.requiredE) + "},{" + Utilities.join(this.possibleV) + "-" + Utilities.join(this.possibleE) + "}]";
        }
    }

    public static class DomReal
    extends DomBasic {
        protected DomReal(String seq) {
            super(Values.RealInterval.parseSeq(seq));
        }
    }

    public static final class DomSet
    implements DomComplex {
        public final Object[] required;
        public final Object[] possible;

        public static DomSet parse(String req, String pos, Types.TypeVar type) {
            return type == Types.TypeVar.set ? new DomSet(Values.IntegerEntity.parseSeq(req), Values.IntegerEntity.parseSeq(pos)) : new DomSet(req.split("\\s+"), pos.split("\\s+"));
        }

        protected DomSet(Object[] required, Object[] possible) {
            this.required = required;
            this.possible = possible;
        }

        public String toString() {
            return "[{" + Utilities.join(this.required) + "},{" + Utilities.join(this.possible) + "}]";
        }
    }

    public static final class DomStochastic
    extends DomBasic {
        public final Values.SimpleValue[] probas;

        public static DomStochastic parse(String s, Types.TypeVar type) {
            String[] toks = s.split("\\s+");
            Object[] values = new Object[toks.length];
            Values.SimpleValue[] probas = new Values.SimpleValue[toks.length];
            int i = 0;
            while (i < toks.length) {
                String[] t = toks[i].split(":");
                values[i] = type == Types.TypeVar.symbolic_stochastic ? t[0] : Values.IntegerEntity.parse(t[0]);
                probas[i] = Values.SimpleValue.parse(t[1]);
                ++i;
            }
            return new DomStochastic(values, probas);
        }

        protected DomStochastic(Object[] values, Values.SimpleValue[] probas) {
            super(values);
            this.probas = probas;
            assert (values.length == probas.length);
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + " Probas: " + Utilities.join(this.probas);
        }
    }

    public static final class DomSymbolic
    extends DomBasic {
        protected DomSymbolic(String seq) {
            super(Stream.of(seq.split("\\s+")).sorted().toArray(String[]::new));
        }

        public DomSymbolic(String[] values) {
            super(values);
        }

        public boolean contains(String s) {
            return Arrays.binarySearch(this.values, s) >= 0;
        }
    }

    public static interface IDom {
    }
}

