/*
 * Decompiled with CFR 0.152.
 */
package org.xcsp.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntUnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.xcsp.common.FunctionalInterfaces;
import org.xcsp.common.IVar;
import org.xcsp.common.Utilities;

public class Range
implements Iterable<Integer> {
    public final int startInclusive;
    public final int endExclusive;
    public final int step;

    @Override
    public Iterator<Integer> iterator() {
        return new Iterator<Integer>(){
            int cursor;
            {
                this.cursor = Range.this.startInclusive;
            }

            @Override
            public boolean hasNext() {
                return this.cursor < Range.this.endExclusive;
            }

            @Override
            public Integer next() {
                if (!$assertionsDisabled && !this.hasNext()) {
                    throw new AssertionError();
                }
                int v = this.cursor;
                this.cursor += Range.this.step;
                return v;
            }
        };
    }

    public String toString() {
        return "[" + this.startInclusive + ".." + this.endExclusive + "[" + (this.step == 1 ? "" : "(" + this.step + ")");
    }

    public Range(int startInclusive, int endExclusive, int step) {
        this.startInclusive = startInclusive;
        this.endExclusive = endExclusive;
        this.step = step;
        Utilities.control(step > 0, "Bad values of step : " + step);
    }

    public Range(int startInclusive, int endExclusive) {
        this(startInclusive, endExclusive, 1);
    }

    public Range(int length) {
        this(0, length, 1);
    }

    public Rangesx2 range(int startInclusive, int endExclusive, int step) {
        return new Rangesx2(this, new Range(startInclusive, endExclusive, step));
    }

    public Rangesx2 rangeClosed(int startInclusive, int endInclusive, int step) {
        return this.range(startInclusive, endInclusive + 1, step);
    }

    public Rangesx2 range(int startInclusive, int endExclusive) {
        return new Rangesx2(this, new Range(startInclusive, endExclusive));
    }

    public Rangesx2 rangeClosed(int startInclusive, int endInclusive) {
        return this.range(startInclusive, endInclusive + 1);
    }

    public Rangesx2 range(int length) {
        return new Rangesx2(this, new Range(length));
    }

    public boolean isBasic() {
        return this.startInclusive == 0 && this.step == 1;
    }

    public boolean contains(int i) {
        return this.startInclusive <= i && i < this.endExclusive && (i - this.startInclusive) % this.step == 0;
    }

    public int length() {
        return (this.endExclusive - this.startInclusive) / this.step;
    }

    public int[] select(FunctionalInterfaces.Intx1Predicate p) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : this) {
            if (!p.test(i2)) continue;
            list.add(i2);
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    private <T> List<T> mapToObj(IntFunction<T> op, List<T> list) {
        for (int i : this) {
            T x = op.apply(i);
            if (x == null) continue;
            list.add(x);
        }
        return list;
    }

    public <T> T[] mapToObj(IntFunction<T> f) {
        return Utilities.convert(this.mapToObj(f, new ArrayList()));
    }

    @Deprecated
    public <T extends IVar> T[] provideVars(IntFunction<T> f) {
        return (IVar[])Utilities.convert(this.mapToObj(f, new ArrayList()));
    }

    @Deprecated
    public int[] provideVals(IntFunction<Integer> f) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : this) {
            Integer v = f.apply(i2);
            if (v == null) continue;
            list.add(v);
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    @Deprecated
    public int[][] provideTuples(IntFunction<int[]> f) {
        ArrayList<int[]> list = new ArrayList<int[]>();
        for (int i : this) {
            int[] v = f.apply(i);
            if (v == null) continue;
            list.add(v);
        }
        return (int[][])list.stream().toArray(n -> new int[n][]);
    }

    public int[] map(IntUnaryOperator op) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i2 : this) {
            list.add(op.applyAsInt(i2));
        }
        return list.stream().mapToInt(i -> i).toArray();
    }

    public void execute(IntConsumer c) {
        for (int i : this) {
            c.accept(i);
        }
    }

    public int[] toArray() {
        return this.map(i -> i);
    }

    public IntStream stream() {
        return IntStream.of(this.toArray());
    }

    private static abstract class Ranges {
        public final Range[] items;

        protected Ranges(Range[] items) {
            this.items = items;
        }

        public boolean contains(int ... tuple) {
            Utilities.control(tuple.length == this.items.length, "bad number of indexes");
            return IntStream.range(0, tuple.length).allMatch(i -> this.items[i].contains(tuple[i]));
        }
    }

    public static class Rangesx2
    extends Ranges {
        private Rangesx2(Range range1, Range range2) {
            super(new Range[]{range1, range2});
        }

        public Rangesx3 range(int startInclusive, int endExclusive, int step) {
            return new Rangesx3(this.items[0], this.items[1], new Range(startInclusive, endExclusive, step));
        }

        public Rangesx3 rangeClosed(int startInclusive, int endInclusive, int step) {
            return this.range(startInclusive, endInclusive + 1, step);
        }

        public Rangesx3 range(int startInclusive, int endExclusive) {
            return new Rangesx3(this.items[0], this.items[1], new Range(startInclusive, endExclusive));
        }

        public Rangesx3 rangeClosed(int startInclusive, int endInclusive) {
            return this.range(startInclusive, endInclusive + 1);
        }

        public Rangesx3 range(int length) {
            return new Rangesx3(this.items[0], this.items[1], new Range(length));
        }

        public int[][] select(FunctionalInterfaces.Intx2Predicate p) {
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i : this.items[0]) {
                for (int j : this.items[1]) {
                    if (!p.test(i, j)) continue;
                    list.add(new int[]{i, j});
                }
            }
            return (int[][])list.stream().toArray(n -> new int[n][]);
        }

        public int[][] map(IntBinaryOperator op) {
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i : this.items[0]) {
                list.add(this.items[1].map((int j) -> op.applyAsInt(i, j)));
            }
            return (int[][])list.stream().toArray(n -> new int[n][]);
        }

        public void execute(FunctionalInterfaces.Intx2Consumer c2) {
            for (int i : this.items[0]) {
                this.items[1].execute((int j) -> c2.accept(i, j));
            }
        }

        public int[][] toArray() {
            ArrayList<int[]> list = new ArrayList<int[]>();
            for (int i : this.items[0]) {
                for (int j : this.items[1]) {
                    list.add(new int[]{i, j});
                }
            }
            return (int[][])list.stream().toArray(n -> new int[n][]);
        }

        public Stream<int[]> stream() {
            return Stream.of(this.toArray());
        }
    }

    public static class Rangesx3
    extends Ranges {
        private Rangesx3(Range range1, Range range2, Range range3) {
            super(new Range[]{range1, range2, range3});
        }

        public Rangesx4 range(int startInclusive, int endExclusive, int step) {
            return new Rangesx4(this.items[0], this.items[1], this.items[2], new Range(startInclusive, endExclusive, step));
        }

        public Rangesx4 rangeClosed(int startInclusive, int endInclusive, int step) {
            return this.range(startInclusive, endInclusive + 1, step);
        }

        public Rangesx4 range(int startInclusive, int endExclusive) {
            return new Rangesx4(this.items[0], this.items[1], this.items[2], new Range(startInclusive, endExclusive));
        }

        public Rangesx4 rangeClosed(int startInclusive, int endInclusive) {
            return this.range(startInclusive, endInclusive + 1);
        }

        public Rangesx4 range(int length) {
            return new Rangesx4(this.items[0], this.items[1], this.items[2], new Range(length));
        }

        public void execute(FunctionalInterfaces.Intx3Consumer c3) {
            for (int i : this.items[0]) {
                new Rangesx2(this.items[1], this.items[2]).execute((int j, int k) -> c3.accept(i, j, k));
            }
        }
    }

    public static class Rangesx4
    extends Ranges {
        private Rangesx4(Range range1, Range range2, Range range3, Range range4) {
            super(new Range[]{range1, range2, range3, range4});
        }

        public Rangesx5 range(int startInclusive, int endExclusive, int step) {
            return new Rangesx5(this.items[0], this.items[1], this.items[2], this.items[3], new Range(startInclusive, endExclusive, step));
        }

        public Rangesx5 rangeClosed(int startInclusive, int endInclusive, int step) {
            return this.range(startInclusive, endInclusive + 1, step);
        }

        public Rangesx5 range(int startInclusive, int endExclusive) {
            return new Rangesx5(this.items[0], this.items[1], this.items[2], this.items[3], new Range(startInclusive, endExclusive));
        }

        public Rangesx5 rangeClosed(int startInclusive, int endInclusive) {
            return this.range(startInclusive, endInclusive + 1);
        }

        public Rangesx5 range(int length) {
            return new Rangesx5(this.items[0], this.items[1], this.items[2], this.items[3], new Range(length));
        }

        public void execute(FunctionalInterfaces.Intx4Consumer c4) {
            for (int i : this.items[0]) {
                new Rangesx3(this.items[1], this.items[2], this.items[3]).execute((int j, int k, int l) -> c4.accept(i, j, k, l));
            }
        }
    }

    public static class Rangesx5
    extends Ranges {
        private Rangesx5(Range range1, Range range2, Range range3, Range range4, Range range5) {
            super(new Range[]{range1, range2, range3, range4, range5});
        }

        public Rangesx6 range(int startInclusive, int endExclusive, int step) {
            return new Rangesx6(this.items[0], this.items[1], this.items[2], this.items[3], this.items[4], new Range(startInclusive, endExclusive, step));
        }

        public Rangesx6 rangeClosed(int startInclusive, int endInclusive, int step) {
            return this.range(startInclusive, endInclusive + 1, step);
        }

        public Rangesx6 range(int startInclusive, int endExclusive) {
            return new Rangesx6(this.items[0], this.items[1], this.items[2], this.items[3], this.items[4], new Range(startInclusive, endExclusive));
        }

        public Rangesx6 rangeClosed(int startInclusive, int endInclusive) {
            return this.range(startInclusive, endInclusive + 1);
        }

        public Rangesx6 range(int length) {
            return new Rangesx6(this.items[0], this.items[1], this.items[2], this.items[3], this.items[4], new Range(length));
        }

        public void execute(FunctionalInterfaces.Intx5Consumer c5) {
            for (int i : this.items[0]) {
                new Rangesx4(this.items[1], this.items[2], this.items[3], this.items[4]).execute((int j, int k, int l, int m) -> c5.accept(i, j, k, l, m));
            }
        }
    }

    public static class Rangesx6
    extends Ranges {
        private Rangesx6(Range range1, Range range2, Range range3, Range range4, Range range5, Range range6) {
            super(new Range[]{range1, range2, range3, range4, range5, range6});
        }

        public void execute(FunctionalInterfaces.Intx6Consumer c6) {
            for (int i : this.items[0]) {
                new Rangesx5(this.items[1], this.items[2], this.items[3], this.items[4], this.items[5]).execute((int j, int k, int l, int m, int n2) -> c6.accept(i, j, k, l, m, n2));
            }
        }
    }
}

