from __future__ import annotations

from typing import Any, Optional

class NodeVarType:
    ERROR: int = ...
    UNKNOWN: int = ...
    STATEMENT: int = ...
    CALLABLE: int = ...
    NONE: int = ...
    BOOLEAN: int = ...
    INT: int = ...
    FLOAT: int = ...
    STRING: int = ...
    TENSOR: int = ...
    NUMPY_NDARRAY: int = ...
    LIST: int = ...
    SET: int = ...
    DICT: int = ...
    PADDLE_DYGRAPH_API: int = ...
    PADDLE_CONTROL_IF: int = ...
    PADDLE_CONTROL_WHILE: int = ...
    PADDLE_CONTROL_FOR: int = ...
    PADDLE_RETURN_TYPES: int = ...
    TENSOR_TYPES: Any = ...
    Annotation_map: Any = ...
    @staticmethod
    def binary_op_output_type(in_type1: Any, in_type2: Any): ...
    @staticmethod
    def type_from_annotation(annotation: Any): ...

class AstNodeWrapper:
    node: Any = ...
    parent: Any = ...
    children: Any = ...
    node_var_type: Any = ...
    def __init__(self, node: Any) -> None: ...

class AstVarScope:
    SCOPE_TYPE_SCRIPT: int = ...
    SCOPE_TYPE_FUNCTION: int = ...
    SCOPE_TYPE_CLASS: int = ...
    sub_scopes: Any = ...
    name_to_id: Any = ...
    id_to_type: Any = ...
    cur_id: int = ...
    scope_name: Any = ...
    scope_type: Any = ...
    parent_scope: Any = ...
    def __init__(self, scope_name: str = ..., scope_type: Any = ..., parent_scope: Optional[Any] = ...) -> None: ...
    def add_var_type(self, var_name: Any, node_var_type: Any) -> None: ...
    def set_var_type(self, var_name: Any, node_var_type: Any) -> None: ...
    def get_var_type(self, var_name: Any): ...

class AstVarEnv:
    cur_scope: Any = ...
    def __init__(self) -> None: ...
    def enter_scope(self, scope_name: Any, scope_type: Any): ...
    def exit_scope(self): ...
    def get_parent_scope(self): ...
    def add_var_type(self, var_name: Any, node_var_type: Any) -> None: ...
    def set_var_type(self, var_name: Any, node_var_type: Any) -> None: ...
    def get_var_type(self, var_name: Any): ...
    def get_scope_var_type(self): ...

class StaticAnalysisVisitor:
    def __init__(self, ast_root: Optional[Any] = ...) -> None: ...
    node_wrapper_root: Any = ...
    ancestor_wrappers: Any = ...
    node_to_wrapper_map: Any = ...
    var_env: Any = ...
    def run(self, ast_root: Any) -> None: ...
    def dfs_visit(self, node: Any): ...
    def get_node_wrapper_root(self): ...
    def get_node_to_wrapper_map(self): ...
    def get_var_env(self): ...
    def is_tensor_node(self, node: Any): ...
