# HGAna: Analysis Tool for Host-Guest Binding

[![PyPI Version](https://img.shields.io/badge/PyPI-0.1.0-orange)](https://pypi.org/project/HGAna/)
[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://github.com/Ajax23/HGAna/blob/master/LICENSE)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.5137390.svg)](https://doi.org/10.5281/zenodo.5137390)
[![Build Status](https://github.com/Ajax23/HGAna/actions/workflows/workflow.yml/badge.svg)](https://github.com/Ajax23/HGAna/actions/workflows/workflow.yml)
[![codecov](https://codecov.io/gh/Ajax23/HGAna/branch/master/graph/badge.svg)](https://codecov.io/gh/Ajax23/HGAna)
[![Language grade: Python](https://img.shields.io/lgtm/grade/python/g/Ajax23/HGAna.svg?logo=lgtm&logoWidth=18)](https://lgtm.com/projects/g/Ajax23/HGAna/context:python)

## Documentation

Online documentation is available at [ajax23.github.io/HGAna](http://ajax23.github.io/HGAna).

The docs include an example for analyzing [binding affinity](http://ajax23.github.io/HGAna/affinity.html) for cyclodextrin simulations and an [API reference](http://ajax23.github.io/HGAna/api.html).


## Dependencies

HGAna supports Python 3.5+.

Installation requires [numpy](https://pypi.org/project/numpy/), [pandas](https://pypi.org/project/pandas/) and  [seaborn](https://pypi.org/project/seaborn/).


## Installation

You may instead want to use the development version from GitHub:

    pip install git+https://github.com/ajax23/HGAna.git#egg=hgana

    pip install git+https://github.com/ajax23/HGAna.git@develop#egg=hgana

Or download the repository and install in the top directory via:

    pip install .


## Testing

To test HGAna, run the test in the test directory.


## Development

HGAna development takes place on Github: [www.github.com/Ajax23/HGAna](https://github.com/Ajax23/HGAna)

Please submit any reproducible bugs you encounter to the [issue tracker](https://github.com/Ajax23/HGAna/issues).


## How to Cite HGAna

When citing HGAna please use the current **Zenodo DOI** corresponding to the used HGAna version. (Current DOI is listed in the badges.)
