#
# Copyright (c) 2019  StorPool.
# All rights reserved.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
#
""" Tests for the storpool.spdoc classes. """

from storpool import spapi
from storpool import spdoc


class TestAPI(object):
    # pylint: disable=no-self-use
    """ Simple tests for the autogenerated documentation. """

    def test_html(self):
        """ Make sure Html() produces sensible output. """
        html = spdoc.Html()
        html.add('<p>This is {a_test} &mdash; {stuff}</p>',
                 a_test='"a test"', stuff='<&>')
        assert str(html) == \
            '<p>This is &quot;a test&quot; &mdash; &lt;&amp;&gt;</p>'
        html.back(5)
        assert str(html) == \
            '<p>This is &quot;a test&quot; &mdash; &lt;&amp;&gt'

        html = spdoc.Html()
        html.add('<li>Is this {0} &mdash; {1}</li>', '<&>', '"a test"')
        assert str(html) == \
            '<li>Is this &lt;&amp;&gt; &mdash; &quot;a test&quot;</li>'

    def test_api_doc(self):
        """ Make sure the API documentation has some important items. """
        api = spapi.Api()
        assert not [sect for sect in api.spDoc.sections
                    if ' ' in sect.id]

        relocators = [sect for sect in api.spDoc.sections
                      if sect.id == 'Volume-Relocator']
        assert len(relocators) == 1
        statuses = [call for call in relocators[0].calls
                    if call.name == "Get the relocator's status"]
        assert len(statuses) == 1
        status = statuses[0]
        assert isinstance(status.returns, spdoc.JsonObjectDoc)
        assert 'status' in status.returns.attrs

        assert 'ClusterStatus' in spdoc.TypeDoc.types
