# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DocumentationResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DocumentationResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'int',
            'categories': 'list[int]',
            'description': 'str',
            'content': 'str',
            'excerpt': 'str',
            'link': 'str',
            'modified': 'datetime',
            'name': 'str',
            'service': 'list[int]',
            'slug': 'str',
            'title': 'str',
            'get_type': 'str',
            'facet_feature': 'list[int]',
            'facet_role': 'list[int]',
            'facet_service': 'list[int]',
            'faq_categories': 'list[int]',
            'releasenote_category': 'list[int]',
            'releasenote_tag': 'list[int]',
            'service_area': 'list[int]',
            'video_categories': 'list[int]'
        }

        self.attribute_map = {
            'id': 'id',
            'categories': 'categories',
            'description': 'description',
            'content': 'content',
            'excerpt': 'excerpt',
            'link': 'link',
            'modified': 'modified',
            'name': 'name',
            'service': 'service',
            'slug': 'slug',
            'title': 'title',
            'get_type': 'get_type',
            'facet_feature': 'facet_feature',
            'facet_role': 'facet_role',
            'facet_service': 'facet_service',
            'faq_categories': 'faq_categories',
            'releasenote_category': 'releasenote_category',
            'releasenote_tag': 'releasenote_tag',
            'service_area': 'service-area',
            'video_categories': 'video_categories'
        }

        self._id = None
        self._categories = None
        self._description = None
        self._content = None
        self._excerpt = None
        self._link = None
        self._modified = None
        self._name = None
        self._service = None
        self._slug = None
        self._title = None
        self._get_type = None
        self._facet_feature = None
        self._facet_role = None
        self._facet_service = None
        self._faq_categories = None
        self._releasenote_category = None
        self._releasenote_tag = None
        self._service_area = None
        self._video_categories = None

    @property
    def id(self):
        """
        Gets the id of this DocumentationResult.
        The globally unique identifier for the object.

        :return: The id of this DocumentationResult.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DocumentationResult.
        The globally unique identifier for the object.

        :param id: The id of this DocumentationResult.
        :type: int
        """
        
        self._id = id

    @property
    def categories(self):
        """
        Gets the categories of this DocumentationResult.
        The category of the documentation entity. Will be returned in responses for certain entities.

        :return: The categories of this DocumentationResult.
        :rtype: list[int]
        """
        return self._categories

    @categories.setter
    def categories(self, categories):
        """
        Sets the categories of this DocumentationResult.
        The category of the documentation entity. Will be returned in responses for certain entities.

        :param categories: The categories of this DocumentationResult.
        :type: list[int]
        """
        
        self._categories = categories

    @property
    def description(self):
        """
        Gets the description of this DocumentationResult.
        The description of the documentation entity. Will be returned in responses for certain entities.

        :return: The description of this DocumentationResult.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this DocumentationResult.
        The description of the documentation entity. Will be returned in responses for certain entities.

        :param description: The description of this DocumentationResult.
        :type: str
        """
        
        self._description = description

    @property
    def content(self):
        """
        Gets the content of this DocumentationResult.
        The text or html content for the documentation entity. Will be returned in responses for certain entities.

        :return: The content of this DocumentationResult.
        :rtype: str
        """
        return self._content

    @content.setter
    def content(self, content):
        """
        Sets the content of this DocumentationResult.
        The text or html content for the documentation entity. Will be returned in responses for certain entities.

        :param content: The content of this DocumentationResult.
        :type: str
        """
        
        self._content = content

    @property
    def excerpt(self):
        """
        Gets the excerpt of this DocumentationResult.
        The excerpt of the documentation entity. Will be returned in responses for certain entities.

        :return: The excerpt of this DocumentationResult.
        :rtype: str
        """
        return self._excerpt

    @excerpt.setter
    def excerpt(self, excerpt):
        """
        Sets the excerpt of this DocumentationResult.
        The excerpt of the documentation entity. Will be returned in responses for certain entities.

        :param excerpt: The excerpt of this DocumentationResult.
        :type: str
        """
        
        self._excerpt = excerpt

    @property
    def link(self):
        """
        Gets the link of this DocumentationResult.
        URL link for the documentation entity. Will be returned in responses for certain entities.

        :return: The link of this DocumentationResult.
        :rtype: str
        """
        return self._link

    @link.setter
    def link(self, link):
        """
        Sets the link of this DocumentationResult.
        URL link for the documentation entity. Will be returned in responses for certain entities.

        :param link: The link of this DocumentationResult.
        :type: str
        """
        
        self._link = link

    @property
    def modified(self):
        """
        Gets the modified of this DocumentationResult.
        The modified date for the documentation entity. Will be returned in responses for certain entities. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The modified of this DocumentationResult.
        :rtype: datetime
        """
        return self._modified

    @modified.setter
    def modified(self, modified):
        """
        Sets the modified of this DocumentationResult.
        The modified date for the documentation entity. Will be returned in responses for certain entities. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param modified: The modified of this DocumentationResult.
        :type: datetime
        """
        
        self._modified = modified

    @property
    def name(self):
        """
        Gets the name of this DocumentationResult.
        The name of the documentation entity. Will be returned in responses for certain entities.

        :return: The name of this DocumentationResult.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DocumentationResult.
        The name of the documentation entity. Will be returned in responses for certain entities.

        :param name: The name of this DocumentationResult.
        :type: str
        """
        
        self._name = name

    @property
    def service(self):
        """
        Gets the service of this DocumentationResult.
        The service of the documentation entity. Will be returned in responses for certain entities.

        :return: The service of this DocumentationResult.
        :rtype: list[int]
        """
        return self._service

    @service.setter
    def service(self, service):
        """
        Sets the service of this DocumentationResult.
        The service of the documentation entity. Will be returned in responses for certain entities.

        :param service: The service of this DocumentationResult.
        :type: list[int]
        """
        
        self._service = service

    @property
    def slug(self):
        """
        Gets the slug of this DocumentationResult.
        The slug of the documentation entity. Will be returned in responses for certain entities.

        :return: The slug of this DocumentationResult.
        :rtype: str
        """
        return self._slug

    @slug.setter
    def slug(self, slug):
        """
        Sets the slug of this DocumentationResult.
        The slug of the documentation entity. Will be returned in responses for certain entities.

        :param slug: The slug of this DocumentationResult.
        :type: str
        """
        
        self._slug = slug

    @property
    def title(self):
        """
        Gets the title of this DocumentationResult.
        The title of the documentation entity. Will be returned in responses for certain entities.

        :return: The title of this DocumentationResult.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """
        Sets the title of this DocumentationResult.
        The title of the documentation entity. Will be returned in responses for certain entities.

        :param title: The title of this DocumentationResult.
        :type: str
        """
        
        self._title = title

    @property
    def get_type(self):
        """
        Gets the get_type of this DocumentationResult.
        The search type. Will be returned in responses for certain entities.

        :return: The get_type of this DocumentationResult.
        :rtype: str
        """
        return self._get_type

    @get_type.setter
    def get_type(self, get_type):
        """
        Sets the get_type of this DocumentationResult.
        The search type. Will be returned in responses for certain entities.

        :param get_type: The get_type of this DocumentationResult.
        :type: str
        """
        
        self._get_type = get_type

    @property
    def facet_feature(self):
        """
        Gets the facet_feature of this DocumentationResult.
        The facet feature of the documentation entity. Will be returned in responses for certain entities.

        :return: The facet_feature of this DocumentationResult.
        :rtype: list[int]
        """
        return self._facet_feature

    @facet_feature.setter
    def facet_feature(self, facet_feature):
        """
        Sets the facet_feature of this DocumentationResult.
        The facet feature of the documentation entity. Will be returned in responses for certain entities.

        :param facet_feature: The facet_feature of this DocumentationResult.
        :type: list[int]
        """
        
        self._facet_feature = facet_feature

    @property
    def facet_role(self):
        """
        Gets the facet_role of this DocumentationResult.
        The facet role of the documentation entity. Will be returned in responses for certain entities.

        :return: The facet_role of this DocumentationResult.
        :rtype: list[int]
        """
        return self._facet_role

    @facet_role.setter
    def facet_role(self, facet_role):
        """
        Sets the facet_role of this DocumentationResult.
        The facet role of the documentation entity. Will be returned in responses for certain entities.

        :param facet_role: The facet_role of this DocumentationResult.
        :type: list[int]
        """
        
        self._facet_role = facet_role

    @property
    def facet_service(self):
        """
        Gets the facet_service of this DocumentationResult.
        The facet service of the documentation entity. Will be returned in responses for certain entities.

        :return: The facet_service of this DocumentationResult.
        :rtype: list[int]
        """
        return self._facet_service

    @facet_service.setter
    def facet_service(self, facet_service):
        """
        Sets the facet_service of this DocumentationResult.
        The facet service of the documentation entity. Will be returned in responses for certain entities.

        :param facet_service: The facet_service of this DocumentationResult.
        :type: list[int]
        """
        
        self._facet_service = facet_service

    @property
    def faq_categories(self):
        """
        Gets the faq_categories of this DocumentationResult.
        The faq categories of the documentation entity. Will be returned in responses for certain entities.

        :return: The faq_categories of this DocumentationResult.
        :rtype: list[int]
        """
        return self._faq_categories

    @faq_categories.setter
    def faq_categories(self, faq_categories):
        """
        Sets the faq_categories of this DocumentationResult.
        The faq categories of the documentation entity. Will be returned in responses for certain entities.

        :param faq_categories: The faq_categories of this DocumentationResult.
        :type: list[int]
        """
        
        self._faq_categories = faq_categories

    @property
    def releasenote_category(self):
        """
        Gets the releasenote_category of this DocumentationResult.
        The releasenote category of the documentation entity. Will be returned in responses for certain entities.

        :return: The releasenote_category of this DocumentationResult.
        :rtype: list[int]
        """
        return self._releasenote_category

    @releasenote_category.setter
    def releasenote_category(self, releasenote_category):
        """
        Sets the releasenote_category of this DocumentationResult.
        The releasenote category of the documentation entity. Will be returned in responses for certain entities.

        :param releasenote_category: The releasenote_category of this DocumentationResult.
        :type: list[int]
        """
        
        self._releasenote_category = releasenote_category

    @property
    def releasenote_tag(self):
        """
        Gets the releasenote_tag of this DocumentationResult.
        The releasenote tag of the documentation entity. Will be returned in responses for certain entities.

        :return: The releasenote_tag of this DocumentationResult.
        :rtype: list[int]
        """
        return self._releasenote_tag

    @releasenote_tag.setter
    def releasenote_tag(self, releasenote_tag):
        """
        Sets the releasenote_tag of this DocumentationResult.
        The releasenote tag of the documentation entity. Will be returned in responses for certain entities.

        :param releasenote_tag: The releasenote_tag of this DocumentationResult.
        :type: list[int]
        """
        
        self._releasenote_tag = releasenote_tag

    @property
    def service_area(self):
        """
        Gets the service_area of this DocumentationResult.
        The service area of the documentation entity. Will be returned in responses for certain entities.

        :return: The service_area of this DocumentationResult.
        :rtype: list[int]
        """
        return self._service_area

    @service_area.setter
    def service_area(self, service_area):
        """
        Sets the service_area of this DocumentationResult.
        The service area of the documentation entity. Will be returned in responses for certain entities.

        :param service_area: The service_area of this DocumentationResult.
        :type: list[int]
        """
        
        self._service_area = service_area

    @property
    def video_categories(self):
        """
        Gets the video_categories of this DocumentationResult.
        The video categories of the documentation entity. Will be returned in responses for certain entities.

        :return: The video_categories of this DocumentationResult.
        :rtype: list[int]
        """
        return self._video_categories

    @video_categories.setter
    def video_categories(self, video_categories):
        """
        Sets the video_categories of this DocumentationResult.
        The video categories of the documentation entity. Will be returned in responses for certain entities.

        :param video_categories: The video_categories of this DocumentationResult.
        :type: list[int]
        """
        
        self._video_categories = video_categories

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

