# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class ApiUsageRow(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        ApiUsageRow - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'client_id': 'str',
            'client_name': 'str',
            'organization_id': 'str',
            'user_id': 'str',
            'template_uri': 'str',
            'http_method': 'str',
            'status200': 'int',
            'status300': 'int',
            'status400': 'int',
            'status500': 'int',
            'status429': 'int',
            'requests': 'int',
            'date': 'datetime'
        }

        self.attribute_map = {
            'client_id': 'clientId',
            'client_name': 'clientName',
            'organization_id': 'organizationId',
            'user_id': 'userId',
            'template_uri': 'templateUri',
            'http_method': 'httpMethod',
            'status200': 'status200',
            'status300': 'status300',
            'status400': 'status400',
            'status500': 'status500',
            'status429': 'status429',
            'requests': 'requests',
            'date': 'date'
        }

        self._client_id = None
        self._client_name = None
        self._organization_id = None
        self._user_id = None
        self._template_uri = None
        self._http_method = None
        self._status200 = None
        self._status300 = None
        self._status400 = None
        self._status500 = None
        self._status429 = None
        self._requests = None
        self._date = None

    @property
    def client_id(self):
        """
        Gets the client_id of this ApiUsageRow.
        Client Id associated with this query result

        :return: The client_id of this ApiUsageRow.
        :rtype: str
        """
        return self._client_id

    @client_id.setter
    def client_id(self, client_id):
        """
        Sets the client_id of this ApiUsageRow.
        Client Id associated with this query result

        :param client_id: The client_id of this ApiUsageRow.
        :type: str
        """
        
        self._client_id = client_id

    @property
    def client_name(self):
        """
        Gets the client_name of this ApiUsageRow.
        Client Name associated with this query result

        :return: The client_name of this ApiUsageRow.
        :rtype: str
        """
        return self._client_name

    @client_name.setter
    def client_name(self, client_name):
        """
        Sets the client_name of this ApiUsageRow.
        Client Name associated with this query result

        :param client_name: The client_name of this ApiUsageRow.
        :type: str
        """
        
        self._client_name = client_name

    @property
    def organization_id(self):
        """
        Gets the organization_id of this ApiUsageRow.
        Organization Id associated with this query result

        :return: The organization_id of this ApiUsageRow.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this ApiUsageRow.
        Organization Id associated with this query result

        :param organization_id: The organization_id of this ApiUsageRow.
        :type: str
        """
        
        self._organization_id = organization_id

    @property
    def user_id(self):
        """
        Gets the user_id of this ApiUsageRow.
        User Id associated with this query result

        :return: The user_id of this ApiUsageRow.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id):
        """
        Sets the user_id of this ApiUsageRow.
        User Id associated with this query result

        :param user_id: The user_id of this ApiUsageRow.
        :type: str
        """
        
        self._user_id = user_id

    @property
    def template_uri(self):
        """
        Gets the template_uri of this ApiUsageRow.
        Template Uri associated with this query result

        :return: The template_uri of this ApiUsageRow.
        :rtype: str
        """
        return self._template_uri

    @template_uri.setter
    def template_uri(self, template_uri):
        """
        Sets the template_uri of this ApiUsageRow.
        Template Uri associated with this query result

        :param template_uri: The template_uri of this ApiUsageRow.
        :type: str
        """
        
        self._template_uri = template_uri

    @property
    def http_method(self):
        """
        Gets the http_method of this ApiUsageRow.
        HTTP Method associated with this query result

        :return: The http_method of this ApiUsageRow.
        :rtype: str
        """
        return self._http_method

    @http_method.setter
    def http_method(self, http_method):
        """
        Sets the http_method of this ApiUsageRow.
        HTTP Method associated with this query result

        :param http_method: The http_method of this ApiUsageRow.
        :type: str
        """
        
        self._http_method = http_method

    @property
    def status200(self):
        """
        Gets the status200 of this ApiUsageRow.
        Number of requests resulting in a 2xx HTTP status code

        :return: The status200 of this ApiUsageRow.
        :rtype: int
        """
        return self._status200

    @status200.setter
    def status200(self, status200):
        """
        Sets the status200 of this ApiUsageRow.
        Number of requests resulting in a 2xx HTTP status code

        :param status200: The status200 of this ApiUsageRow.
        :type: int
        """
        
        self._status200 = status200

    @property
    def status300(self):
        """
        Gets the status300 of this ApiUsageRow.
        Number of requests resulting in a 3xx HTTP status code

        :return: The status300 of this ApiUsageRow.
        :rtype: int
        """
        return self._status300

    @status300.setter
    def status300(self, status300):
        """
        Sets the status300 of this ApiUsageRow.
        Number of requests resulting in a 3xx HTTP status code

        :param status300: The status300 of this ApiUsageRow.
        :type: int
        """
        
        self._status300 = status300

    @property
    def status400(self):
        """
        Gets the status400 of this ApiUsageRow.
        Number of requests resulting in a 4xx HTTP status code

        :return: The status400 of this ApiUsageRow.
        :rtype: int
        """
        return self._status400

    @status400.setter
    def status400(self, status400):
        """
        Sets the status400 of this ApiUsageRow.
        Number of requests resulting in a 4xx HTTP status code

        :param status400: The status400 of this ApiUsageRow.
        :type: int
        """
        
        self._status400 = status400

    @property
    def status500(self):
        """
        Gets the status500 of this ApiUsageRow.
        Number of requests resulting in a 5xx HTTP status code

        :return: The status500 of this ApiUsageRow.
        :rtype: int
        """
        return self._status500

    @status500.setter
    def status500(self, status500):
        """
        Sets the status500 of this ApiUsageRow.
        Number of requests resulting in a 5xx HTTP status code

        :param status500: The status500 of this ApiUsageRow.
        :type: int
        """
        
        self._status500 = status500

    @property
    def status429(self):
        """
        Gets the status429 of this ApiUsageRow.
        Number of requests resulting in a 429 HTTP status code, this is a subset of the count returned with status400

        :return: The status429 of this ApiUsageRow.
        :rtype: int
        """
        return self._status429

    @status429.setter
    def status429(self, status429):
        """
        Sets the status429 of this ApiUsageRow.
        Number of requests resulting in a 429 HTTP status code, this is a subset of the count returned with status400

        :param status429: The status429 of this ApiUsageRow.
        :type: int
        """
        
        self._status429 = status429

    @property
    def requests(self):
        """
        Gets the requests of this ApiUsageRow.
        Total number of requests

        :return: The requests of this ApiUsageRow.
        :rtype: int
        """
        return self._requests

    @requests.setter
    def requests(self, requests):
        """
        Sets the requests of this ApiUsageRow.
        Total number of requests

        :param requests: The requests of this ApiUsageRow.
        :type: int
        """
        
        self._requests = requests

    @property
    def date(self):
        """
        Gets the date of this ApiUsageRow.
        Date of requests, based on granularity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :return: The date of this ApiUsageRow.
        :rtype: datetime
        """
        return self._date

    @date.setter
    def date(self, date):
        """
        Sets the date of this ApiUsageRow.
        Date of requests, based on granularity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ

        :param date: The date of this ApiUsageRow.
        :type: datetime
        """
        
        self._date = date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

