<!-- Logo -->
<h1 align="center">
  <img src="https://github.com/Dog-Face-Development/Moms-Canning-Timer/blob/master/docs/images/logo.png" height="350px" width="400px" alt="Mom's Canning Timer">
  <br>
  Mom's Canning Timer
  <br>
</h1>

<!-- Copy -->
<h4 align="center">Customizable 15-minute stove top timers, created for preserving fruits and veggies for the winter.</h4>

<!-- Badges -->
<div align="center">
  <!-- Stability -->
  <img alt="PyPI Build State" src="https://github.com/Dog-Face-Development/Moms-Canning-Timer/actions/workflows/push-to-pypi.yml/badge.svg">
  <!-- Stability -->
  <img alt="Pylint State" src="https://github.com/Dog-Face-Development/Moms-Canning-Timer/actions/workflows/pylint.yml/badge.svg">
  <!-- CodeQL -->
  <img alt="CodeQL State" src="https://github.com/Dog-Face-Development/Moms-Canning-Timer/actions/workflows/codeql-analysis.yml/badge.svg">
  <!-- Version -->
  <img alt="GitHub Version" src="https://img.shields.io/github/v/release/Dog-Face-Development/Moms-Canning-Timer?include_prereleases">
  <!-- Issues -->
  <img alt="GitHub Issues" src="https://img.shields.io/github/issues/Dog-Face-Development/Moms-Canning-Timer">
  <!-- Pull Requests -->
  <img alt="GitHub Pull Requests" src="https://img.shields.io/github/issues-pr/Dog-Face-Development/Moms-Canning-Timer">
  <!-- Discord -->
  <img alt="Discord Server ID" src="https://img.shields.io/discord/1015833914876629032">
  <!-- Downloads -->
  <img alt="Downloads" src="https://img.shields.io/github/downloads/Dog-Face-Development/Moms-Canning-Timer/total">
  <!-- Language Count -->
  <img alt="GitHub Languages" src="https://img.shields.io/github/languages/count/Dog-Face-Development/Moms-Canning-Timer">
</div>

<!-- Navigation -->
<p align="center">
  <a href="#key-features">Key Features</a> •
  <a href="#download">Download</a> •
  <a href="#how-to-use">How To Use</a> •
  <a href="#support">Support</a> •
  <a href="#contributing">Contributing</a> •
  <a href="#changelog">Changelog</a> •
  <a href="#credits">Credits & Contributors</a>
</p>

<!-- Screenshot(s) -->
<div align="center">
  <img src="https://github.com/Dog-Face-Development/Moms-Canning-Timer/blob/master/docs/images/welcome.png">
</div>

## Key Features

* Create 15 minute timers for cans.
* Create multiple timers.
* Rearrange timers to match stove top pattern.
* Create multiple stove tops.
* Easily update timer length.
* Cross platform.

## Download

You can **[download](https://github.com/Dog-Face-Development/Moms-Canning-Timer/releases/latest) the source code** to run the scripts from the command line on Windows, macOS and Linux. **This will require [Python](https://www.python.org/downloads/).**

You can **[download](https://github.com/Dog-Face-Development/Moms-Canning-Timer/releases/latest) the latest executable version** of Mom's Canning Timer for Windows. **This does not require Python.**

## How To Use

To run the application, you can use [Git and the Python Interpreter](https://github.com/Dog-Face-Development/Moms-Canning-Timer/main/README.md#git), which allows you to clone and run the application, or [`pip`](https://github.com/Dog-Face-Development/Moms-Canning-Timer/main/README.md#pip) to create a command line application.

### Git

To clone and run this application, you'll need [Git](https://git-scm.com/downloads) and [Python](https://www.python.org/downloads/) installed on your computer. If you would rather not use Git, you can just download the script from GitHub above. From your command line:

```bash
# Clone this repository
$ git clone https://github.com/Dog-Face-Development/Moms-Canning-Timer

# Go into the repository
$ cd Moms-Canning-Timer

# Run the CLI
$ python main.py
```

### `pip`

You can install the program from the [Python Package Index](https://pypi.org/project/Moms-Canning-Timer/) through `pip`.

```bash
# Install via pip
$ pip install moms-canning-timer

# Run the CLI
$ canning-timer
```

## Support

Customization for Mom's Canning Timer can be found in the [`CUSTOMIZATION`](https://github.com/Dog-Face-Development/Moms-Canning-Timer/blob/master/docs/CUSTOMIZATION.md) doc. More documentation is available in the **[Documentation](https://github.com/Dog-Face-Development/Moms-Canning-Timer/tree/master/docs)** and on the **[Wiki](https://github.com/Dog-Face-Development/Moms-Canning-Timer/wiki)**. If more support is required, please open a **[GitHub Discussion](https://github.com/Dog-Face-Development/Moms-Canning-Timer/discussions)** or join our **[Discord](https://discord.gg/khcBGp3Pwj)**.

## Contributing

Please contribute using [GitHub Flow](https://guides.github.com/introduction/flow). Create a branch, add commits, and [open a pull request](https://github.com/Dog-Face-Development/Moms-Canning-Timer/compare).

Please read [`CONTRIBUTING`](CONTRIBUTING.md) for details on our [`CODE OF CONDUCT`](CODE_OF_CONDUCT.md), and the process for submitting pull requests to us (including how to sign our CLA).

## Changelog

See the [`CHANGELOG`](CHANGELOG.md) file for details.

## Credits

This software uses the following open source packages, projects, services or websites:

<!-- Credits Table -->
<table>
  <tr>
    <th align="center"><img src="https://applets.imgix.net/https%3A%2F%2Fassets.ifttt.com%2Fimages%2Fchannels%2F2107379463%2Ficons%2Fmonochrome_large.png?w=240&h=240&s=8a19bbc158996d098e2fb18310ba7f33" width="150" height="150" alt="GitHub"/></th>
    <th align="center"><img src="https://upload.wikimedia.org/wikipedia/commons/thumb/c/c3/Python-logo-notext.svg/182px-Python-logo-notext.svg.png" width="150" height="150" alt="PSF"/></th>
    <th align="center"><img src="https://pyinstaller.readthedocs.io/en/v4.2/_static/pyinstaller-draft1a.ico" width="150" height="150" alt="PyInstaller"/></th>
    <th align="center"><img src="https://avatars.githubusercontent.com/u/3255139?s=200&v=4" width="150" height="150" alt="Iconic"/></th>
  </tr>
  <tr>
    <td align="center">GitHub</td>
    <td align="center">Python Software Foundation</td>
    <td align="center">PyInstaller</td>
    <td align="center">Open Iconic</td>
  </tr>
  <tr>
    <td align="center"><a href="https://github.com/">Web</a> - <a href="https://github.com/pricing">Plans</a></td>
    <td align="center"><a href="https://www.python.org/">Web</a> - <a href="https://psfmember.org/civicrm/contribute/transact?reset=1&id=2">Donate</a></td>
    <td align="center"><a href="https://pyinstaller.readthedocs.io/en/stable/">Web</a> - <a href="https://www.pyinstaller.org/funding.html#funding-by-individuals">Donate</a></td>
    <td align="center"><a href="https://github.com/iconic/open-iconic">Web</a></td>
  </tr>
</table>

## Contributors

* [@willtheorangeguy](https://github.com/willtheorangeguy) - Sponsor on [PayPal](https://paypal.me/wvdg44?country.x=CA&locale.x=en_US)

## You may also like...

* [ProgramVer](https://github.com/Dog-Face-Development/ProgramVer) - An open-source, Python GUI version window to show copyright info and licenses.
* [PyWorkout](https://github.com/Dog-Face-Development/PyWorkout) - A minimal CLI to keep you inspired during your workout!
* [PyAvatar](https://github.com/Dog-Face-Development/PyAvatar) - Easily display all of your creative avatars to keep them consistent across websites.

## License

This project is licensed under the [GNU General Public License](https://www.gnu.org/licenses/gpl-3.0.en.html) - see the [`LICENSE`](LICENSE.md) file for details. See the [Privacy Policy](https://github.com/Dog-Face-Development/Moms-Canning-Timer/blob/master/docs/legal/PRIVACY.md), [Terms and Conditions](https://github.com/Dog-Face-Development/Moms-Canning-Timer/blob/master/docs/legal/TERMS.md), and [EULA](https://github.com/Dog-Face-Development/Moms-Canning-Timer/blob/master/docs/legal/EULA.md) for legal information.
