# ПРИМЕР ВЫВОДИТ ИНФОРМАЦИЮ О МОДУЛЕ:                           #

# Для определения реального передаточного отношения             #
# запустите пример библиотеки FindReducer                       #
                                                                #
# Для определения реального количества магнитных полюсов        #
# кольцевого магнита запустите пример библиотеки FindMagnet     #
                                                                #
from pyiArduinoI2Cmotor import *                                #   Подключаем библиотеку для работы с мотором I2C-flash.
mot = pyiArduinoI2Cmotor(0x09)                                  #   Объявляем объект mot для работы с функциями и методами библиотеки pyiArduinoI2Cmotor, указывая адрес модуля на шине I2C.
                                                                #   Если объявить объект без указания адреса (mot = pyiArduinoI2Cmotor ), то адрес будет найден автоматически.
                                                                #

#   Выводим номинальное напряжение питания мотора из flash памяти модуля.
V = mot.getVoltage()
t = "Номинальное напряжение питания мотора: {} В.".format(V)
print(t)

#   Выводим номинальную скорость вращения вала из flash памяти модуля.
RPM = mot.getNominalRPM()
t = "Номинальная скорость вращения вала: {} об/мин.".format(RPM)
print(t)

#   Выводим передаточное отношение редуктора из flash памяти модуля.
R = mot.getReducer()
t = "Передаточное отношение редуктора: 1:".format(R)
print(t)

#   Выводим количество однополярных полюсов кольцевого магнита из flash памяти модуля.
P = mot.getMagnet()
t = "Количество полюсов кольцевого магнита: {} шт. (одной полярности)".format(P)
print(t)

#   Выводим флаг инверсии редуктора из flash памяти модуля.
t = "Вал редуктора вращается "
if mot.getInvGear() & 1:
    t += "не по"
else:
    t += "по"

t += " направлению вращения ротора мотора."

print(t)

#   Выводим флаг инверсии полярности мотора из flash памяти модуля.
t = "Ротор мотора вращается "
if mot.getInvGear() & 2:
    t += "против"
else:
    t += "по"
t += " ч.с. при положительных скоростях."

print(t)
                                                    #
#   Если на роторе мотора отсутствует кольцевой магнит или у модуля отсутствуют датчики Холла.
if mot.getMagnet() == 0:

t =   "Модуль не поддерживает функции: "\
      "setSpeed(), getSpeed(), "\
      "setStop(), getStop() и getSum(),\r\n"\
      "вызванные с параметрами: "\
      "MOT_RPM, MOT_M_S, MOT_MET и MOT_REV.\r\n"
print(t)
