// ПРИМЕР ОСТАНАВЛИВАЕТ МОТОР С БЛОКИРОВКОЙ И БЕЗ //
                                                  //
#include "Serial.h"
#include "../iarduino_I2C_Motor.h"                //   Подключаем библиотеку для работы с мотором I2C-flash.
iarduino_I2C_Motor mot(0x09);                     //   Объявляем объект mot для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
                                                  //   Если объявить объект без указания адреса (iarduino_I2C_Motor mot;), то адрес будет найден автоматически.
int main(){                                       //
    mot.begin();                                  //   Инициируем работу с мотором.
    loop();                                       //
}                                                 //
                                                  //
void loop(){                                      //
//  Запускаем и плавно останавливаем мотор:       //
    mot.setSpeed(100.0, MOT_PWM); delay(500);     //   Запускаем мотор на максимальной скорости, указав максимальное значение ШИМ = 100%.
    mot.setStopNeutral(true);                     //   Указываем освободить мотор при его остановке. Ротор остановленного мотора можно вращать.
    mot.setStop();                delay(1000);    //   Останавливаем мотор. Обратите внимание на то, что ротор мотора останавливается плавно.
//  Запускаем и резко останавливаем мотор:        //
    mot.setSpeed(100.0, MOT_PWM); delay(500);     //   Запускаем мотор на максимальной скорости, указав максимальное значение ШИМ = 100%.
    mot.setStopNeutral(false);                    //   Указываем не освобождать мотор при его остановке. Ротор остановленного мотора будет застопорен.
    mot.setStop();                delay(1000);    //   Останавливаем мотор. Обратите внимание на то, что ротор мотора останавливается резко.
}                                                 //
//                                                //
//  Функция setStopNeutral() не останавливает     //
//  мотор, а указывает как он будет себя вести    //
//  при остановке.                                //
//  Останавливается мотор функцией setStop().     //
