// ПРИМЕР ВЫВОДИТ ИНФОРМАЦИЮ О МОДУЛЕ:                         //
                                                               //
#include "Serial.h"
#include "../iarduino_I2C_Motor.h"                             //   Подключаем библиотеку для работы с мотором I2C-flash.
iarduino_I2C_Motor mot(0x09);                                  //   Объявляем объект mot для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
                                                               //   Если объявить объект без указания адреса (iarduino_I2C_Motor mot;), то адрес будет найден автоматически.
int main(){                                                    //
    mot.begin();                                               //   Инициируем работу с мотором.
                                                               //
    Serial.print("Номинальное напряжение питания мотора: ");   //
    Serial.print( mot.getVoltage() );                          //   Выводим номинальное напряжение питания мотора из flash памяти модуля.
    Serial.print(" В.\r\n");                                   //
                                                               //
    Serial.print("Номинальная скорость вращения вала:    ");   //
    Serial.print( mot.getNominalRPM() );                       //   Выводим номинальную скорость вращения вала из flash памяти модуля.
    Serial.print(" об/мин.\r\n");                              //
                                                               //
    Serial.print("Передаточное отношение редуктора:      1:"); //
    Serial.print( mot.getReducer() );                          //   Выводим передаточное отношение редуктора из flash памяти модуля.
    Serial.print("\r\n");                                      //
                                                               //
    Serial.print("Количество полюсов кольцевого магнита: ");   //
    Serial.print( mot.getMagnet() );                           //   Выводим количество однополярных полюсов кольцевого магнита из flash памяти модуля.
    Serial.print(" шт. (одной полярности)\r\n");               //
                                                               //
    Serial.print("Вал редуктора вращается ");                  //
    Serial.print( mot.getInvGear()&1? "не по":"по" );          //   Выводим флаг инверсии редуктора из flash памяти модуля.
    Serial.print(" направлению вращения ротора мотора.\r\n");  //
                                                               //
    Serial.print("Ротор мотора вращается ");                   //
    Serial.print( mot.getInvGear()&2? "против":"по" );         //   Выводим флаг инверсии полярности мотора из flash памяти модуля.
    Serial.print(" ч.с. при положительных скоростях.\r\n");    //
                                                               //
    if( mot.getMagnet()==0 ){                                  //   Если на роторе мотора отсутствует кольцевой магнит или у молудя отутствуют датчики Холла.
    Serial.print("Модуль не поддерживает функции: ");          //
    Serial.print("setSpeed(), getSpeed(), ");                  //
    Serial.print("setStop(), getStop() и getSum(),\r\n");      //
    Serial.print("вызванные с параметрами: ");                 //
    Serial.print("MOT_RPM, MOT_M_S, MOT_MET и MOT_REV.\r\n");  //
    }                                                          //
                                                               //
}                                                              //
                                                               //
// Для определения реального передаточного отношения           //
// запустите пример библиотеки FindReducer                     //
                                                               //
// Для определения реального количества магнитных полюсов      //
// кольцевого магнита запустите пример библиотеки FindMagnet   //
