// ОПРЕДЕЛЕНИЕ РЕАЛЬНОГО КОЛИЧЕСТВА МАГНИТОВ:     //
                                                  //
#include "Serial.h"
#include "../iarduino_I2C_Motor.h"                //   Подключаем библиотеку для работы с мотором I2C-flash.
iarduino_I2C_Motor mot(0x09);                     //   Объявляем объект mot для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
                                                  //   Если объявить объект без указания адреса (iarduino_I2C_Motor mot;), то адрес будет найден автоматически.
int main(){                                       //
    mot.begin();                                  //   Инициируем работу с мотором.
    mot.delSum();                                 //   Сбрасываем количество совершённых оборотов вала.
    mot.setReducer(1.0f);                         //   Указываем передаточное отношение редуктора как 1:1.
    mot.setMagnet(1);                             //   Указываем что на роторе мотора находится магнит содержащий 1 полюс одной полярности и 1 полюс другой полярности.
    loop();                                       //
}                                                 //
                                                  //
void loop(){                                      //
    Serial.println( mot.getSum(MOT_REV) );        //   Выводим количество полных оборотов вала.
    delay(200);                                   //
}                                                 //
                                                  //
/*  ВЫПОЛНИТЕ СЛЕДУЮЩИЕ ДЕЙСТВИЯ:                 //
 *  После старта скетча, в мониторе будут появляться значения 0.00
 *  При вращении ротора мотора (в любую сторону), эти значения будут увеличиваться.
 *  Поверните вручную ротор мотора (на котором установлен кольцевой магнит) на 1 полный оборот.
 *  В результате кольцевой магнит обернётся один раз вокруг своей оси.
 *  В мониторе появится значение равное количеству магнитных полюсов магнита одной полярности.
 *  Для большей точности советуем повернуть ротор мотора 10 раз, и разделить полученное значение на 10.
 *  Ближайшее целое число и будет реальным количеством магнитных полюсов одной полярности.
*/
