// ПРИМЕР УПРАВЛЕНИЯ ДВИГАТЕЛЯМИ АВТОМОБИЛЯ:      //
                                                  //
#include "Serial.h"
#include "../iarduino_I2C_Motor.h"                //   Подключаем библиотеку для работы с мотором I2C-flash.
iarduino_I2C_Motor mot_L(0x09);                   //   Объявляем объект mot_L для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
iarduino_I2C_Motor mot_R(0x0A);                   //   Объявляем объект mot_R для работы с функциями и методами библиотеки iarduino_I2C_Motor, указывая адрес модуля на шине I2C.
                                                  //   При наличии нескольких моторов на шине I2C нельзя объявлять объект без указания адреса.
int main(){                                       //
    mot_L.begin();                                //   Инициируем работу с мотором установленным по левому  борту автомобиля.
    mot_R.begin();                                //   Инициируем работу с мотором установленным по правому борту автомобиля.
    mot_L.setDirection(false);                    //   Задаём направление вращения для левого  мотора: против часовой стрелки при положительных скоростях и по при отрицательных.
    mot_R.setDirection(true );                    //   Задаём направление вращения для правого мотора: по часовой стрелке при положительных скоростях и против при отрицательных.
    mot_L.radius = 12.2;                          //   Указываем радиус левого  колеса в мм (значение используется для движения на заданное растояние).
    mot_R.radius = 12.2;                          //   Указываем радиус правого колеса в мм (значение используется для движения на заданное растояние).
    loop();                                       //
}                                                 //
                                                  //
void loop(){                                      //
//  Движение вперёд:                              //
    mot_L.setSpeed( 120, MOT_RPM);                //   Указываем левому  мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    mot_R.setSpeed( 120, MOT_RPM);                //   Указываем правому мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    delay(5000);                                  //   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
//  Движение вперёд с доворотом влево:            //
    mot_L.setSpeed(  60, MOT_RPM);                //   Указываем левому  мотору работать на скорости   60 об/мин, что соответствует 1 об/сек.
    mot_R.setSpeed( 120, MOT_RPM);                //   Указываем правому мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    delay(5000);                                  //   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
//  Движение назад:                               //
    mot_L.setSpeed(-120, MOT_RPM);                //   Указываем левому  мотору работать на скорости -120 об/мин, что соответствует 2 об/сек в обратную сторону.
    mot_R.setSpeed(-120, MOT_RPM);                //   Указываем правому мотору работать на скорости -120 об/мин, что соответствует 2 об/сек в обратную сторону.
    delay(5000);                                  //   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
//  Разворот на месте вправо:                     //
    mot_L.setSpeed( 120, MOT_RPM);                //   Указываем левому  мотору работать на скорости  120 об/мин, что соответствует 2 об/сек.
    mot_R.setSpeed(-120, MOT_RPM);                //   Указываем правому мотору работать на скорости -120 об/мин, что соответствует 2 об/сек в обратную сторону.
    delay(5000);                                  //   Приостанавливаем выполнение скетча на 5 секунд. При этом моторы будут вращаться.
//  Движение вперёд на заданное растояние:        //
    mot_L.setSpeed( 200, MOT_RPM, 1.5, MOT_MET ); //   Указываем левому  мотору работать на скорости 200 об/мин с остановкой мотора через 1.5 м пройденого пути.
    mot_R.setSpeed( 200, MOT_RPM, 1.5, MOT_MET ); //   Указываем правому мотору работать на скорости 200 об/мин с остановкой мотора через 1.5 м пройденого пути.
    delay(20000);                                 //   Приостанавливаем выполнение скетча на 20 секунд. За это время автомобиль точно успеет проехать 1.5 м (полтора метра) и остановиться.
}                                                 //
                                                  //
// Максимальную скорость вращения моторов можно   //
// узнать запустив пример библиотеки FindMaxSpeed //
