# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_vpc20160428 import models as vpc_20160428_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'regional'
        self._endpoint_map = {
            'cn-qingdao': 'vpc.aliyuncs.com',
            'cn-beijing': 'vpc.aliyuncs.com',
            'cn-hangzhou': 'vpc.aliyuncs.com',
            'cn-shanghai': 'vpc.aliyuncs.com',
            'cn-shenzhen': 'vpc.aliyuncs.com',
            'cn-hongkong': 'vpc.aliyuncs.com',
            'ap-southeast-1': 'vpc.aliyuncs.com',
            'us-east-1': 'vpc.aliyuncs.com',
            'us-west-1': 'vpc.aliyuncs.com',
            'cn-shanghai-finance-1': 'vpc.aliyuncs.com',
            'cn-shenzhen-finance-1': 'vpc.aliyuncs.com',
            'cn-north-2-gov-1': 'vpc.aliyuncs.com',
            'ap-northeast-2-pop': 'vpc.aliyuncs.com',
            'cn-beijing-finance-pop': 'vpc.aliyuncs.com',
            'cn-beijing-gov-1': 'vpc.aliyuncs.com',
            'cn-beijing-nu16-b01': 'vpc.aliyuncs.com',
            'cn-edge-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-fujian': 'vpc.aliyuncs.com',
            'cn-haidian-cm12-c01': 'vpc.aliyuncs.com',
            'cn-hangzhou-bj-b01': 'vpc.aliyuncs.com',
            'cn-hangzhou-finance': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-prod-1': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-1': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-2': 'vpc.aliyuncs.com',
            'cn-hangzhou-internal-test-3': 'vpc.aliyuncs.com',
            'cn-hangzhou-test-306': 'vpc.aliyuncs.com',
            'cn-hongkong-finance-pop': 'vpc.aliyuncs.com',
            'cn-huhehaote-nebula-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-qingdao-nebula': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'cn-shanghai-et15-b01': 'vpc.aliyuncs.com',
            'cn-shanghai-et2-b01': 'vpc.aliyuncs.com',
            'cn-shanghai-inner': 'vpc.aliyuncs.com',
            'cn-shanghai-internal-test-1': 'vpc.aliyuncs.com',
            'cn-shenzhen-inner': 'vpc.aliyuncs.com',
            'cn-shenzhen-st4-d01': 'vpc.aliyuncs.com',
            'cn-shenzhen-su18-b01': 'vpc.aliyuncs.com',
            'cn-wuhan': 'vpc.aliyuncs.com',
            'cn-yushanfang': 'vpc.aliyuncs.com',
            'cn-zhangbei': 'vpc.aliyuncs.com',
            'cn-zhangbei-na61-b01': 'vpc.aliyuncs.com',
            'cn-zhangjiakou-na62-a01': 'vpc.cn-zhangjiakou.aliyuncs.com',
            'cn-zhengzhou-nebula-1': 'vpc-nebula.cn-qingdao-nebula.aliyuncs.com',
            'eu-west-1-oxs': 'vpc-nebula.cn-shenzhen-cloudstone.aliyuncs.com',
            'rus-west-1-pop': 'vpc.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('vpc', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def activate_router_interface_with_options(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def activate_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def activate_router_interface(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.activate_router_interface_with_options(request, runtime)

    async def activate_router_interface_async(
        self,
        request: vpc_20160428_models.ActivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.ActivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.activate_router_interface_with_options_async(request, runtime)

    def active_flow_log_with_options(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActiveFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def active_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ActiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ActiveFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def active_flow_log(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.active_flow_log_with_options(request, runtime)

    async def active_flow_log_async(
        self,
        request: vpc_20160428_models.ActiveFlowLogRequest,
    ) -> vpc_20160428_models.ActiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.active_flow_log_with_options_async(request, runtime)

    def add_bgp_network_with_options(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddBgpNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_bgp_network_with_options_async(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddBgpNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_bgp_network(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_bgp_network_with_options(request, runtime)

    async def add_bgp_network_async(
        self,
        request: vpc_20160428_models.AddBgpNetworkRequest,
    ) -> vpc_20160428_models.AddBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_bgp_network_with_options_async(request, runtime)

    def add_common_bandwidth_package_ip_with_options(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_common_bandwidth_package_ip_with_options_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_common_bandwidth_package_ip(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_common_bandwidth_package_ip_with_options(request, runtime)

    async def add_common_bandwidth_package_ip_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_common_bandwidth_package_ip_with_options_async(request, runtime)

    def add_common_bandwidth_package_ips_with_options(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_ids):
            query['IpInstanceIds'] = request.ip_instance_ids
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpsResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_common_bandwidth_package_ips_with_options_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ip_instance_ids):
            query['IpInstanceIds'] = request.ip_instance_ids
        if not UtilClient.is_unset(request.ip_type):
            query['IpType'] = request.ip_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddCommonBandwidthPackageIps',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddCommonBandwidthPackageIpsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_common_bandwidth_package_ips(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_common_bandwidth_package_ips_with_options(request, runtime)

    async def add_common_bandwidth_package_ips_async(
        self,
        request: vpc_20160428_models.AddCommonBandwidthPackageIpsRequest,
    ) -> vpc_20160428_models.AddCommonBandwidthPackageIpsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_common_bandwidth_package_ips_with_options_async(request, runtime)

    def add_global_acceleration_instance_ip_with_options(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGlobalAccelerationInstanceIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_global_acceleration_instance_ip_with_options_async(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.ip_instance_id):
            query['IpInstanceId'] = request.ip_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddGlobalAccelerationInstanceIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_global_acceleration_instance_ip(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_global_acceleration_instance_ip_with_options(request, runtime)

    async def add_global_acceleration_instance_ip_async(
        self,
        request: vpc_20160428_models.AddGlobalAccelerationInstanceIpRequest,
    ) -> vpc_20160428_models.AddGlobalAccelerationInstanceIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_global_acceleration_instance_ip_with_options_async(request, runtime)

    def add_ipv_6translator_acl_list_entry_with_options(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_entry_comment):
            query['AclEntryComment'] = request.acl_entry_comment
        if not UtilClient.is_unset(request.acl_entry_ip):
            query['AclEntryIp'] = request.acl_entry_ip
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_ipv_6translator_acl_list_entry_with_options_async(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_entry_comment):
            query['AclEntryComment'] = request.acl_entry_comment
        if not UtilClient.is_unset(request.acl_entry_ip):
            query['AclEntryIp'] = request.acl_entry_ip
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddIPv6TranslatorAclListEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_ipv_6translator_acl_list_entry(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_ipv_6translator_acl_list_entry_with_options(request, runtime)

    async def add_ipv_6translator_acl_list_entry_async(
        self,
        request: vpc_20160428_models.AddIPv6TranslatorAclListEntryRequest,
    ) -> vpc_20160428_models.AddIPv6TranslatorAclListEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_ipv_6translator_acl_list_entry_with_options_async(request, runtime)

    def add_public_ip_address_pool_cidr_block_with_options(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_public_ip_address_pool_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_public_ip_address_pool_cidr_block(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_public_ip_address_pool_cidr_block_with_options(request, runtime)

    async def add_public_ip_address_pool_cidr_block_async(
        self,
        request: vpc_20160428_models.AddPublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.AddPublicIpAddressPoolCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_public_ip_address_pool_cidr_block_with_options_async(request, runtime)

    def add_sources_to_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSourcesToTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_sources_to_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddSourcesToTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_sources_to_traffic_mirror_session(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return self.add_sources_to_traffic_mirror_session_with_options(request, runtime)

    async def add_sources_to_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.AddSourcesToTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.AddSourcesToTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.add_sources_to_traffic_mirror_session_with_options_async(request, runtime)

    def allocate_eip_address_with_options(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.activity_id):
            query['ActivityId'] = request.activity_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_with_options(request, runtime)

    async def allocate_eip_address_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressRequest,
    ) -> vpc_20160428_models.AllocateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_with_options_async(request, runtime)

    def allocate_eip_address_pro_with_options(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddressPro',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressProResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_address_pro_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipAddressPro',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipAddressProResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_address_pro(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_address_pro_with_options(request, runtime)

    async def allocate_eip_address_pro_async(
        self,
        request: vpc_20160428_models.AllocateEipAddressProRequest,
    ) -> vpc_20160428_models.AllocateEipAddressProResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_address_pro_with_options_async(request, runtime)

    def allocate_eip_segment_address_with_options(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_mask):
            query['EipMask'] = request.eip_mask
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipSegmentAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipSegmentAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_eip_segment_address_with_options_async(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_mask):
            query['EipMask'] = request.eip_mask
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.netmode):
            query['Netmode'] = request.netmode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateEipSegmentAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateEipSegmentAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_eip_segment_address(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_eip_segment_address_with_options(request, runtime)

    async def allocate_eip_segment_address_async(
        self,
        request: vpc_20160428_models.AllocateEipSegmentAddressRequest,
    ) -> vpc_20160428_models.AllocateEipSegmentAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_eip_segment_address_with_options_async(request, runtime)

    def allocate_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_ipv_6internet_bandwidth_with_options(request, runtime)

    async def allocate_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.AllocateIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.AllocateIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def allocate_vpc_ipv_6cidr_with_options(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_pool_type):
            query['AddressPoolType'] = request.address_pool_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateVpcIpv6Cidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateVpcIpv6CidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def allocate_vpc_ipv_6cidr_with_options_async(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.address_pool_type):
            query['AddressPoolType'] = request.address_pool_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AllocateVpcIpv6Cidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AllocateVpcIpv6CidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def allocate_vpc_ipv_6cidr(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        runtime = util_models.RuntimeOptions()
        return self.allocate_vpc_ipv_6cidr_with_options(request, runtime)

    async def allocate_vpc_ipv_6cidr_async(
        self,
        request: vpc_20160428_models.AllocateVpcIpv6CidrRequest,
    ) -> vpc_20160428_models.AllocateVpcIpv6CidrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.allocate_vpc_ipv_6cidr_with_options_async(request, runtime)

    def apply_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.company_name):
            query['CompanyName'] = request.company_name
        if not UtilClient.is_unset(request.construction_time):
            query['ConstructionTime'] = request.construction_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_type):
            query['LineType'] = request.line_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pminfo):
            query['PMInfo'] = request.pminfo
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.si):
            query['Si'] = request.si
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyPhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ApplyPhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def apply_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.company_name):
            query['CompanyName'] = request.company_name
        if not UtilClient.is_unset(request.construction_time):
            query['ConstructionTime'] = request.construction_time
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_type):
            query['LineType'] = request.line_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pminfo):
            query['PMInfo'] = request.pminfo
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.si):
            query['Si'] = request.si
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ApplyPhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ApplyPhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def apply_physical_connection_loa(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.apply_physical_connection_loawith_options(request, runtime)

    async def apply_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.ApplyPhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.ApplyPhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.apply_physical_connection_loawith_options_async(request, runtime)

    def associate_eip_address_with_options(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_region_id):
            query['InstanceRegionId'] = request.instance_region_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_eip_address_with_options_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_region_id):
            query['InstanceRegionId'] = request.instance_region_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.mode):
            query['Mode'] = request.mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateEipAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateEipAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_eip_address(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_eip_address_with_options(request, runtime)

    async def associate_eip_address_async(
        self,
        request: vpc_20160428_models.AssociateEipAddressRequest,
    ) -> vpc_20160428_models.AssociateEipAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_eip_address_with_options_async(request, runtime)

    def associate_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_id):
            query['BackendServerId'] = request.backend_server_id
        if not UtilClient.is_unset(request.backend_server_region_id):
            query['BackendServerRegionId'] = request.backend_server_region_id
        if not UtilClient.is_unset(request.backend_server_type):
            query['BackendServerType'] = request.backend_server_type
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.backend_server_id):
            query['BackendServerId'] = request.backend_server_id
        if not UtilClient.is_unset(request.backend_server_region_id):
            query['BackendServerRegionId'] = request.backend_server_region_id
        if not UtilClient.is_unset(request.backend_server_type):
            query['BackendServerType'] = request.backend_server_type
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_global_acceleration_instance(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_global_acceleration_instance_with_options(request, runtime)

    async def associate_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.AssociateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.AssociateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_global_acceleration_instance_with_options_async(request, runtime)

    def associate_ha_vip_with_options(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_ha_vip(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_ha_vip_with_options(request, runtime)

    async def associate_ha_vip_async(
        self,
        request: vpc_20160428_models.AssociateHaVipRequest,
    ) -> vpc_20160428_models.AssociateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_ha_vip_with_options_async(request, runtime)

    def associate_network_acl_with_options(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource):
            query['Resource'] = request.resource
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_network_acl(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_network_acl_with_options(request, runtime)

    async def associate_network_acl_async(
        self,
        request: vpc_20160428_models.AssociateNetworkAclRequest,
    ) -> vpc_20160428_models.AssociateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_network_acl_with_options_async(request, runtime)

    def associate_physical_connection_to_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociatePhysicalConnectionToVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_physical_connection_to_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociatePhysicalConnectionToVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_physical_connection_to_virtual_border_router(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_physical_connection_to_virtual_border_router_with_options(request, runtime)

    async def associate_physical_connection_to_virtual_border_router_async(
        self,
        request: vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.AssociatePhysicalConnectionToVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_physical_connection_to_virtual_border_router_with_options_async(request, runtime)

    def associate_route_table_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_table_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_table(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_table_with_options(request, runtime)

    async def associate_route_table_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableRequest,
    ) -> vpc_20160428_models.AssociateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_table_with_options_async(request, runtime)

    def associate_route_table_with_gateway_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTableWithGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableWithGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_table_with_gateway_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTableWithGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTableWithGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_table_with_gateway(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_table_with_gateway_with_options(request, runtime)

    async def associate_route_table_with_gateway_async(
        self,
        request: vpc_20160428_models.AssociateRouteTableWithGatewayRequest,
    ) -> vpc_20160428_models.AssociateRouteTableWithGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_table_with_gateway_with_options_async(request, runtime)

    def associate_route_tables_with_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_ids):
            query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTablesWithVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_route_tables_with_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_ids):
            query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateRouteTablesWithVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_route_tables_with_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_route_tables_with_vpc_gateway_endpoint_with_options(request, runtime)

    async def associate_route_tables_with_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.AssociateRouteTablesWithVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_route_tables_with_vpc_gateway_endpoint_with_options_async(request, runtime)

    def associate_vpc_cidr_block_with_options(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['IPv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_cidr_block):
            query['SecondaryCidrBlock'] = request.secondary_cidr_block
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpcCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpcCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_vpc_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['IPv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.secondary_cidr_block):
            query['SecondaryCidrBlock'] = request.secondary_cidr_block
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpcCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpcCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_vpc_cidr_block(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_vpc_cidr_block_with_options(request, runtime)

    async def associate_vpc_cidr_block_async(
        self,
        request: vpc_20160428_models.AssociateVpcCidrBlockRequest,
    ) -> vpc_20160428_models.AssociateVpcCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_vpc_cidr_block_with_options_async(request, runtime)

    def associate_vpn_gateway_with_certificate_with_options(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.certificate_id):
            query['CertificateId'] = request.certificate_id
        if not UtilClient.is_unset(request.certificate_type):
            query['CertificateType'] = request.certificate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse(),
            self.call_api(params, req, runtime)
        )

    async def associate_vpn_gateway_with_certificate_with_options_async(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.certificate_id):
            query['CertificateId'] = request.certificate_id
        if not UtilClient.is_unset(request.certificate_type):
            query['CertificateType'] = request.certificate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AssociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def associate_vpn_gateway_with_certificate(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return self.associate_vpn_gateway_with_certificate_with_options(request, runtime)

    async def associate_vpn_gateway_with_certificate_async(
        self,
        request: vpc_20160428_models.AssociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.AssociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return await self.associate_vpn_gateway_with_certificate_with_options_async(request, runtime)

    def attach_dhcp_options_set_to_vpc_with_options(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDhcpOptionsSetToVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_dhcp_options_set_to_vpc_with_options_async(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachDhcpOptionsSetToVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_dhcp_options_set_to_vpc(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.attach_dhcp_options_set_to_vpc_with_options(request, runtime)

    async def attach_dhcp_options_set_to_vpc_async(
        self,
        request: vpc_20160428_models.AttachDhcpOptionsSetToVpcRequest,
    ) -> vpc_20160428_models.AttachDhcpOptionsSetToVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.attach_dhcp_options_set_to_vpc_with_options_async(request, runtime)

    def attach_vbr_to_vpconn_with_options(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vpconn_id):
            query['VpconnId'] = request.vpconn_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachVbrToVpconn',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachVbrToVpconnResponse(),
            self.call_api(params, req, runtime)
        )

    async def attach_vbr_to_vpconn_with_options_async(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        if not UtilClient.is_unset(request.vpconn_id):
            query['VpconnId'] = request.vpconn_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AttachVbrToVpconn',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.AttachVbrToVpconnResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def attach_vbr_to_vpconn(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        runtime = util_models.RuntimeOptions()
        return self.attach_vbr_to_vpconn_with_options(request, runtime)

    async def attach_vbr_to_vpconn_async(
        self,
        request: vpc_20160428_models.AttachVbrToVpconnRequest,
    ) -> vpc_20160428_models.AttachVbrToVpconnResponse:
        runtime = util_models.RuntimeOptions()
        return await self.attach_vbr_to_vpconn_with_options_async(request, runtime)

    def cancel_common_bandwidth_package_ip_bandwidth_with_options(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.eip_id):
            query['EipId'] = request.eip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_common_bandwidth_package_ip_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.eip_id):
            query['EipId'] = request.eip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelCommonBandwidthPackageIpBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_common_bandwidth_package_ip_bandwidth(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_common_bandwidth_package_ip_bandwidth_with_options(request, runtime)

    async def cancel_common_bandwidth_package_ip_bandwidth_async(
        self,
        request: vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthRequest,
    ) -> vpc_20160428_models.CancelCommonBandwidthPackageIpBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_common_bandwidth_package_ip_bandwidth_with_options_async(request, runtime)

    def cancel_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def cancel_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CancelPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CancelPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def cancel_physical_connection(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.cancel_physical_connection_with_options(request, runtime)

    async def cancel_physical_connection_async(
        self,
        request: vpc_20160428_models.CancelPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CancelPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.cancel_physical_connection_with_options_async(request, runtime)

    def check_can_allocate_vpc_private_ip_address_with_options(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckCanAllocateVpcPrivateIpAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_can_allocate_vpc_private_ip_address_with_options_async(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.private_ip_address):
            query['PrivateIpAddress'] = request.private_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckCanAllocateVpcPrivateIpAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_can_allocate_vpc_private_ip_address(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_can_allocate_vpc_private_ip_address_with_options(request, runtime)

    async def check_can_allocate_vpc_private_ip_address_async(
        self,
        request: vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressRequest,
    ) -> vpc_20160428_models.CheckCanAllocateVpcPrivateIpAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_can_allocate_vpc_private_ip_address_with_options_async(request, runtime)

    def check_vpn_bgp_enabled_with_options(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckVpnBgpEnabled',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckVpnBgpEnabledResponse(),
            self.call_api(params, req, runtime)
        )

    async def check_vpn_bgp_enabled_with_options_async(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CheckVpnBgpEnabled',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CheckVpnBgpEnabledResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def check_vpn_bgp_enabled(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        runtime = util_models.RuntimeOptions()
        return self.check_vpn_bgp_enabled_with_options(request, runtime)

    async def check_vpn_bgp_enabled_async(
        self,
        request: vpc_20160428_models.CheckVpnBgpEnabledRequest,
    ) -> vpc_20160428_models.CheckVpnBgpEnabledResponse:
        runtime = util_models.RuntimeOptions()
        return await self.check_vpn_bgp_enabled_with_options_async(request, runtime)

    def complete_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_code):
            query['LineCode'] = request.line_code
        if not UtilClient.is_unset(request.line_label):
            query['LineLabel'] = request.line_label
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CompletePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CompletePhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def complete_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.line_code):
            query['LineCode'] = request.line_code
        if not UtilClient.is_unset(request.line_label):
            query['LineLabel'] = request.line_label
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CompletePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CompletePhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def complete_physical_connection_loa(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.complete_physical_connection_loawith_options(request, runtime)

    async def complete_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.CompletePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.CompletePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.complete_physical_connection_loawith_options_async(request, runtime)

    def confirm_physical_connection_with_options(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConfirmPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def confirm_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConfirmPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConfirmPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def confirm_physical_connection(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.confirm_physical_connection_with_options(request, runtime)

    async def confirm_physical_connection_async(
        self,
        request: vpc_20160428_models.ConfirmPhysicalConnectionRequest,
    ) -> vpc_20160428_models.ConfirmPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.confirm_physical_connection_with_options_async(request, runtime)

    def connect_router_interface_with_options(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConnectRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def connect_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConnectRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConnectRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def connect_router_interface(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.connect_router_interface_with_options(request, runtime)

    async def connect_router_interface_async(
        self,
        request: vpc_20160428_models.ConnectRouterInterfaceRequest,
    ) -> vpc_20160428_models.ConnectRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.connect_router_interface_with_options_async(request, runtime)

    def convert_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConvertBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def convert_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='ConvertBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.ConvertBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def convert_bandwidth_package(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.convert_bandwidth_package_with_options(request, runtime)

    async def convert_bandwidth_package_async(
        self,
        request: vpc_20160428_models.ConvertBandwidthPackageRequest,
    ) -> vpc_20160428_models.ConvertBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.convert_bandwidth_package_with_options_async(request, runtime)

    def copy_network_acl_entries_with_options(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_network_acl_id):
            query['SourceNetworkAclId'] = request.source_network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyNetworkAclEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CopyNetworkAclEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def copy_network_acl_entries_with_options_async(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.source_network_acl_id):
            query['SourceNetworkAclId'] = request.source_network_acl_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CopyNetworkAclEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CopyNetworkAclEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def copy_network_acl_entries(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.copy_network_acl_entries_with_options(request, runtime)

    async def copy_network_acl_entries_async(
        self,
        request: vpc_20160428_models.CopyNetworkAclEntriesRequest,
    ) -> vpc_20160428_models.CopyNetworkAclEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.copy_network_acl_entries_with_options_async(request, runtime)

    def create_bgp_group_with_options(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.is_fake_asn):
            query['IsFakeAsn'] = request.is_fake_asn
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_asn):
            query['PeerAsn'] = request.peer_asn
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_bgp_group_with_options_async(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.is_fake_asn):
            query['IsFakeAsn'] = request.is_fake_asn
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_asn):
            query['PeerAsn'] = request.peer_asn
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_bgp_group(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_bgp_group_with_options(request, runtime)

    async def create_bgp_group_async(
        self,
        request: vpc_20160428_models.CreateBgpGroupRequest,
    ) -> vpc_20160428_models.CreateBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_bgp_group_with_options_async(request, runtime)

    def create_bgp_peer_with_options(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bfd_multi_hop):
            query['BfdMultiHop'] = request.bfd_multi_hop
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_bfd):
            query['EnableBfd'] = request.enable_bfd
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_ip_address):
            query['PeerIpAddress'] = request.peer_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpPeerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_bgp_peer_with_options_async(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bfd_multi_hop):
            query['BfdMultiHop'] = request.bfd_multi_hop
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_bfd):
            query['EnableBfd'] = request.enable_bfd
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_ip_address):
            query['PeerIpAddress'] = request.peer_ip_address
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateBgpPeerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_bgp_peer(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_bgp_peer_with_options(request, runtime)

    async def create_bgp_peer_async(
        self,
        request: vpc_20160428_models.CreateBgpPeerRequest,
    ) -> vpc_20160428_models.CreateBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_bgp_peer_with_options_async(request, runtime)

    def create_common_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.ratio):
            query['Ratio'] = request.ratio
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        if not UtilClient.is_unset(request.zone):
            query['Zone'] = request.zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCommonBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_common_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.ratio):
            query['Ratio'] = request.ratio
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_types):
            query['SecurityProtectionTypes'] = request.security_protection_types
        if not UtilClient.is_unset(request.zone):
            query['Zone'] = request.zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCommonBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_common_bandwidth_package(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_common_bandwidth_package_with_options(request, runtime)

    async def create_common_bandwidth_package_async(
        self,
        request: vpc_20160428_models.CreateCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.CreateCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_common_bandwidth_package_with_options_async(request, runtime)

    def create_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asn):
            query['Asn'] = request.asn
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asn):
            query['Asn'] = request.asn
        if not UtilClient.is_unset(request.auth_key):
            query['AuthKey'] = request.auth_key
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_customer_gateway(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_customer_gateway_with_options(request, runtime)

    async def create_customer_gateway_async(
        self,
        request: vpc_20160428_models.CreateCustomerGatewayRequest,
    ) -> vpc_20160428_models.CreateCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_customer_gateway_with_options_async(request, runtime)

    def create_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.boot_file_name):
            query['BootFileName'] = request.boot_file_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_description):
            query['DhcpOptionsSetDescription'] = request.dhcp_options_set_description
        if not UtilClient.is_unset(request.dhcp_options_set_name):
            query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_name_servers):
            query['DomainNameServers'] = request.domain_name_servers
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_6lease_time):
            query['Ipv6LeaseTime'] = request.ipv_6lease_time
        if not UtilClient.is_unset(request.lease_time):
            query['LeaseTime'] = request.lease_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tftpserver_name):
            query['TFTPServerName'] = request.tftpserver_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.boot_file_name):
            query['BootFileName'] = request.boot_file_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_description):
            query['DhcpOptionsSetDescription'] = request.dhcp_options_set_description
        if not UtilClient.is_unset(request.dhcp_options_set_name):
            query['DhcpOptionsSetName'] = request.dhcp_options_set_name
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_name_servers):
            query['DomainNameServers'] = request.domain_name_servers
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_6lease_time):
            query['Ipv6LeaseTime'] = request.ipv_6lease_time
        if not UtilClient.is_unset(request.lease_time):
            query['LeaseTime'] = request.lease_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tftpserver_name):
            query['TFTPServerName'] = request.tftpserver_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_dhcp_options_set(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_dhcp_options_set_with_options(request, runtime)

    async def create_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.CreateDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.CreateDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_dhcp_options_set_with_options_async(request, runtime)

    def create_express_cloud_connection_with_options(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.contact_mail):
            query['ContactMail'] = request.contact_mail
        if not UtilClient.is_unset(request.contact_tel):
            query['ContactTel'] = request.contact_tel
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.idcard_no):
            query['IDCardNo'] = request.idcard_no
        if not UtilClient.is_unset(request.idc_sp):
            query['IdcSP'] = request.idc_sp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_city):
            query['PeerCity'] = request.peer_city
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_ecc_id):
            query['RedundantEccId'] = request.redundant_ecc_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateExpressCloudConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_express_cloud_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.contact_mail):
            query['ContactMail'] = request.contact_mail
        if not UtilClient.is_unset(request.contact_tel):
            query['ContactTel'] = request.contact_tel
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.idcard_no):
            query['IDCardNo'] = request.idcard_no
        if not UtilClient.is_unset(request.idc_sp):
            query['IdcSP'] = request.idc_sp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_city):
            query['PeerCity'] = request.peer_city
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_ecc_id):
            query['RedundantEccId'] = request.redundant_ecc_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateExpressCloudConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateExpressCloudConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_express_cloud_connection(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_express_cloud_connection_with_options(request, runtime)

    async def create_express_cloud_connection_async(
        self,
        request: vpc_20160428_models.CreateExpressCloudConnectionRequest,
    ) -> vpc_20160428_models.CreateExpressCloudConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_express_cloud_connection_with_options_async(request, runtime)

    def create_flow_log_with_options(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aggregation_interval):
            query['AggregationInterval'] = request.aggregation_interval
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.flow_log_name):
            query['FlowLogName'] = request.flow_log_name
        if not UtilClient.is_unset(request.log_store_name):
            query['LogStoreName'] = request.log_store_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.aggregation_interval):
            query['AggregationInterval'] = request.aggregation_interval
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.flow_log_name):
            query['FlowLogName'] = request.flow_log_name
        if not UtilClient.is_unset(request.log_store_name):
            query['LogStoreName'] = request.log_store_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_flow_log(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_flow_log_with_options(request, runtime)

    async def create_flow_log_async(
        self,
        request: vpc_20160428_models.CreateFlowLogRequest,
    ) -> vpc_20160428_models.CreateFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_flow_log_with_options_async(request, runtime)

    def create_forward_entry_with_options(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_break):
            query['PortBreak'] = request.port_break
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_break):
            query['PortBreak'] = request.port_break
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_forward_entry(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_forward_entry_with_options(request, runtime)

    async def create_forward_entry_async(
        self,
        request: vpc_20160428_models.CreateForwardEntryRequest,
    ) -> vpc_20160428_models.CreateForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_forward_entry_with_options_async(request, runtime)

    def create_full_nat_entry_with_options(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_ip):
            query['AccessIp'] = request.access_ip
        if not UtilClient.is_unset(request.access_port):
            query['AccessPort'] = request.access_port
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_description):
            query['FullNatEntryDescription'] = request.full_nat_entry_description
        if not UtilClient.is_unset(request.full_nat_entry_name):
            query['FullNatEntryName'] = request.full_nat_entry_name
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_port):
            query['NatIpPort'] = request.nat_ip_port
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFullNatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_full_nat_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_ip):
            query['AccessIp'] = request.access_ip
        if not UtilClient.is_unset(request.access_port):
            query['AccessPort'] = request.access_port
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_description):
            query['FullNatEntryDescription'] = request.full_nat_entry_description
        if not UtilClient.is_unset(request.full_nat_entry_name):
            query['FullNatEntryName'] = request.full_nat_entry_name
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_port):
            query['NatIpPort'] = request.nat_ip_port
        if not UtilClient.is_unset(request.network_interface_id):
            query['NetworkInterfaceId'] = request.network_interface_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateFullNatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_full_nat_entry(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_full_nat_entry_with_options(request, runtime)

    async def create_full_nat_entry_async(
        self,
        request: vpc_20160428_models.CreateFullNatEntryRequest,
    ) -> vpc_20160428_models.CreateFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_full_nat_entry_with_options_async(request, runtime)

    def create_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.bandwidth_type):
            query['BandwidthType'] = request.bandwidth_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_location):
            query['ServiceLocation'] = request.service_location
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.bandwidth_type):
            query['BandwidthType'] = request.bandwidth_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_location):
            query['ServiceLocation'] = request.service_location
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_global_acceleration_instance(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_global_acceleration_instance_with_options(request, runtime)

    async def create_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.CreateGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.CreateGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_global_acceleration_instance_with_options_async(request, runtime)

    def create_ha_vip_with_options(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ha_vip(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ha_vip_with_options(request, runtime)

    async def create_ha_vip_async(
        self,
        request: vpc_20160428_models.CreateHaVipRequest,
    ) -> vpc_20160428_models.CreateHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ha_vip_with_options_async(request, runtime)

    def create_ipv_6translator_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_with_options(request, runtime)

    async def create_ipv_6translator_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_with_options_async(request, runtime)

    def create_ipv_6translator_acl_list_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_name):
            query['AclName'] = request.acl_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorAclListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_acl_list_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_name):
            query['AclName'] = request.acl_name
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorAclListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator_acl_list(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_acl_list_with_options(request, runtime)

    async def create_ipv_6translator_acl_list_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_acl_list_with_options_async(request, runtime)

    def create_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_status):
            query['AclStatus'] = request.acl_status
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.allocate_ipv_6port):
            query['AllocateIpv6Port'] = request.allocate_ipv_6port
        if not UtilClient.is_unset(request.backend_ipv_4addr):
            query['BackendIpv4Addr'] = request.backend_ipv_4addr
        if not UtilClient.is_unset(request.backend_ipv_4port):
            query['BackendIpv4Port'] = request.backend_ipv_4port
        if not UtilClient.is_unset(request.entry_bandwidth):
            query['EntryBandwidth'] = request.entry_bandwidth
        if not UtilClient.is_unset(request.entry_description):
            query['EntryDescription'] = request.entry_description
        if not UtilClient.is_unset(request.entry_name):
            query['EntryName'] = request.entry_name
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trans_protocol):
            query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_status):
            query['AclStatus'] = request.acl_status
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.allocate_ipv_6port):
            query['AllocateIpv6Port'] = request.allocate_ipv_6port
        if not UtilClient.is_unset(request.backend_ipv_4addr):
            query['BackendIpv4Addr'] = request.backend_ipv_4addr
        if not UtilClient.is_unset(request.backend_ipv_4port):
            query['BackendIpv4Port'] = request.backend_ipv_4port
        if not UtilClient.is_unset(request.entry_bandwidth):
            query['EntryBandwidth'] = request.entry_bandwidth
        if not UtilClient.is_unset(request.entry_description):
            query['EntryDescription'] = request.entry_description
        if not UtilClient.is_unset(request.entry_name):
            query['EntryName'] = request.entry_name
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trans_protocol):
            query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6translator_entry_with_options(request, runtime)

    async def create_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.CreateIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.CreateIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6translator_entry_with_options_async(request, runtime)

    def create_ipsec_server_with_options(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ip_sec_server_name):
            query['IpSecServerName'] = request.ip_sec_server_name
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.psk):
            query['Psk'] = request.psk
        if not UtilClient.is_unset(request.psk_enabled):
            query['PskEnabled'] = request.psk_enabled
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpsecServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipsec_server_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ip_sec_server_name):
            query['IpSecServerName'] = request.ip_sec_server_name
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.psk):
            query['Psk'] = request.psk
        if not UtilClient.is_unset(request.psk_enabled):
            query['PskEnabled'] = request.psk_enabled
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpsecServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipsec_server(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipsec_server_with_options(request, runtime)

    async def create_ipsec_server_async(
        self,
        request: vpc_20160428_models.CreateIpsecServerRequest,
    ) -> vpc_20160428_models.CreateIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipsec_server_with_options_async(request, runtime)

    def create_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_description):
            query['Ipv4GatewayDescription'] = request.ipv_4gateway_description
        if not UtilClient.is_unset(request.ipv_4gateway_name):
            query['Ipv4GatewayName'] = request.ipv_4gateway_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_description):
            query['Ipv4GatewayDescription'] = request.ipv_4gateway_description
        if not UtilClient.is_unset(request.ipv_4gateway_name):
            query['Ipv4GatewayName'] = request.ipv_4gateway_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_4gateway(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_4gateway_with_options(request, runtime)

    async def create_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.CreateIpv4GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_4gateway_with_options_async(request, runtime)

    def create_ipv_6egress_only_rule_with_options(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6egress_only_rule_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6egress_only_rule(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6egress_only_rule_with_options(request, runtime)

    async def create_ipv_6egress_only_rule_async(
        self,
        request: vpc_20160428_models.CreateIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.CreateIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6egress_only_rule_with_options_async(request, runtime)

    def create_ipv_6gateway_with_options(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ipv_6gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateIpv6GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ipv_6gateway(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ipv_6gateway_with_options(request, runtime)

    async def create_ipv_6gateway_async(
        self,
        request: vpc_20160428_models.CreateIpv6GatewayRequest,
    ) -> vpc_20160428_models.CreateIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ipv_6gateway_with_options_async(request, runtime)

    def create_nat_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.eip_bind_mode):
            query['EipBindMode'] = request.eip_bind_mode
        if not UtilClient.is_unset(request.icmp_reply_enabled):
            query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nat_type):
            query['NatType'] = request.nat_type
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.duration):
            query['Duration'] = request.duration
        if not UtilClient.is_unset(request.eip_bind_mode):
            query['EipBindMode'] = request.eip_bind_mode
        if not UtilClient.is_unset(request.icmp_reply_enabled):
            query['IcmpReplyEnabled'] = request.icmp_reply_enabled
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.internet_charge_type):
            query['InternetChargeType'] = request.internet_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nat_type):
            query['NatType'] = request.nat_type
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_gateway(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_nat_gateway_with_options(request, runtime)

    async def create_nat_gateway_async(
        self,
        request: vpc_20160428_models.CreateNatGatewayRequest,
    ) -> vpc_20160428_models.CreateNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_gateway_with_options_async(request, runtime)

    def create_nat_ip_with_options(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_id):
            query['NatIpCidrId'] = request.nat_ip_cidr_id
        if not UtilClient.is_unset(request.nat_ip_description):
            query['NatIpDescription'] = request.nat_ip_description
        if not UtilClient.is_unset(request.nat_ip_name):
            query['NatIpName'] = request.nat_ip_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_ip_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIp'] = request.nat_ip
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_id):
            query['NatIpCidrId'] = request.nat_ip_cidr_id
        if not UtilClient.is_unset(request.nat_ip_description):
            query['NatIpDescription'] = request.nat_ip_description
        if not UtilClient.is_unset(request.nat_ip_name):
            query['NatIpName'] = request.nat_ip_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_ip(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_nat_ip_with_options(request, runtime)

    async def create_nat_ip_async(
        self,
        request: vpc_20160428_models.CreateNatIpRequest,
    ) -> vpc_20160428_models.CreateNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_ip_with_options_async(request, runtime)

    def create_nat_ip_cidr_with_options(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_description):
            query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        if not UtilClient.is_unset(request.nat_ip_cidr_name):
            query['NatIpCidrName'] = request.nat_ip_cidr_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpCidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_ip_cidr_with_options_async(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.nat_ip_cidr_description):
            query['NatIpCidrDescription'] = request.nat_ip_cidr_description
        if not UtilClient.is_unset(request.nat_ip_cidr_name):
            query['NatIpCidrName'] = request.nat_ip_cidr_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNatIpCidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_ip_cidr(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_nat_ip_cidr_with_options(request, runtime)

    async def create_nat_ip_cidr_async(
        self,
        request: vpc_20160428_models.CreateNatIpCidrRequest,
    ) -> vpc_20160428_models.CreateNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_ip_cidr_with_options_async(request, runtime)

    def create_network_acl_with_options(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_network_acl(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_network_acl_with_options(request, runtime)

    async def create_network_acl_async(
        self,
        request: vpc_20160428_models.CreateNetworkAclRequest,
    ) -> vpc_20160428_models.CreateNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_network_acl_with_options_async(request, runtime)

    def create_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_location):
            query['PeerLocation'] = request.peer_location
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.bandwidth):
            query['bandwidth'] = request.bandwidth
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_with_options(request, runtime)

    async def create_physical_connection_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_with_options_async(request, runtime)

    def create_physical_connection_occupancy_order_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionOccupancyOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_occupancy_order_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionOccupancyOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection_occupancy_order(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_occupancy_order_with_options(request, runtime)

    async def create_physical_connection_occupancy_order_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionOccupancyOrderResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_occupancy_order_with_options_async(request, runtime)

    def create_physical_connection_setup_order_with_options(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionSetupOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_physical_connection_setup_order_with_options_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.line_operator):
            query['LineOperator'] = request.line_operator
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port_type):
            query['PortType'] = request.port_type
        if not UtilClient.is_unset(request.redundant_physical_connection_id):
            query['RedundantPhysicalConnectionId'] = request.redundant_physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePhysicalConnectionSetupOrder',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_physical_connection_setup_order(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_physical_connection_setup_order_with_options(request, runtime)

    async def create_physical_connection_setup_order_async(
        self,
        request: vpc_20160428_models.CreatePhysicalConnectionSetupOrderRequest,
    ) -> vpc_20160428_models.CreatePhysicalConnectionSetupOrderResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_physical_connection_setup_order_with_options_async(request, runtime)

    def create_public_ip_address_pool_with_options(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePublicIpAddressPoolResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_public_ip_address_pool_with_options_async(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreatePublicIpAddressPoolResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_public_ip_address_pool(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_public_ip_address_pool_with_options(request, runtime)

    async def create_public_ip_address_pool_async(
        self,
        request: vpc_20160428_models.CreatePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.CreatePublicIpAddressPoolResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_public_ip_address_pool_with_options_async(request, runtime)

    def create_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_entry(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_route_entry_with_options(request, runtime)

    async def create_route_entry_async(
        self,
        request: vpc_20160428_models.CreateRouteEntryRequest,
    ) -> vpc_20160428_models.CreateRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_route_entry_with_options_async(request, runtime)

    def create_route_table_with_options(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associate_type):
            query['AssociateType'] = request.associate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_route_table_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associate_type):
            query['AssociateType'] = request.associate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_route_table(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_route_table_with_options(request, runtime)

    async def create_route_table_async(
        self,
        request: vpc_20160428_models.CreateRouteTableRequest,
    ) -> vpc_20160428_models.CreateRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_route_table_with_options_async(request, runtime)

    def create_router_interface_with_options(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_point_id):
            query['AccessPointId'] = request.access_point_id
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.health_check_source_ip):
            query['HealthCheckSourceIp'] = request.health_check_source_ip
        if not UtilClient.is_unset(request.health_check_target_ip):
            query['HealthCheckTargetIp'] = request.health_check_target_ip
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.opposite_access_point_id):
            query['OppositeAccessPointId'] = request.opposite_access_point_id
        if not UtilClient.is_unset(request.opposite_interface_id):
            query['OppositeInterfaceId'] = request.opposite_interface_id
        if not UtilClient.is_unset(request.opposite_interface_owner_id):
            query['OppositeInterfaceOwnerId'] = request.opposite_interface_owner_id
        if not UtilClient.is_unset(request.opposite_region_id):
            query['OppositeRegionId'] = request.opposite_region_id
        if not UtilClient.is_unset(request.opposite_router_id):
            query['OppositeRouterId'] = request.opposite_router_id
        if not UtilClient.is_unset(request.opposite_router_type):
            query['OppositeRouterType'] = request.opposite_router_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.pricing_cycle):
            query['PricingCycle'] = request.pricing_cycle
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.role):
            query['Role'] = request.role
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_router_interface(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_router_interface_with_options(request, runtime)

    async def create_router_interface_async(
        self,
        request: vpc_20160428_models.CreateRouterInterfaceRequest,
    ) -> vpc_20160428_models.CreateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_router_interface_with_options_async(request, runtime)

    def create_snat_entry_with_options(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_affinity):
            query['EipAffinity'] = request.eip_affinity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.eip_affinity):
            query['EipAffinity'] = request.eip_affinity
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_snat_entry(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_snat_entry_with_options(request, runtime)

    async def create_snat_entry_async(
        self,
        request: vpc_20160428_models.CreateSnatEntryRequest,
    ) -> vpc_20160428_models.CreateSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_snat_entry_with_options_async(request, runtime)

    def create_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ssl_vpn_client_cert_with_options(request, runtime)

    async def create_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.CreateSslVpnClientCertRequest,
    ) -> vpc_20160428_models.CreateSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ssl_vpn_client_cert_with_options_async(request, runtime)

    def create_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cipher):
            query['Cipher'] = request.cipher
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.compress):
            query['Compress'] = request.compress
        if not UtilClient.is_unset(request.enable_multi_factor_auth):
            query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        if not UtilClient.is_unset(request.idaa_sinstance_id):
            query['IDaaSInstanceId'] = request.idaa_sinstance_id
        if not UtilClient.is_unset(request.idaa_sregion_id):
            query['IDaaSRegionId'] = request.idaa_sregion_id
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cipher):
            query['Cipher'] = request.cipher
        if not UtilClient.is_unset(request.client_ip_pool):
            query['ClientIpPool'] = request.client_ip_pool
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.compress):
            query['Compress'] = request.compress
        if not UtilClient.is_unset(request.enable_multi_factor_auth):
            query['EnableMultiFactorAuth'] = request.enable_multi_factor_auth
        if not UtilClient.is_unset(request.idaa_sinstance_id):
            query['IDaaSInstanceId'] = request.idaa_sinstance_id
        if not UtilClient.is_unset(request.idaa_sregion_id):
            query['IDaaSRegionId'] = request.idaa_sregion_id
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateSslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ssl_vpn_server(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_ssl_vpn_server_with_options(request, runtime)

    async def create_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.CreateSslVpnServerRequest,
    ) -> vpc_20160428_models.CreateSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_ssl_vpn_server_with_options_async(request, runtime)

    def create_traffic_mirror_filter_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_description):
            query['TrafficMirrorFilterDescription'] = request.traffic_mirror_filter_description
        if not UtilClient.is_unset(request.traffic_mirror_filter_name):
            query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_filter_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_description):
            query['TrafficMirrorFilterDescription'] = request.traffic_mirror_filter_description
        if not UtilClient.is_unset(request.traffic_mirror_filter_name):
            query['TrafficMirrorFilterName'] = request.traffic_mirror_filter_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_filter(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_filter_with_options(request, runtime)

    async def create_traffic_mirror_filter_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_filter_with_options_async(request, runtime)

    def create_traffic_mirror_filter_rules_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_filter_rules_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.egress_rules):
            query['EgressRules'] = request.egress_rules
        if not UtilClient.is_unset(request.ingress_rules):
            query['IngressRules'] = request.ingress_rules
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_filter_rules(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_filter_rules_with_options(request, runtime)

    async def create_traffic_mirror_filter_rules_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_filter_rules_with_options_async(request, runtime)

    def create_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enabled):
            query['Enabled'] = request.enabled
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.packet_length):
            query['PacketLength'] = request.packet_length
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_session_description):
            query['TrafficMirrorSessionDescription'] = request.traffic_mirror_session_description
        if not UtilClient.is_unset(request.traffic_mirror_session_name):
            query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        if not UtilClient.is_unset(request.traffic_mirror_target_id):
            query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        if not UtilClient.is_unset(request.traffic_mirror_target_type):
            query['TrafficMirrorTargetType'] = request.traffic_mirror_target_type
        if not UtilClient.is_unset(request.virtual_network_id):
            query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enabled):
            query['Enabled'] = request.enabled
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.packet_length):
            query['PacketLength'] = request.packet_length
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_session_description):
            query['TrafficMirrorSessionDescription'] = request.traffic_mirror_session_description
        if not UtilClient.is_unset(request.traffic_mirror_session_name):
            query['TrafficMirrorSessionName'] = request.traffic_mirror_session_name
        if not UtilClient.is_unset(request.traffic_mirror_source_ids):
            query['TrafficMirrorSourceIds'] = request.traffic_mirror_source_ids
        if not UtilClient.is_unset(request.traffic_mirror_target_id):
            query['TrafficMirrorTargetId'] = request.traffic_mirror_target_id
        if not UtilClient.is_unset(request.traffic_mirror_target_type):
            query['TrafficMirrorTargetType'] = request.traffic_mirror_target_type
        if not UtilClient.is_unset(request.virtual_network_id):
            query['VirtualNetworkId'] = request.virtual_network_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_traffic_mirror_session(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_traffic_mirror_session_with_options(request, runtime)

    async def create_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.CreateTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.CreateTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_traffic_mirror_session_with_options_async(request, runtime)

    def create_vswitch_with_options(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_ipv_6cidr_block):
            query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_ipv_6cidr_block):
            query['VpcIpv6CidrBlock'] = request.vpc_ipv_6cidr_block
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vswitch(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vswitch_with_options(request, runtime)

    async def create_vswitch_async(
        self,
        request: vpc_20160428_models.CreateVSwitchRequest,
    ) -> vpc_20160428_models.CreateVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vswitch_with_options_async(request, runtime)

    def create_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_vbr_id):
            query['PeerVbrId'] = request.peer_vbr_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_vbr_id):
            query['PeerVbrId'] = request.peer_vbr_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vbr_ha(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vbr_ha_with_options(request, runtime)

    async def create_vbr_ha_async(
        self,
        request: vpc_20160428_models.CreateVbrHaRequest,
    ) -> vpc_20160428_models.CreateVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vbr_ha_with_options_async(request, runtime)

    def create_vco_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVcoRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vco_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVcoRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vco_route_entry(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vco_route_entry_with_options(request, runtime)

    async def create_vco_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVcoRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVcoRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vco_route_entry_with_options_async(request, runtime)

    def create_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.circuit_code):
            query['CircuitCode'] = request.circuit_code
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.local_gateway_ip):
            query['LocalGatewayIp'] = request.local_gateway_ip
        if not UtilClient.is_unset(request.local_ipv_6gateway_ip):
            query['LocalIpv6GatewayIp'] = request.local_ipv_6gateway_ip
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.peer_gateway_ip):
            query['PeerGatewayIp'] = request.peer_gateway_ip
        if not UtilClient.is_unset(request.peer_ipv_6gateway_ip):
            query['PeerIpv6GatewayIp'] = request.peer_ipv_6gateway_ip
        if not UtilClient.is_unset(request.peering_ipv_6subnet_mask):
            query['PeeringIpv6SubnetMask'] = request.peering_ipv_6subnet_mask
        if not UtilClient.is_unset(request.peering_subnet_mask):
            query['PeeringSubnetMask'] = request.peering_subnet_mask
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_owner_id):
            query['VbrOwnerId'] = request.vbr_owner_id
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_border_router(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_border_router_with_options(request, runtime)

    async def create_virtual_border_router_async(
        self,
        request: vpc_20160428_models.CreateVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.CreateVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_border_router_with_options_async(request, runtime)

    def create_virtual_physical_connection_with_options(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.vpconn_ali_uid):
            query['VpconnAliUid'] = request.vpconn_ali_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_virtual_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vlan_id):
            query['VlanId'] = request.vlan_id
        if not UtilClient.is_unset(request.vpconn_ali_uid):
            query['VpconnAliUid'] = request.vpconn_ali_uid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVirtualPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVirtualPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_virtual_physical_connection(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_virtual_physical_connection_with_options(request, runtime)

    async def create_virtual_physical_connection_async(
        self,
        request: vpc_20160428_models.CreateVirtualPhysicalConnectionRequest,
    ) -> vpc_20160428_models.CreateVirtualPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_virtual_physical_connection_with_options_async(request, runtime)

    def create_vpc_with_options(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.enable_ipv_6):
            query['EnableIpv6'] = request.enable_ipv_6
        if not UtilClient.is_unset(request.ipv_6cidr_block):
            query['Ipv6CidrBlock'] = request.ipv_6cidr_block
        if not UtilClient.is_unset(request.ipv_6isp):
            query['Ipv6Isp'] = request.ipv_6isp
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.user_cidr):
            query['UserCidr'] = request.user_cidr
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
    ) -> vpc_20160428_models.CreateVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_with_options(request, runtime)

    async def create_vpc_async(
        self,
        request: vpc_20160428_models.CreateVpcRequest,
    ) -> vpc_20160428_models.CreateVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_with_options_async(request, runtime)

    def create_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_description):
            query['EndpointDescription'] = request.endpoint_description
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy_document):
            query['PolicyDocument'] = request.policy_document
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_description):
            query['EndpointDescription'] = request.endpoint_description
        if not UtilClient.is_unset(request.endpoint_name):
            query['EndpointName'] = request.endpoint_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.policy_document):
            query['PolicyDocument'] = request.policy_document
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_gateway_endpoint_with_options(request, runtime)

    async def create_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.CreateVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.CreateVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_gateway_endpoint_with_options_async(request, runtime)

    def create_vpc_prefix_list_with_options(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_description):
            query['PrefixListDescription'] = request.prefix_list_description
        if not UtilClient.is_unset(request.prefix_list_entrys):
            query['PrefixListEntrys'] = request.prefix_list_entrys
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcPrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_prefix_list_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.max_entries):
            query['MaxEntries'] = request.max_entries
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_description):
            query['PrefixListDescription'] = request.prefix_list_description
        if not UtilClient.is_unset(request.prefix_list_entrys):
            query['PrefixListEntrys'] = request.prefix_list_entrys
        if not UtilClient.is_unset(request.prefix_list_name):
            query['PrefixListName'] = request.prefix_list_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpcPrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_prefix_list(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_prefix_list_with_options(request, runtime)

    async def create_vpc_prefix_list_async(
        self,
        request: vpc_20160428_models.CreateVpcPrefixListRequest,
    ) -> vpc_20160428_models.CreateVpcPrefixListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_prefix_list_with_options_async(request, runtime)

    def create_vpconn_from_vbr_with_options(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpconnFromVbr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpconnFromVbrResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpconn_from_vbr_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.order_mode):
            query['OrderMode'] = request.order_mode
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.token):
            query['Token'] = request.token
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpconnFromVbr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpconnFromVbrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpconn_from_vbr(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpconn_from_vbr_with_options(request, runtime)

    async def create_vpconn_from_vbr_async(
        self,
        request: vpc_20160428_models.CreateVpconnFromVbrRequest,
    ) -> vpc_20160428_models.CreateVpconnFromVbrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpconn_from_vbr_with_options_async(request, runtime)

    def create_vpn_attachment_with_options(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_cert):
            query['RemoteCaCert'] = request.remote_ca_cert
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnAttachmentResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_attachment_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_cert):
            query['RemoteCaCert'] = request.remote_ca_cert
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnAttachmentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_attachment(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_attachment_with_options(request, runtime)

    async def create_vpn_attachment_async(
        self,
        request: vpc_20160428_models.CreateVpnAttachmentRequest,
    ) -> vpc_20160428_models.CreateVpnAttachmentResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_attachment_with_options_async(request, runtime)

    def create_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_certificate):
            query['RemoteCaCertificate'] = request.remote_ca_certificate
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_config_route):
            query['AutoConfigRoute'] = request.auto_config_route
        if not UtilClient.is_unset(request.bgp_config):
            query['BgpConfig'] = request.bgp_config
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.effect_immediately):
            query['EffectImmediately'] = request.effect_immediately
        if not UtilClient.is_unset(request.enable_dpd):
            query['EnableDpd'] = request.enable_dpd
        if not UtilClient.is_unset(request.enable_nat_traversal):
            query['EnableNatTraversal'] = request.enable_nat_traversal
        if not UtilClient.is_unset(request.health_check_config):
            query['HealthCheckConfig'] = request.health_check_config
        if not UtilClient.is_unset(request.ike_config):
            query['IkeConfig'] = request.ike_config
        if not UtilClient.is_unset(request.ipsec_config):
            query['IpsecConfig'] = request.ipsec_config
        if not UtilClient.is_unset(request.local_subnet):
            query['LocalSubnet'] = request.local_subnet
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.remote_ca_certificate):
            query['RemoteCaCertificate'] = request.remote_ca_certificate
        if not UtilClient.is_unset(request.remote_subnet):
            query['RemoteSubnet'] = request.remote_subnet
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_connection(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_connection_with_options(request, runtime)

    async def create_vpn_connection_async(
        self,
        request: vpc_20160428_models.CreateVpnConnectionRequest,
    ) -> vpc_20160428_models.CreateVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_connection_with_options_async(request, runtime)

    def create_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipsec):
            query['EnableIpsec'] = request.enable_ipsec
        if not UtilClient.is_unset(request.enable_ssl):
            query['EnableSsl'] = request.enable_ssl
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_connections):
            query['SslConnections'] = request.ssl_connections
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpn_type):
            query['VpnType'] = request.vpn_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.auto_pay):
            query['AutoPay'] = request.auto_pay
        if not UtilClient.is_unset(request.bandwidth):
            query['Bandwidth'] = request.bandwidth
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.enable_ipsec):
            query['EnableIpsec'] = request.enable_ipsec
        if not UtilClient.is_unset(request.enable_ssl):
            query['EnableSsl'] = request.enable_ssl
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_connections):
            query['SslConnections'] = request.ssl_connections
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpn_type):
            query['VpnType'] = request.vpn_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_gateway(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_gateway_with_options(request, runtime)

    async def create_vpn_gateway_async(
        self,
        request: vpc_20160428_models.CreateVpnGatewayRequest,
    ) -> vpc_20160428_models.CreateVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_gateway_with_options_async(request, runtime)

    def create_vpn_pbr_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.route_source):
            query['RouteSource'] = request.route_source
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnPbrRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_pbr_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.route_source):
            query['RouteSource'] = request.route_source
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnPbrRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_pbr_route_entry(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_pbr_route_entry_with_options(request, runtime)

    async def create_vpn_pbr_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_pbr_route_entry_with_options_async(request, runtime)

    def create_vpn_route_entry_with_options(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpn_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.publish_vpc):
            query['PublishVpc'] = request.publish_vpc
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.CreateVpnRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpn_route_entry(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.create_vpn_route_entry_with_options(request, runtime)

    async def create_vpn_route_entry_async(
        self,
        request: vpc_20160428_models.CreateVpnRouteEntryRequest,
    ) -> vpc_20160428_models.CreateVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.create_vpn_route_entry_with_options_async(request, runtime)

    def deactivate_router_interface_with_options(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactivateRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactivate_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactivateRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactivateRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactivate_router_interface(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.deactivate_router_interface_with_options(request, runtime)

    async def deactivate_router_interface_async(
        self,
        request: vpc_20160428_models.DeactivateRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeactivateRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deactivate_router_interface_with_options_async(request, runtime)

    def deactive_flow_log_with_options(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactiveFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def deactive_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeactiveFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeactiveFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deactive_flow_log(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.deactive_flow_log_with_options(request, runtime)

    async def deactive_flow_log_async(
        self,
        request: vpc_20160428_models.DeactiveFlowLogRequest,
    ) -> vpc_20160428_models.DeactiveFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deactive_flow_log_with_options_async(request, runtime)

    def delete_bgp_group_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_group_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpGroup',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_group(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_group_with_options(request, runtime)

    async def delete_bgp_group_async(
        self,
        request: vpc_20160428_models.DeleteBgpGroupRequest,
    ) -> vpc_20160428_models.DeleteBgpGroupResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_group_with_options_async(request, runtime)

    def delete_bgp_network_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpNetworkResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_network_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dst_cidr_block):
            query['DstCidrBlock'] = request.dst_cidr_block
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpNetwork',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpNetworkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_network(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_network_with_options(request, runtime)

    async def delete_bgp_network_async(
        self,
        request: vpc_20160428_models.DeleteBgpNetworkRequest,
    ) -> vpc_20160428_models.DeleteBgpNetworkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_network_with_options_async(request, runtime)

    def delete_bgp_peer_with_options(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_peer_id):
            query['BgpPeerId'] = request.bgp_peer_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpPeerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_bgp_peer_with_options_async(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_peer_id):
            query['BgpPeerId'] = request.bgp_peer_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteBgpPeer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteBgpPeerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_bgp_peer(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_bgp_peer_with_options(request, runtime)

    async def delete_bgp_peer_async(
        self,
        request: vpc_20160428_models.DeleteBgpPeerRequest,
    ) -> vpc_20160428_models.DeleteBgpPeerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_bgp_peer_with_options_async(request, runtime)

    def delete_common_bandwidth_package_with_options(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCommonBandwidthPackageResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_common_bandwidth_package_with_options_async(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCommonBandwidthPackage',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCommonBandwidthPackageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_common_bandwidth_package(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_common_bandwidth_package_with_options(request, runtime)

    async def delete_common_bandwidth_package_async(
        self,
        request: vpc_20160428_models.DeleteCommonBandwidthPackageRequest,
    ) -> vpc_20160428_models.DeleteCommonBandwidthPackageResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_common_bandwidth_package_with_options_async(request, runtime)

    def delete_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_customer_gateway(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_customer_gateway_with_options(request, runtime)

    async def delete_customer_gateway_async(
        self,
        request: vpc_20160428_models.DeleteCustomerGatewayRequest,
    ) -> vpc_20160428_models.DeleteCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_customer_gateway_with_options_async(request, runtime)

    def delete_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dhcp_options_set(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_dhcp_options_set_with_options(request, runtime)

    async def delete_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.DeleteDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.DeleteDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_dhcp_options_set_with_options_async(request, runtime)

    def delete_flow_log_with_options(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFlowLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_flow_log_with_options_async(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFlowLog',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFlowLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_flow_log(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_flow_log_with_options(request, runtime)

    async def delete_flow_log_async(
        self,
        request: vpc_20160428_models.DeleteFlowLogRequest,
    ) -> vpc_20160428_models.DeleteFlowLogResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_flow_log_with_options_async(request, runtime)

    def delete_forward_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteForwardEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_forward_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteForwardEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteForwardEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_forward_entry(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_forward_entry_with_options(request, runtime)

    async def delete_forward_entry_async(
        self,
        request: vpc_20160428_models.DeleteForwardEntryRequest,
    ) -> vpc_20160428_models.DeleteForwardEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_forward_entry_with_options_async(request, runtime)

    def delete_full_nat_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_id):
            query['FullNatEntryId'] = request.full_nat_entry_id
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFullNatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_full_nat_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.full_nat_entry_id):
            query['FullNatEntryId'] = request.full_nat_entry_id
        if not UtilClient.is_unset(request.full_nat_table_id):
            query['FullNatTableId'] = request.full_nat_table_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFullNatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteFullNatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_full_nat_entry(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_full_nat_entry_with_options(request, runtime)

    async def delete_full_nat_entry_async(
        self,
        request: vpc_20160428_models.DeleteFullNatEntryRequest,
    ) -> vpc_20160428_models.DeleteFullNatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_full_nat_entry_with_options_async(request, runtime)

    def delete_global_acceleration_instance_with_options(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_global_acceleration_instance_with_options_async(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteGlobalAccelerationInstance',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_global_acceleration_instance(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_global_acceleration_instance_with_options(request, runtime)

    async def delete_global_acceleration_instance_async(
        self,
        request: vpc_20160428_models.DeleteGlobalAccelerationInstanceRequest,
    ) -> vpc_20160428_models.DeleteGlobalAccelerationInstanceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_global_acceleration_instance_with_options_async(request, runtime)

    def delete_ha_vip_with_options(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteHaVipResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ha_vip_with_options_async(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ha_vip_id):
            query['HaVipId'] = request.ha_vip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteHaVip',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteHaVipResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ha_vip(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ha_vip_with_options(request, runtime)

    async def delete_ha_vip_async(
        self,
        request: vpc_20160428_models.DeleteHaVipRequest,
    ) -> vpc_20160428_models.DeleteHaVipResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ha_vip_with_options_async(request, runtime)

    def delete_ipv_6translator_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6Translator',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_with_options(request, runtime)

    async def delete_ipv_6translator_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_with_options_async(request, runtime)

    def delete_ipv_6translator_acl_list_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorAclListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_acl_list_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorAclList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorAclListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator_acl_list(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_acl_list_with_options(request, runtime)

    async def delete_ipv_6translator_acl_list_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorAclListRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorAclListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_acl_list_with_options_async(request, runtime)

    def delete_ipv_6translator_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_entry_id):
            query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6translator_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6translator_entry_id):
            query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIPv6TranslatorEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIPv6TranslatorEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6translator_entry(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6translator_entry_with_options(request, runtime)

    async def delete_ipv_6translator_entry_async(
        self,
        request: vpc_20160428_models.DeleteIPv6TranslatorEntryRequest,
    ) -> vpc_20160428_models.DeleteIPv6TranslatorEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6translator_entry_with_options_async(request, runtime)

    def delete_ipsec_server_with_options(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipsec_server_id):
            query['IpsecServerId'] = request.ipsec_server_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpsecServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipsec_server_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipsec_server_id):
            query['IpsecServerId'] = request.ipsec_server_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpsecServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpsecServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipsec_server(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipsec_server_with_options(request, runtime)

    async def delete_ipsec_server_async(
        self,
        request: vpc_20160428_models.DeleteIpsecServerRequest,
    ) -> vpc_20160428_models.DeleteIpsecServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipsec_server_with_options_async(request, runtime)

    def delete_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_id):
            query['Ipv4GatewayId'] = request.ipv_4gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_id):
            query['Ipv4GatewayId'] = request.ipv_4gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_4gateway(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_4gateway_with_options(request, runtime)

    async def delete_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.DeleteIpv4GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_4gateway_with_options_async(request, runtime)

    def delete_ipv_6egress_only_rule_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6egress_only_rule_id):
            query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6egress_only_rule_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.ipv_6egress_only_rule_id):
            query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6EgressOnlyRule',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6egress_only_rule(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6egress_only_rule_with_options(request, runtime)

    async def delete_ipv_6egress_only_rule_async(
        self,
        request: vpc_20160428_models.DeleteIpv6EgressOnlyRuleRequest,
    ) -> vpc_20160428_models.DeleteIpv6EgressOnlyRuleResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6egress_only_rule_with_options_async(request, runtime)

    def delete_ipv_6gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6gateway(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6gateway_with_options(request, runtime)

    async def delete_ipv_6gateway_async(
        self,
        request: vpc_20160428_models.DeleteIpv6GatewayRequest,
    ) -> vpc_20160428_models.DeleteIpv6GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6gateway_with_options_async(request, runtime)

    def delete_ipv_6internet_bandwidth_with_options(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6internet_bandwidth_id):
            query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6InternetBandwidthResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ipv_6internet_bandwidth_with_options_async(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6internet_bandwidth_id):
            query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpv6InternetBandwidth',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteIpv6InternetBandwidthResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ipv_6internet_bandwidth(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ipv_6internet_bandwidth_with_options(request, runtime)

    async def delete_ipv_6internet_bandwidth_async(
        self,
        request: vpc_20160428_models.DeleteIpv6InternetBandwidthRequest,
    ) -> vpc_20160428_models.DeleteIpv6InternetBandwidthResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ipv_6internet_bandwidth_with_options_async(request, runtime)

    def delete_nat_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.force):
            query['Force'] = request.force
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_gateway(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_gateway_with_options(request, runtime)

    async def delete_nat_gateway_async(
        self,
        request: vpc_20160428_models.DeleteNatGatewayRequest,
    ) -> vpc_20160428_models.DeleteNatGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_gateway_with_options_async(request, runtime)

    def delete_nat_ip_with_options(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_ip_id):
            query['NatIpId'] = request.nat_ip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_ip_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_ip_id):
            query['NatIpId'] = request.nat_ip_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIp',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_ip(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_ip_with_options(request, runtime)

    async def delete_nat_ip_async(
        self,
        request: vpc_20160428_models.DeleteNatIpRequest,
    ) -> vpc_20160428_models.DeleteNatIpResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_ip_with_options_async(request, runtime)

    def delete_nat_ip_cidr_with_options(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpCidrResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_ip_cidr_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_ip_cidr):
            query['NatIpCidr'] = request.nat_ip_cidr
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatIpCidr',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNatIpCidrResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_ip_cidr(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_ip_cidr_with_options(request, runtime)

    async def delete_nat_ip_cidr_async(
        self,
        request: vpc_20160428_models.DeleteNatIpCidrRequest,
    ) -> vpc_20160428_models.DeleteNatIpCidrResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_ip_cidr_with_options_async(request, runtime)

    def delete_network_acl_with_options(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNetworkAclResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_network_acl_with_options_async(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNetworkAcl',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteNetworkAclResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_network_acl(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_network_acl_with_options(request, runtime)

    async def delete_network_acl_async(
        self,
        request: vpc_20160428_models.DeleteNetworkAclRequest,
    ) -> vpc_20160428_models.DeleteNetworkAclResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_network_acl_with_options_async(request, runtime)

    def delete_physical_connection_with_options(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_physical_connection(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_physical_connection_with_options(request, runtime)

    async def delete_physical_connection_async(
        self,
        request: vpc_20160428_models.DeletePhysicalConnectionRequest,
    ) -> vpc_20160428_models.DeletePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_physical_connection_with_options_async(request, runtime)

    def delete_public_ip_address_pool_with_options(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_public_ip_address_pool_with_options_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPool',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_public_ip_address_pool(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_public_ip_address_pool_with_options(request, runtime)

    async def delete_public_ip_address_pool_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_public_ip_address_pool_with_options_async(request, runtime)

    def delete_public_ip_address_pool_cidr_block_with_options(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_public_ip_address_pool_cidr_block_with_options_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cidr_block):
            query['CidrBlock'] = request.cidr_block
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePublicIpAddressPoolCidrBlock',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_public_ip_address_pool_cidr_block(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_public_ip_address_pool_cidr_block_with_options(request, runtime)

    async def delete_public_ip_address_pool_cidr_block_async(
        self,
        request: vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockRequest,
    ) -> vpc_20160428_models.DeletePublicIpAddressPoolCidrBlockResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_public_ip_address_pool_cidr_block_with_options_async(request, runtime)

    def delete_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_list):
            query['NextHopList'] = request.next_hop_list
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_entry(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_route_entry_with_options(request, runtime)

    async def delete_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_entry_with_options_async(request, runtime)

    def delete_route_table_with_options(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteTableResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_route_table_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouteTable',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouteTableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_route_table(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_route_table_with_options(request, runtime)

    async def delete_route_table_async(
        self,
        request: vpc_20160428_models.DeleteRouteTableRequest,
    ) -> vpc_20160428_models.DeleteRouteTableResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_route_table_with_options_async(request, runtime)

    def delete_router_interface_with_options(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouterInterfaceResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_router_interface_with_options_async(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_interface_id):
            query['RouterInterfaceId'] = request.router_interface_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteRouterInterface',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteRouterInterfaceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_router_interface(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_router_interface_with_options(request, runtime)

    async def delete_router_interface_async(
        self,
        request: vpc_20160428_models.DeleteRouterInterfaceRequest,
    ) -> vpc_20160428_models.DeleteRouterInterfaceResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_router_interface_with_options_async(request, runtime)

    def delete_snat_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSnatEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_snat_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSnatEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSnatEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_snat_entry(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_snat_entry_with_options(request, runtime)

    async def delete_snat_entry_async(
        self,
        request: vpc_20160428_models.DeleteSnatEntryRequest,
    ) -> vpc_20160428_models.DeleteSnatEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_snat_entry_with_options_async(request, runtime)

    def delete_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ssl_vpn_client_cert_with_options(request, runtime)

    async def delete_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DeleteSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ssl_vpn_client_cert_with_options_async(request, runtime)

    def delete_ssl_vpn_server_with_options(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnServerResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ssl_vpn_server_with_options_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSslVpnServer',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteSslVpnServerResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ssl_vpn_server(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_ssl_vpn_server_with_options(request, runtime)

    async def delete_ssl_vpn_server_async(
        self,
        request: vpc_20160428_models.DeleteSslVpnServerRequest,
    ) -> vpc_20160428_models.DeleteSslVpnServerResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_ssl_vpn_server_with_options_async(request, runtime)

    def delete_traffic_mirror_filter_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_filter_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_filter(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_filter_with_options(request, runtime)

    async def delete_traffic_mirror_filter_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_filter_with_options_async(request, runtime)

    def delete_traffic_mirror_filter_rules_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_rule_ids):
            query['TrafficMirrorFilterRuleIds'] = request.traffic_mirror_filter_rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_filter_rules_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_id):
            query['TrafficMirrorFilterId'] = request.traffic_mirror_filter_id
        if not UtilClient.is_unset(request.traffic_mirror_filter_rule_ids):
            query['TrafficMirrorFilterRuleIds'] = request.traffic_mirror_filter_rule_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorFilterRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_filter_rules(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_filter_rules_with_options(request, runtime)

    async def delete_traffic_mirror_filter_rules_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorFilterRulesRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorFilterRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_filter_rules_with_options_async(request, runtime)

    def delete_traffic_mirror_session_with_options(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorSessionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_traffic_mirror_session_with_options_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.traffic_mirror_session_id):
            query['TrafficMirrorSessionId'] = request.traffic_mirror_session_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrafficMirrorSession',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteTrafficMirrorSessionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_traffic_mirror_session(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_traffic_mirror_session_with_options(request, runtime)

    async def delete_traffic_mirror_session_async(
        self,
        request: vpc_20160428_models.DeleteTrafficMirrorSessionRequest,
    ) -> vpc_20160428_models.DeleteTrafficMirrorSessionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_traffic_mirror_session_with_options_async(request, runtime)

    def delete_vswitch_with_options(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vswitch_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVSwitch',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vswitch(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vswitch_with_options(request, runtime)

    async def delete_vswitch_async(
        self,
        request: vpc_20160428_models.DeleteVSwitchRequest,
    ) -> vpc_20160428_models.DeleteVSwitchResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vswitch_with_options_async(request, runtime)

    def delete_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vbr_ha(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vbr_ha_with_options(request, runtime)

    async def delete_vbr_ha_async(
        self,
        request: vpc_20160428_models.DeleteVbrHaRequest,
    ) -> vpc_20160428_models.DeleteVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vbr_ha_with_options_async(request, runtime)

    def delete_vco_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVcoRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vco_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVcoRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVcoRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vco_route_entry(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vco_route_entry_with_options(request, runtime)

    async def delete_vco_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteVcoRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVcoRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vco_route_entry_with_options_async(request, runtime)

    def delete_virtual_border_router_with_options(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVirtualBorderRouterResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_virtual_border_router_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVirtualBorderRouter',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVirtualBorderRouterResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_virtual_border_router(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_virtual_border_router_with_options(request, runtime)

    async def delete_virtual_border_router_async(
        self,
        request: vpc_20160428_models.DeleteVirtualBorderRouterRequest,
    ) -> vpc_20160428_models.DeleteVirtualBorderRouterResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_virtual_border_router_with_options_async(request, runtime)

    def delete_vpc_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_with_options(request, runtime)

    async def delete_vpc_async(
        self,
        request: vpc_20160428_models.DeleteVpcRequest,
    ) -> vpc_20160428_models.DeleteVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_with_options_async(request, runtime)

    def delete_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_gateway_endpoint_with_options(request, runtime)

    async def delete_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.DeleteVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DeleteVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_gateway_endpoint_with_options_async(request, runtime)

    def delete_vpc_prefix_list_with_options(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcPrefixListResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_prefix_list_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.prefix_list_id):
            query['PrefixListId'] = request.prefix_list_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcPrefixList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpcPrefixListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_prefix_list(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_prefix_list_with_options(request, runtime)

    async def delete_vpc_prefix_list_async(
        self,
        request: vpc_20160428_models.DeleteVpcPrefixListRequest,
    ) -> vpc_20160428_models.DeleteVpcPrefixListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_prefix_list_with_options_async(request, runtime)

    def delete_vpn_attachment_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnAttachmentResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_attachment_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnAttachment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnAttachmentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_attachment(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_attachment_with_options(request, runtime)

    async def delete_vpn_attachment_async(
        self,
        request: vpc_20160428_models.DeleteVpnAttachmentRequest,
    ) -> vpc_20160428_models.DeleteVpnAttachmentResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_attachment_with_options_async(request, runtime)

    def delete_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_connection(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_connection_with_options(request, runtime)

    async def delete_vpn_connection_async(
        self,
        request: vpc_20160428_models.DeleteVpnConnectionRequest,
    ) -> vpc_20160428_models.DeleteVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_connection_with_options_async(request, runtime)

    def delete_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_gateway(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_gateway_with_options(request, runtime)

    async def delete_vpn_gateway_async(
        self,
        request: vpc_20160428_models.DeleteVpnGatewayRequest,
    ) -> vpc_20160428_models.DeleteVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_gateway_with_options_async(request, runtime)

    def delete_vpn_pbr_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.route_source):
            query['RouteSource'] = request.route_source
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnPbrRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_pbr_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.route_source):
            query['RouteSource'] = request.route_source
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnPbrRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnPbrRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_pbr_route_entry(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_pbr_route_entry_with_options(request, runtime)

    async def delete_vpn_pbr_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteVpnPbrRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnPbrRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_pbr_route_entry_with_options_async(request, runtime)

    def delete_vpn_route_entry_with_options(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnRouteEntryResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpn_route_entry_with_options_async(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.next_hop):
            query['NextHop'] = request.next_hop
        if not UtilClient.is_unset(request.overlay_mode):
            query['OverlayMode'] = request.overlay_mode
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_dest):
            query['RouteDest'] = request.route_dest
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        if not UtilClient.is_unset(request.weight):
            query['Weight'] = request.weight
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpnRouteEntry',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeleteVpnRouteEntryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpn_route_entry(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return self.delete_vpn_route_entry_with_options(request, runtime)

    async def delete_vpn_route_entry_async(
        self,
        request: vpc_20160428_models.DeleteVpnRouteEntryRequest,
    ) -> vpc_20160428_models.DeleteVpnRouteEntryResponse:
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpn_route_entry_with_options_async(request, runtime)

    def deletion_protection_with_options(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.protection_enable):
            query['ProtectionEnable'] = request.protection_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletionProtection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletionProtectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def deletion_protection_with_options_async(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.protection_enable):
            query['ProtectionEnable'] = request.protection_enable
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletionProtection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DeletionProtectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def deletion_protection(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.deletion_protection_with_options(request, runtime)

    async def deletion_protection_async(
        self,
        request: vpc_20160428_models.DeletionProtectionRequest,
    ) -> vpc_20160428_models.DeletionProtectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.deletion_protection_with_options_async(request, runtime)

    def describe_access_points_with_options(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeAccessPointsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_points_with_options_async(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessPoints',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeAccessPointsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_points(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_access_points_with_options(request, runtime)

    async def describe_access_points_async(
        self,
        request: vpc_20160428_models.DescribeAccessPointsRequest,
    ) -> vpc_20160428_models.DescribeAccessPointsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_points_with_options_async(request, runtime)

    def describe_bgp_groups_with_options(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBgpGroups',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpGroupsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bgp_groups_with_options_async(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBgpGroups',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpGroupsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bgp_groups(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bgp_groups_with_options(request, runtime)

    async def describe_bgp_groups_async(
        self,
        request: vpc_20160428_models.DescribeBgpGroupsRequest,
    ) -> vpc_20160428_models.DescribeBgpGroupsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bgp_groups_with_options_async(request, runtime)

    def describe_bgp_networks_with_options(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBgpNetworks',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpNetworksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bgp_networks_with_options_async(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBgpNetworks',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpNetworksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bgp_networks(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bgp_networks_with_options(request, runtime)

    async def describe_bgp_networks_async(
        self,
        request: vpc_20160428_models.DescribeBgpNetworksRequest,
    ) -> vpc_20160428_models.DescribeBgpNetworksResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bgp_networks_with_options_async(request, runtime)

    def describe_bgp_peers_with_options(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.bgp_peer_id):
            query['BgpPeerId'] = request.bgp_peer_id
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBgpPeers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpPeersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_bgp_peers_with_options_async(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bgp_group_id):
            query['BgpGroupId'] = request.bgp_group_id
        if not UtilClient.is_unset(request.bgp_peer_id):
            query['BgpPeerId'] = request.bgp_peer_id
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBgpPeers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeBgpPeersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_bgp_peers(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_bgp_peers_with_options(request, runtime)

    async def describe_bgp_peers_async(
        self,
        request: vpc_20160428_models.DescribeBgpPeersRequest,
    ) -> vpc_20160428_models.DescribeBgpPeersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_bgp_peers_with_options_async(request, runtime)

    def describe_common_bandwidth_packages_with_options(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonBandwidthPackages',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCommonBandwidthPackagesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_common_bandwidth_packages_with_options_async(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_package_id):
            query['BandwidthPackageId'] = request.bandwidth_package_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCommonBandwidthPackages',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCommonBandwidthPackagesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_common_bandwidth_packages(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_common_bandwidth_packages_with_options(request, runtime)

    async def describe_common_bandwidth_packages_async(
        self,
        request: vpc_20160428_models.DescribeCommonBandwidthPackagesRequest,
    ) -> vpc_20160428_models.DescribeCommonBandwidthPackagesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_common_bandwidth_packages_with_options_async(request, runtime)

    def describe_customer_gateway_with_options(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_customer_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_customer_gateway(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_customer_gateway_with_options(request, runtime)

    async def describe_customer_gateway_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewayRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_customer_gateway_with_options_async(request, runtime)

    def describe_customer_gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_customer_gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCustomerGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeCustomerGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_customer_gateways(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_customer_gateways_with_options(request, runtime)

    async def describe_customer_gateways_async(
        self,
        request: vpc_20160428_models.DescribeCustomerGatewaysRequest,
    ) -> vpc_20160428_models.DescribeCustomerGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_customer_gateways_with_options_async(request, runtime)

    def describe_eip_addresses_with_options(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.associated_instance_id):
            query['AssociatedInstanceId'] = request.associated_instance_id
        if not UtilClient.is_unset(request.associated_instance_type):
            query['AssociatedInstanceType'] = request.associated_instance_type
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.eip_address):
            query['EipAddress'] = request.eip_address
        if not UtilClient.is_unset(request.eip_name):
            query['EipName'] = request.eip_name
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.lock_reason):
            query['LockReason'] = request.lock_reason
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        if not UtilClient.is_unset(request.segment_instance_id):
            query['SegmentInstanceId'] = request.segment_instance_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipAddresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipAddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_addresses_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.associated_instance_id):
            query['AssociatedInstanceId'] = request.associated_instance_id
        if not UtilClient.is_unset(request.associated_instance_type):
            query['AssociatedInstanceType'] = request.associated_instance_type
        if not UtilClient.is_unset(request.charge_type):
            query['ChargeType'] = request.charge_type
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.eip_address):
            query['EipAddress'] = request.eip_address
        if not UtilClient.is_unset(request.eip_name):
            query['EipName'] = request.eip_name
        if not UtilClient.is_unset(request.isp):
            query['ISP'] = request.isp
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.lock_reason):
            query['LockReason'] = request.lock_reason
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.public_ip_address_pool_id):
            query['PublicIpAddressPoolId'] = request.public_ip_address_pool_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.security_protection_enabled):
            query['SecurityProtectionEnabled'] = request.security_protection_enabled
        if not UtilClient.is_unset(request.segment_instance_id):
            query['SegmentInstanceId'] = request.segment_instance_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipAddresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipAddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_addresses(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_addresses_with_options(request, runtime)

    async def describe_eip_addresses_async(
        self,
        request: vpc_20160428_models.DescribeEipAddressesRequest,
    ) -> vpc_20160428_models.DescribeEipAddressesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_addresses_with_options_async(request, runtime)

    def describe_eip_gateway_info_with_options(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipGatewayInfo',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipGatewayInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_gateway_info_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipGatewayInfo',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipGatewayInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_gateway_info(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_gateway_info_with_options(request, runtime)

    async def describe_eip_gateway_info_async(
        self,
        request: vpc_20160428_models.DescribeEipGatewayInfoRequest,
    ) -> vpc_20160428_models.DescribeEipGatewayInfoResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_gateway_info_with_options_async(request, runtime)

    def describe_eip_monitor_data_with_options(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipMonitorData',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipMonitorDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_monitor_data_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocation_id):
            query['AllocationId'] = request.allocation_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.period):
            query['Period'] = request.period
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipMonitorData',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipMonitorDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_monitor_data(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_monitor_data_with_options(request, runtime)

    async def describe_eip_monitor_data_async(
        self,
        request: vpc_20160428_models.DescribeEipMonitorDataRequest,
    ) -> vpc_20160428_models.DescribeEipMonitorDataResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_monitor_data_with_options_async(request, runtime)

    def describe_eip_segment_with_options(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.segment_instance_id):
            query['SegmentInstanceId'] = request.segment_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipSegment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipSegmentResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_eip_segment_with_options_async(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.segment_instance_id):
            query['SegmentInstanceId'] = request.segment_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeEipSegment',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeEipSegmentResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_eip_segment(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_eip_segment_with_options(request, runtime)

    async def describe_eip_segment_async(
        self,
        request: vpc_20160428_models.DescribeEipSegmentRequest,
    ) -> vpc_20160428_models.DescribeEipSegmentResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_eip_segment_with_options_async(request, runtime)

    def describe_flow_logs_with_options(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.flow_log_name):
            query['FlowLogName'] = request.flow_log_name
        if not UtilClient.is_unset(request.log_store_name):
            query['LogStoreName'] = request.log_store_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFlowLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeFlowLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_flow_logs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.flow_log_id):
            query['FlowLogId'] = request.flow_log_id
        if not UtilClient.is_unset(request.flow_log_name):
            query['FlowLogName'] = request.flow_log_name
        if not UtilClient.is_unset(request.log_store_name):
            query['LogStoreName'] = request.log_store_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.project_name):
            query['ProjectName'] = request.project_name
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFlowLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeFlowLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_flow_logs(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_flow_logs_with_options(request, runtime)

    async def describe_flow_logs_async(
        self,
        request: vpc_20160428_models.DescribeFlowLogsRequest,
    ) -> vpc_20160428_models.DescribeFlowLogsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_flow_logs_with_options_async(request, runtime)

    def describe_forward_table_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeForwardTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeForwardTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_forward_table_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.external_ip):
            query['ExternalIp'] = request.external_ip
        if not UtilClient.is_unset(request.external_port):
            query['ExternalPort'] = request.external_port
        if not UtilClient.is_unset(request.forward_entry_id):
            query['ForwardEntryId'] = request.forward_entry_id
        if not UtilClient.is_unset(request.forward_entry_name):
            query['ForwardEntryName'] = request.forward_entry_name
        if not UtilClient.is_unset(request.forward_table_id):
            query['ForwardTableId'] = request.forward_table_id
        if not UtilClient.is_unset(request.internal_ip):
            query['InternalIp'] = request.internal_ip
        if not UtilClient.is_unset(request.internal_port):
            query['InternalPort'] = request.internal_port
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeForwardTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeForwardTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_forward_table_entries(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_forward_table_entries_with_options(request, runtime)

    async def describe_forward_table_entries_async(
        self,
        request: vpc_20160428_models.DescribeForwardTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeForwardTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_forward_table_entries_with_options_async(request, runtime)

    def describe_global_acceleration_instances_with_options(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_type):
            query['BandwidthType'] = request.bandwidth_type
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.server_id):
            query['ServerId'] = request.server_id
        if not UtilClient.is_unset(request.service_location):
            query['ServiceLocation'] = request.service_location
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_global_acceleration_instances_with_options_async(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.bandwidth_type):
            query['BandwidthType'] = request.bandwidth_type
        if not UtilClient.is_unset(request.global_acceleration_instance_id):
            query['GlobalAccelerationInstanceId'] = request.global_acceleration_instance_id
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.ip_address):
            query['IpAddress'] = request.ip_address
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.server_id):
            query['ServerId'] = request.server_id
        if not UtilClient.is_unset(request.service_location):
            query['ServiceLocation'] = request.service_location
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_global_acceleration_instances(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_global_acceleration_instances_with_options(request, runtime)

    async def describe_global_acceleration_instances_async(
        self,
        request: vpc_20160428_models.DescribeGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_global_acceleration_instances_with_options_async(request, runtime)

    def describe_grant_rules_to_cen_with_options(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGrantRulesToCen',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGrantRulesToCenResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_grant_rules_to_cen_with_options_async(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeGrantRulesToCen',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeGrantRulesToCenResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_grant_rules_to_cen(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_grant_rules_to_cen_with_options(request, runtime)

    async def describe_grant_rules_to_cen_async(
        self,
        request: vpc_20160428_models.DescribeGrantRulesToCenRequest,
    ) -> vpc_20160428_models.DescribeGrantRulesToCenResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_grant_rules_to_cen_with_options_async(request, runtime)

    def describe_ha_vips_with_options(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHaVips',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHaVipsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ha_vips_with_options_async(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHaVips',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHaVipsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ha_vips(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ha_vips_with_options(request, runtime)

    async def describe_ha_vips_async(
        self,
        request: vpc_20160428_models.DescribeHaVipsRequest,
    ) -> vpc_20160428_models.DescribeHaVipsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ha_vips_with_options_async(request, runtime)

    def describe_high_definition_monitor_log_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHighDefinitionMonitorLogAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_high_definition_monitor_log_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeHighDefinitionMonitorLogAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_high_definition_monitor_log_attribute(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_high_definition_monitor_log_attribute_with_options(request, runtime)

    async def describe_high_definition_monitor_log_attribute_async(
        self,
        request: vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeRequest,
    ) -> vpc_20160428_models.DescribeHighDefinitionMonitorLogAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_high_definition_monitor_log_attribute_with_options_async(request, runtime)

    def describe_ipv_6translator_acl_list_attributes_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclListAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translator_acl_list_attributes_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclListAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translator_acl_list_attributes(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translator_acl_list_attributes_with_options(request, runtime)

    async def describe_ipv_6translator_acl_list_attributes_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translator_acl_list_attributes_with_options_async(request, runtime)

    def describe_ipv_6translator_acl_lists_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_name):
            query['AclName'] = request.acl_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclLists',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translator_acl_lists_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_name):
            query['AclName'] = request.acl_name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorAclLists',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translator_acl_lists(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translator_acl_lists_with_options(request, runtime)

    async def describe_ipv_6translator_acl_lists_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorAclListsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorAclListsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translator_acl_lists_with_options_async(request, runtime)

    def describe_ipv_6translator_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_status):
            query['AclStatus'] = request.acl_status
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.allocate_ipv_6addr):
            query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        if not UtilClient.is_unset(request.allocate_ipv_6port):
            query['AllocateIpv6Port'] = request.allocate_ipv_6port
        if not UtilClient.is_unset(request.backend_ipv_4addr):
            query['BackendIpv4Addr'] = request.backend_ipv_4addr
        if not UtilClient.is_unset(request.backend_ipv_4port):
            query['BackendIpv4Port'] = request.backend_ipv_4port
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.entry_name):
            query['EntryName'] = request.entry_name
        if not UtilClient.is_unset(request.ipv_6translator_entry_id):
            query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trans_protocol):
            query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translator_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_id):
            query['AclId'] = request.acl_id
        if not UtilClient.is_unset(request.acl_status):
            query['AclStatus'] = request.acl_status
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.allocate_ipv_6addr):
            query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        if not UtilClient.is_unset(request.allocate_ipv_6port):
            query['AllocateIpv6Port'] = request.allocate_ipv_6port
        if not UtilClient.is_unset(request.backend_ipv_4addr):
            query['BackendIpv4Addr'] = request.backend_ipv_4addr
        if not UtilClient.is_unset(request.backend_ipv_4port):
            query['BackendIpv4Port'] = request.backend_ipv_4port
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.entry_name):
            query['EntryName'] = request.entry_name
        if not UtilClient.is_unset(request.ipv_6translator_entry_id):
            query['Ipv6TranslatorEntryId'] = request.ipv_6translator_entry_id
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.trans_protocol):
            query['TransProtocol'] = request.trans_protocol
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6TranslatorEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translator_entries(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translator_entries_with_options(request, runtime)

    async def describe_ipv_6translator_entries_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorEntriesRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translator_entries_with_options_async(request, runtime)

    def describe_ipv_6translators_with_options(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocate_ipv_4addr):
            query['AllocateIpv4Addr'] = request.allocate_ipv_4addr
        if not UtilClient.is_unset(request.allocate_ipv_6addr):
            query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        if not UtilClient.is_unset(request.business_status):
            query['BusinessStatus'] = request.business_status
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6Translators',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6translators_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.allocate_ipv_4addr):
            query['AllocateIpv4Addr'] = request.allocate_ipv_4addr
        if not UtilClient.is_unset(request.allocate_ipv_6addr):
            query['AllocateIpv6Addr'] = request.allocate_ipv_6addr
        if not UtilClient.is_unset(request.business_status):
            query['BusinessStatus'] = request.business_status
        if not UtilClient.is_unset(request.ipv_6translator_id):
            query['Ipv6TranslatorId'] = request.ipv_6translator_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.pay_type):
            query['PayType'] = request.pay_type
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIPv6Translators',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIPv6TranslatorsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6translators(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6translators_with_options(request, runtime)

    async def describe_ipv_6translators_async(
        self,
        request: vpc_20160428_models.DescribeIPv6TranslatorsRequest,
    ) -> vpc_20160428_models.DescribeIPv6TranslatorsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6translators_with_options_async(request, runtime)

    def describe_ipv_6addresses_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associated_instance_id):
            query['AssociatedInstanceId'] = request.associated_instance_id
        if not UtilClient.is_unset(request.associated_instance_type):
            query['AssociatedInstanceType'] = request.associated_instance_type
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6internet_bandwidth_id):
            query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Addresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6AddressesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6addresses_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.associated_instance_id):
            query['AssociatedInstanceId'] = request.associated_instance_id
        if not UtilClient.is_unset(request.associated_instance_type):
            query['AssociatedInstanceType'] = request.associated_instance_type
        if not UtilClient.is_unset(request.ipv_6address):
            query['Ipv6Address'] = request.ipv_6address
        if not UtilClient.is_unset(request.ipv_6address_id):
            query['Ipv6AddressId'] = request.ipv_6address_id
        if not UtilClient.is_unset(request.ipv_6internet_bandwidth_id):
            query['Ipv6InternetBandwidthId'] = request.ipv_6internet_bandwidth_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Addresses',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6AddressesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6addresses(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6addresses_with_options(request, runtime)

    async def describe_ipv_6addresses_async(
        self,
        request: vpc_20160428_models.DescribeIpv6AddressesRequest,
    ) -> vpc_20160428_models.DescribeIpv6AddressesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6addresses_with_options_async(request, runtime)

    def describe_ipv_6egress_only_rules_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_6egress_only_rule_id):
            query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6EgressOnlyRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6egress_only_rules_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.ipv_6egress_only_rule_id):
            query['Ipv6EgressOnlyRuleId'] = request.ipv_6egress_only_rule_id
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6EgressOnlyRules',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6egress_only_rules(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6egress_only_rules_with_options(request, runtime)

    async def describe_ipv_6egress_only_rules_async(
        self,
        request: vpc_20160428_models.DescribeIpv6EgressOnlyRulesRequest,
    ) -> vpc_20160428_models.DescribeIpv6EgressOnlyRulesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6egress_only_rules_with_options_async(request, runtime)

    def describe_ipv_6gateway_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewayAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6gateway_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6GatewayAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewayAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6gateway_attribute(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6gateway_attribute_with_options(request, runtime)

    async def describe_ipv_6gateway_attribute_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewayAttributeRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewayAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6gateway_attribute_with_options_async(request, runtime)

    def describe_ipv_6gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Gateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ipv_6gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ipv_6gateway_id):
            query['Ipv6GatewayId'] = request.ipv_6gateway_id
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpv6Gateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeIpv6GatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ipv_6gateways(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ipv_6gateways_with_options(request, runtime)

    async def describe_ipv_6gateways_async(
        self,
        request: vpc_20160428_models.DescribeIpv6GatewaysRequest,
    ) -> vpc_20160428_models.DescribeIpv6GatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ipv_6gateways_with_options_async(request, runtime)

    def describe_nat_gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_type):
            query['NatType'] = request.nat_type
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNatGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.instance_charge_type):
            query['InstanceChargeType'] = request.instance_charge_type
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_type):
            query['NatType'] = request.nat_type
        if not UtilClient.is_unset(request.network_type):
            query['NetworkType'] = request.network_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.spec):
            query['Spec'] = request.spec
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNatGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_gateways(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_gateways_with_options(request, runtime)

    async def describe_nat_gateways_async(
        self,
        request: vpc_20160428_models.DescribeNatGatewaysRequest,
    ) -> vpc_20160428_models.DescribeNatGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_gateways_with_options_async(request, runtime)

    def describe_network_acl_attributes_with_options(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAclAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_acl_attributes_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAclAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_acl_attributes(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_network_acl_attributes_with_options(request, runtime)

    async def describe_network_acl_attributes_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclAttributesRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_acl_attributes_with_options_async(request, runtime)

    def describe_network_acls_with_options(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAcls',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_acls_with_options_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.network_acl_id):
            query['NetworkAclId'] = request.network_acl_id
        if not UtilClient.is_unset(request.network_acl_name):
            query['NetworkAclName'] = request.network_acl_name
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkAcls',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeNetworkAclsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_acls(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_network_acls_with_options(request, runtime)

    async def describe_network_acls_async(
        self,
        request: vpc_20160428_models.DescribeNetworkAclsRequest,
    ) -> vpc_20160428_models.DescribeNetworkAclsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_acls_with_options_async(request, runtime)

    def describe_physical_connection_loawith_options(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionLOAResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_physical_connection_loawith_options_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnectionLOA',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionLOAResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_physical_connection_loa(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_physical_connection_loawith_options(request, runtime)

    async def describe_physical_connection_loa_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionLOARequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionLOAResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_physical_connection_loawith_options_async(request, runtime)

    def describe_physical_connections_with_options(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_physical_connections_with_options_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.tags):
            query['Tags'] = request.tags
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePhysicalConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePhysicalConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_physical_connections(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_physical_connections_with_options(request, runtime)

    async def describe_physical_connections_async(
        self,
        request: vpc_20160428_models.DescribePhysicalConnectionsRequest,
    ) -> vpc_20160428_models.DescribePhysicalConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_physical_connections_with_options_async(request, runtime)

    def describe_public_ip_address_with_options(
        self,
        request: vpc_20160428_models.DescribePublicIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePublicIpAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePublicIpAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePublicIpAddressResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_public_ip_address_with_options_async(
        self,
        request: vpc_20160428_models.DescribePublicIpAddressRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribePublicIpAddressResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePublicIpAddress',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribePublicIpAddressResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_public_ip_address(
        self,
        request: vpc_20160428_models.DescribePublicIpAddressRequest,
    ) -> vpc_20160428_models.DescribePublicIpAddressResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_public_ip_address_with_options(request, runtime)

    async def describe_public_ip_address_async(
        self,
        request: vpc_20160428_models.DescribePublicIpAddressRequest,
    ) -> vpc_20160428_models.DescribePublicIpAddressResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_public_ip_address_with_options_async(request, runtime)

    def describe_regions_with_options(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRegionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_regions_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegions',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRegionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_regions(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_regions_with_options(request, runtime)

    async def describe_regions_async(
        self,
        request: vpc_20160428_models.DescribeRegionsRequest,
    ) -> vpc_20160428_models.DescribeRegionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_regions_with_options_async(request, runtime)

    def describe_route_entry_list_with_options(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.max_result):
            query['MaxResult'] = request.max_result
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouteEntryList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteEntryListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_route_entry_list_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.destination_cidr_block):
            query['DestinationCidrBlock'] = request.destination_cidr_block
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.max_result):
            query['MaxResult'] = request.max_result
        if not UtilClient.is_unset(request.next_hop_id):
            query['NextHopId'] = request.next_hop_id
        if not UtilClient.is_unset(request.next_hop_type):
            query['NextHopType'] = request.next_hop_type
        if not UtilClient.is_unset(request.next_token):
            query['NextToken'] = request.next_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_id):
            query['RouteEntryId'] = request.route_entry_id
        if not UtilClient.is_unset(request.route_entry_name):
            query['RouteEntryName'] = request.route_entry_name
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouteEntryList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteEntryListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_route_entry_list(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_route_entry_list_with_options(request, runtime)

    async def describe_route_entry_list_async(
        self,
        request: vpc_20160428_models.DescribeRouteEntryListRequest,
    ) -> vpc_20160428_models.DescribeRouteEntryListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_route_entry_list_with_options_async(request, runtime)

    def describe_route_table_list_with_options(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouteTableList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTableListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_route_table_list_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouteTableList',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTableListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_route_table_list(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_route_table_list_with_options(request, runtime)

    async def describe_route_table_list_async(
        self,
        request: vpc_20160428_models.DescribeRouteTableListRequest,
    ) -> vpc_20160428_models.DescribeRouteTableListResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_route_table_list_with_options_async(request, runtime)

    def describe_route_tables_with_options(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vrouter_id):
            query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouteTables',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTablesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_route_tables_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.route_table_name):
            query['RouteTableName'] = request.route_table_name
        if not UtilClient.is_unset(request.router_id):
            query['RouterId'] = request.router_id
        if not UtilClient.is_unset(request.router_type):
            query['RouterType'] = request.router_type
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.vrouter_id):
            query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouteTables',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouteTablesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_route_tables(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_route_tables_with_options(request, runtime)

    async def describe_route_tables_async(
        self,
        request: vpc_20160428_models.DescribeRouteTablesRequest,
    ) -> vpc_20160428_models.DescribeRouteTablesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_route_tables_with_options_async(request, runtime)

    def describe_router_interface_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaceAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfaceAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_router_interface_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaceAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfaceAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_router_interface_attribute(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_router_interface_attribute_with_options(request, runtime)

    async def describe_router_interface_attribute_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfaceAttributeRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfaceAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_router_interface_attribute_with_options_async(request, runtime)

    def describe_router_interfaces_with_options(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaces',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_router_interfaces_with_options_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRouterInterfaces',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeRouterInterfacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_router_interfaces(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_router_interfaces_with_options(request, runtime)

    async def describe_router_interfaces_async(
        self,
        request: vpc_20160428_models.DescribeRouterInterfacesRequest,
    ) -> vpc_20160428_models.DescribeRouterInterfacesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_router_interfaces_with_options_async(request, runtime)

    def describe_server_related_global_acceleration_instances_with_options(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.server_id):
            query['ServerId'] = request.server_id
        if not UtilClient.is_unset(request.server_type):
            query['ServerType'] = request.server_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServerRelatedGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_server_related_global_acceleration_instances_with_options_async(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.server_id):
            query['ServerId'] = request.server_id
        if not UtilClient.is_unset(request.server_type):
            query['ServerType'] = request.server_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeServerRelatedGlobalAccelerationInstances',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_server_related_global_acceleration_instances(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_server_related_global_acceleration_instances_with_options(request, runtime)

    async def describe_server_related_global_acceleration_instances_async(
        self,
        request: vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesRequest,
    ) -> vpc_20160428_models.DescribeServerRelatedGlobalAccelerationInstancesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_server_related_global_acceleration_instances_with_options_async(request, runtime)

    def describe_snat_table_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnatTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSnatTableEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_snat_table_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.snat_entry_id):
            query['SnatEntryId'] = request.snat_entry_id
        if not UtilClient.is_unset(request.snat_entry_name):
            query['SnatEntryName'] = request.snat_entry_name
        if not UtilClient.is_unset(request.snat_ip):
            query['SnatIp'] = request.snat_ip
        if not UtilClient.is_unset(request.snat_table_id):
            query['SnatTableId'] = request.snat_table_id
        if not UtilClient.is_unset(request.source_cidr):
            query['SourceCIDR'] = request.source_cidr
        if not UtilClient.is_unset(request.source_vswitch_id):
            query['SourceVSwitchId'] = request.source_vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSnatTableEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSnatTableEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_snat_table_entries(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_snat_table_entries_with_options(request, runtime)

    async def describe_snat_table_entries_async(
        self,
        request: vpc_20160428_models.DescribeSnatTableEntriesRequest,
    ) -> vpc_20160428_models.DescribeSnatTableEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_snat_table_entries_with_options_async(request, runtime)

    def describe_ssl_vpn_client_cert_with_options(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ssl_vpn_client_cert_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCert',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ssl_vpn_client_cert(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ssl_vpn_client_cert_with_options(request, runtime)

    async def describe_ssl_vpn_client_cert_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ssl_vpn_client_cert_with_options_async(request, runtime)

    def describe_ssl_vpn_client_certs_with_options(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCerts',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ssl_vpn_client_certs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnClientCerts',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnClientCertsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ssl_vpn_client_certs(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ssl_vpn_client_certs_with_options(request, runtime)

    async def describe_ssl_vpn_client_certs_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnClientCertsRequest,
    ) -> vpc_20160428_models.DescribeSslVpnClientCertsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ssl_vpn_client_certs_with_options_async(request, runtime)

    def describe_ssl_vpn_servers_with_options(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnServers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnServersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ssl_vpn_servers_with_options_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.name):
            query['Name'] = request.name
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_server_id):
            query['SslVpnServerId'] = request.ssl_vpn_server_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSslVpnServers',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeSslVpnServersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ssl_vpn_servers(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_ssl_vpn_servers_with_options(request, runtime)

    async def describe_ssl_vpn_servers_async(
        self,
        request: vpc_20160428_models.DescribeSslVpnServersRequest,
    ) -> vpc_20160428_models.DescribeSslVpnServersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_ssl_vpn_servers_with_options_async(request, runtime)

    def describe_vrouters_with_options(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vrouter_id):
            query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVRoutersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vrouters_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vrouter_id):
            query['VRouterId'] = request.vrouter_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVRoutersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vrouters(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vrouters_with_options(request, runtime)

    async def describe_vrouters_async(
        self,
        request: vpc_20160428_models.DescribeVRoutersRequest,
    ) -> vpc_20160428_models.DescribeVRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vrouters_with_options_async(request, runtime)

    def describe_vswitch_attributes_with_options(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchAttributesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitch_attributes_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitchAttributes',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchAttributesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitch_attributes(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitch_attributes_with_options(request, runtime)

    async def describe_vswitch_attributes_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchAttributesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchAttributesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitch_attributes_with_options_async(request, runtime)

    def describe_vswitches_with_options(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.v_switch_owner_id):
            query['VSwitchOwnerId'] = request.v_switch_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vswitches_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.v_switch_name):
            query['VSwitchName'] = request.v_switch_name
        if not UtilClient.is_unset(request.v_switch_owner_id):
            query['VSwitchOwnerId'] = request.v_switch_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.zone_id):
            query['ZoneId'] = request.zone_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVSwitches',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVSwitchesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vswitches(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vswitches_with_options(request, runtime)

    async def describe_vswitches_async(
        self,
        request: vpc_20160428_models.DescribeVSwitchesRequest,
    ) -> vpc_20160428_models.DescribeVSwitchesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vswitches_with_options_async(request, runtime)

    def describe_vbr_ha_with_options(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_ha_id):
            query['VbrHaId'] = request.vbr_ha_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVbrHaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vbr_ha_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vbr_ha_id):
            query['VbrHaId'] = request.vbr_ha_id
        if not UtilClient.is_unset(request.vbr_id):
            query['VbrId'] = request.vbr_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVbrHa',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVbrHaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vbr_ha(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vbr_ha_with_options(request, runtime)

    async def describe_vbr_ha_async(
        self,
        request: vpc_20160428_models.DescribeVbrHaRequest,
    ) -> vpc_20160428_models.DescribeVbrHaResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vbr_ha_with_options_async(request, runtime)

    def describe_vco_route_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeVcoRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVcoRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVcoRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVcoRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vco_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVcoRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVcoRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVcoRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVcoRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vco_route_entries(
        self,
        request: vpc_20160428_models.DescribeVcoRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVcoRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vco_route_entries_with_options(request, runtime)

    async def describe_vco_route_entries_async(
        self,
        request: vpc_20160428_models.DescribeVcoRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVcoRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vco_route_entries_with_options_async(request, runtime)

    def describe_virtual_border_routers_with_options(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_virtual_border_routers_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRouters',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_virtual_border_routers(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_virtual_border_routers_with_options(request, runtime)

    async def describe_virtual_border_routers_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_virtual_border_routers_with_options_async(request, runtime)

    def describe_virtual_border_routers_for_physical_connection_with_options(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRoutersForPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_virtual_border_routers_for_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.filter):
            query['Filter'] = request.filter
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVirtualBorderRoutersForPhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_virtual_border_routers_for_physical_connection(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_virtual_border_routers_for_physical_connection_with_options(request, runtime)

    async def describe_virtual_border_routers_for_physical_connection_async(
        self,
        request: vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionRequest,
    ) -> vpc_20160428_models.DescribeVirtualBorderRoutersForPhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_virtual_border_routers_for_physical_connection_with_options_async(request, runtime)

    def describe_vpc_attribute_with_options(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcAttributeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_attribute_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcAttribute',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcAttributeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_attribute(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_attribute_with_options(request, runtime)

    async def describe_vpc_attribute_async(
        self,
        request: vpc_20160428_models.DescribeVpcAttributeRequest,
    ) -> vpc_20160428_models.DescribeVpcAttributeResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_attribute_with_options_async(request, runtime)

    def describe_vpcs_with_options(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        if not UtilClient.is_unset(request.vpc_owner_id):
            query['VpcOwnerId'] = request.vpc_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpcs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.is_default):
            query['IsDefault'] = request.is_default
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_group_id):
            query['ResourceGroupId'] = request.resource_group_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpc_name):
            query['VpcName'] = request.vpc_name
        if not UtilClient.is_unset(request.vpc_owner_id):
            query['VpcOwnerId'] = request.vpc_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpcsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpcs(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpcs_with_options(request, runtime)

    async def describe_vpcs_async(
        self,
        request: vpc_20160428_models.DescribeVpcsRequest,
    ) -> vpc_20160428_models.DescribeVpcsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpcs_with_options_async(request, runtime)

    def describe_vpn_attachments_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnAttachmentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnAttachmentsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attach_type):
            query['AttachType'] = request.attach_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnAttachments',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnAttachmentsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_attachments_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnAttachmentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnAttachmentsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attach_type):
            query['AttachType'] = request.attach_type
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnAttachments',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnAttachmentsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_attachments(
        self,
        request: vpc_20160428_models.DescribeVpnAttachmentsRequest,
    ) -> vpc_20160428_models.DescribeVpnAttachmentsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_attachments_with_options(request, runtime)

    async def describe_vpn_attachments_async(
        self,
        request: vpc_20160428_models.DescribeVpnAttachmentsRequest,
    ) -> vpc_20160428_models.DescribeVpnAttachmentsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_attachments_with_options_async(request, runtime)

    def describe_vpn_connection_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_connection_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_connection(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_connection_with_options(request, runtime)

    async def describe_vpn_connection_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_connection_with_options_async(request, runtime)

    def describe_vpn_connections_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_connections_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.customer_gateway_id):
            query['CustomerGatewayId'] = request.customer_gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnConnections',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnConnectionsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_connections(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_connections_with_options(request, runtime)

    async def describe_vpn_connections_async(
        self,
        request: vpc_20160428_models.DescribeVpnConnectionsRequest,
    ) -> vpc_20160428_models.DescribeVpnConnectionsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_connections_with_options_async(request, runtime)

    def describe_vpn_cross_account_authorizations_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnCrossAccountAuthorizations',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_cross_account_authorizations_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnCrossAccountAuthorizations',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_cross_account_authorizations(
        self,
        request: vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsRequest,
    ) -> vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_cross_account_authorizations_with_options(request, runtime)

    async def describe_vpn_cross_account_authorizations_async(
        self,
        request: vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsRequest,
    ) -> vpc_20160428_models.DescribeVpnCrossAccountAuthorizationsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_cross_account_authorizations_with_options_async(request, runtime)

    def describe_vpn_gateway_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_gateway(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_gateway_with_options(request, runtime)

    async def describe_vpn_gateway_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewayRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_gateway_with_options_async(request, runtime)

    def describe_vpn_gateways_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_status):
            query['BusinessStatus'] = request.business_status
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewaysResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_gateways_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.business_status):
            query['BusinessStatus'] = request.business_status
        if not UtilClient.is_unset(request.include_reservation_data):
            query['IncludeReservationData'] = request.include_reservation_data
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnGateways',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnGatewaysResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_gateways(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_gateways_with_options(request, runtime)

    async def describe_vpn_gateways_async(
        self,
        request: vpc_20160428_models.DescribeVpnGatewaysRequest,
    ) -> vpc_20160428_models.DescribeVpnGatewaysResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_gateways_with_options_async(request, runtime)

    def describe_vpn_pbr_route_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnPbrRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_pbr_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnPbrRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_pbr_route_entries(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_pbr_route_entries_with_options(request, runtime)

    async def describe_vpn_pbr_route_entries_async(
        self,
        request: vpc_20160428_models.DescribeVpnPbrRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnPbrRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_pbr_route_entries_with_options_async(request, runtime)

    def describe_vpn_route_entries_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnRouteEntriesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_route_entries_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_entry_type):
            query['RouteEntryType'] = request.route_entry_type
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnRouteEntries',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnRouteEntriesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_route_entries(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_route_entries_with_options(request, runtime)

    async def describe_vpn_route_entries_async(
        self,
        request: vpc_20160428_models.DescribeVpnRouteEntriesRequest,
    ) -> vpc_20160428_models.DescribeVpnRouteEntriesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_route_entries_with_options_async(request, runtime)

    def describe_vpn_ssl_server_logs_with_options(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.minute_period):
            query['MinutePeriod'] = request.minute_period
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        if not UtilClient.is_unset(request.to):
            query['To'] = request.to
        if not UtilClient.is_unset(request.vpn_ssl_server_id):
            query['VpnSslServerId'] = request.vpn_ssl_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnSslServerLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnSslServerLogsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpn_ssl_server_logs_with_options_async(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.from_):
            query['From'] = request.from_
        if not UtilClient.is_unset(request.minute_period):
            query['MinutePeriod'] = request.minute_period
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_number):
            query['PageNumber'] = request.page_number
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.ssl_vpn_client_cert_id):
            query['SslVpnClientCertId'] = request.ssl_vpn_client_cert_id
        if not UtilClient.is_unset(request.to):
            query['To'] = request.to
        if not UtilClient.is_unset(request.vpn_ssl_server_id):
            query['VpnSslServerId'] = request.vpn_ssl_server_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpnSslServerLogs',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeVpnSslServerLogsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpn_ssl_server_logs(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_vpn_ssl_server_logs_with_options(request, runtime)

    async def describe_vpn_ssl_server_logs_async(
        self,
        request: vpc_20160428_models.DescribeVpnSslServerLogsRequest,
    ) -> vpc_20160428_models.DescribeVpnSslServerLogsResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpn_ssl_server_logs_with_options_async(request, runtime)

    def describe_zones_with_options(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_type):
            query['ZoneType'] = request.zone_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeZonesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_zones_with_options_async(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.accept_language):
            query['AcceptLanguage'] = request.accept_language
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.zone_type):
            query['ZoneType'] = request.zone_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeZones',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DescribeZonesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_zones(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        runtime = util_models.RuntimeOptions()
        return self.describe_zones_with_options(request, runtime)

    async def describe_zones_async(
        self,
        request: vpc_20160428_models.DescribeZonesRequest,
    ) -> vpc_20160428_models.DescribeZonesResponse:
        runtime = util_models.RuntimeOptions()
        return await self.describe_zones_with_options_async(request, runtime)

    def detach_dhcp_options_set_from_vpc_with_options(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachDhcpOptionsSetFromVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse(),
            self.call_api(params, req, runtime)
        )

    async def detach_dhcp_options_set_from_vpc_with_options_async(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DetachDhcpOptionsSetFromVpc',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def detach_dhcp_options_set_from_vpc(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        runtime = util_models.RuntimeOptions()
        return self.detach_dhcp_options_set_from_vpc_with_options(request, runtime)

    async def detach_dhcp_options_set_from_vpc_async(
        self,
        request: vpc_20160428_models.DetachDhcpOptionsSetFromVpcRequest,
    ) -> vpc_20160428_models.DetachDhcpOptionsSetFromVpcResponse:
        runtime = util_models.RuntimeOptions()
        return await self.detach_dhcp_options_set_from_vpc_with_options_async(request, runtime)

    def disable_nat_gateway_ecs_metric_with_options(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableNatGatewayEcsMetricResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_nat_gateway_ecs_metric_with_options_async(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableNatGatewayEcsMetricResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_nat_gateway_ecs_metric(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return self.disable_nat_gateway_ecs_metric_with_options(request, runtime)

    async def disable_nat_gateway_ecs_metric_async(
        self,
        request: vpc_20160428_models.DisableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.DisableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return await self.disable_nat_gateway_ecs_metric_with_options_async(request, runtime)

    def disable_vpc_classic_link_with_options(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableVpcClassicLinkResponse(),
            self.call_api(params, req, runtime)
        )

    async def disable_vpc_classic_link_with_options_async(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DisableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DisableVpcClassicLinkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def disable_vpc_classic_link(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return self.disable_vpc_classic_link_with_options(request, runtime)

    async def disable_vpc_classic_link_async(
        self,
        request: vpc_20160428_models.DisableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.DisableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.disable_vpc_classic_link_with_options_async(request, runtime)

    def dissociate_route_table_from_gateway_with_options(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateRouteTableFromGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTableFromGatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def dissociate_route_table_from_gateway_with_options_async(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.gateway_id):
            query['GatewayId'] = request.gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_id):
            query['RouteTableId'] = request.route_table_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateRouteTableFromGateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTableFromGatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dissociate_route_table_from_gateway(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.dissociate_route_table_from_gateway_with_options(request, runtime)

    async def dissociate_route_table_from_gateway_async(
        self,
        request: vpc_20160428_models.DissociateRouteTableFromGatewayRequest,
    ) -> vpc_20160428_models.DissociateRouteTableFromGatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_route_table_from_gateway_with_options_async(request, runtime)

    def dissociate_route_tables_from_vpc_gateway_endpoint_with_options(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_ids):
            query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateRouteTablesFromVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def dissociate_route_tables_from_vpc_gateway_endpoint_with_options_async(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.endpoint_id):
            query['EndpointId'] = request.endpoint_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_ids):
            query['RouteTableIds'] = request.route_table_ids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateRouteTablesFromVpcGatewayEndpoint',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dissociate_route_tables_from_vpc_gateway_endpoint(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return self.dissociate_route_tables_from_vpc_gateway_endpoint_with_options(request, runtime)

    async def dissociate_route_tables_from_vpc_gateway_endpoint_async(
        self,
        request: vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointRequest,
    ) -> vpc_20160428_models.DissociateRouteTablesFromVpcGatewayEndpointResponse:
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_route_tables_from_vpc_gateway_endpoint_with_options_async(request, runtime)

    def dissociate_vpn_gateway_with_certificate_with_options(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.certificate_id):
            query['CertificateId'] = request.certificate_id
        if not UtilClient.is_unset(request.certificate_type):
            query['CertificateType'] = request.certificate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse(),
            self.call_api(params, req, runtime)
        )

    async def dissociate_vpn_gateway_with_certificate_with_options_async(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.certificate_id):
            query['CertificateId'] = request.certificate_id
        if not UtilClient.is_unset(request.certificate_type):
            query['CertificateType'] = request.certificate_type
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.vpn_gateway_id):
            query['VpnGatewayId'] = request.vpn_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DissociateVpnGatewayWithCertificate',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def dissociate_vpn_gateway_with_certificate(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return self.dissociate_vpn_gateway_with_certificate_with_options(request, runtime)

    async def dissociate_vpn_gateway_with_certificate_async(
        self,
        request: vpc_20160428_models.DissociateVpnGatewayWithCertificateRequest,
    ) -> vpc_20160428_models.DissociateVpnGatewayWithCertificateResponse:
        runtime = util_models.RuntimeOptions()
        return await self.dissociate_vpn_gateway_with_certificate_with_options_async(request, runtime)

    def download_vpn_connection_config_with_options(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadVpnConnectionConfig',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DownloadVpnConnectionConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def download_vpn_connection_config_with_options_async(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpn_connection_id):
            query['VpnConnectionId'] = request.vpn_connection_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DownloadVpnConnectionConfig',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.DownloadVpnConnectionConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def download_vpn_connection_config(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        runtime = util_models.RuntimeOptions()
        return self.download_vpn_connection_config_with_options(request, runtime)

    async def download_vpn_connection_config_async(
        self,
        request: vpc_20160428_models.DownloadVpnConnectionConfigRequest,
    ) -> vpc_20160428_models.DownloadVpnConnectionConfigResponse:
        runtime = util_models.RuntimeOptions()
        return await self.download_vpn_connection_config_with_options_async(request, runtime)

    def enable_nat_gateway_ecs_metric_with_options(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableNatGatewayEcsMetricResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_nat_gateway_ecs_metric_with_options_async(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableNatGatewayEcsMetric',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableNatGatewayEcsMetricResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_nat_gateway_ecs_metric(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_nat_gateway_ecs_metric_with_options(request, runtime)

    async def enable_nat_gateway_ecs_metric_async(
        self,
        request: vpc_20160428_models.EnableNatGatewayEcsMetricRequest,
    ) -> vpc_20160428_models.EnableNatGatewayEcsMetricResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_nat_gateway_ecs_metric_with_options_async(request, runtime)

    def enable_physical_connection_with_options(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnablePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnablePhysicalConnectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_physical_connection_with_options_async(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.physical_connection_id):
            query['PhysicalConnectionId'] = request.physical_connection_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnablePhysicalConnection',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnablePhysicalConnectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_physical_connection(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_physical_connection_with_options(request, runtime)

    async def enable_physical_connection_async(
        self,
        request: vpc_20160428_models.EnablePhysicalConnectionRequest,
    ) -> vpc_20160428_models.EnablePhysicalConnectionResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_physical_connection_with_options_async(request, runtime)

    def enable_vpc_classic_link_with_options(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcClassicLinkResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_vpc_classic_link_with_options_async(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableVpcClassicLink',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcClassicLinkResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_vpc_classic_link(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_vpc_classic_link_with_options(request, runtime)

    async def enable_vpc_classic_link_async(
        self,
        request: vpc_20160428_models.EnableVpcClassicLinkRequest,
    ) -> vpc_20160428_models.EnableVpcClassicLinkResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_vpc_classic_link_with_options_async(request, runtime)

    def enable_vpc_ipv_4gateway_with_options(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_id):
            query['Ipv4GatewayId'] = request.ipv_4gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_list):
            query['RouteTableList'] = request.route_table_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableVpcIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcIpv4GatewayResponse(),
            self.call_api(params, req, runtime)
        )

    async def enable_vpc_ipv_4gateway_with_options_async(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.dry_run):
            query['DryRun'] = request.dry_run
        if not UtilClient.is_unset(request.ipv_4gateway_id):
            query['Ipv4GatewayId'] = request.ipv_4gateway_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        if not UtilClient.is_unset(request.route_table_list):
            query['RouteTableList'] = request.route_table_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='EnableVpcIpv4Gateway',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.EnableVpcIpv4GatewayResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def enable_vpc_ipv_4gateway(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return self.enable_vpc_ipv_4gateway_with_options(request, runtime)

    async def enable_vpc_ipv_4gateway_async(
        self,
        request: vpc_20160428_models.EnableVpcIpv4GatewayRequest,
    ) -> vpc_20160428_models.EnableVpcIpv4GatewayResponse:
        runtime = util_models.RuntimeOptions()
        return await self.enable_vpc_ipv_4gateway_with_options_async(request, runtime)

    def get_dhcp_options_set_with_options(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetDhcpOptionsSetResponse(),
            self.call_api(params, req, runtime)
        )

    async def get_dhcp_options_set_with_options_async(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dhcp_options_set_id):
            query['DhcpOptionsSetId'] = request.dhcp_options_set_id
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_account):
            query['ResourceOwnerAccount'] = request.resource_owner_account
        if not UtilClient.is_unset(request.resource_owner_id):
            query['ResourceOwnerId'] = request.resource_owner_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='GetDhcpOptionsSet',
            version='2016-04-28',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            vpc_20160428_models.GetDhcpOptionsSetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def get_dhcp_options_set(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return self.get_dhcp_options_set_with_options(request, runtime)

    async def get_dhcp_options_set_async(
        self,
        request: vpc_20160428_models.GetDhcpOptionsSetRequest,
    ) -> vpc_20160428_models.GetDhcpOptionsSetResponse:
        runtime = util_models.RuntimeOptions()
        return await self.get_dhcp_options_set_with_options_async(request, runtime)

    def get_flow_log_service_status_with_options(
        self,
        request: vpc_20160428_models.GetFlowLogServiceStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> vpc_20160428_models.GetFlowLogServiceStatusResponse:
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.client_token):
            query['ClientToken'] = request.client_token
        if not UtilClient.is_unset(request.owner_account):
            query['OwnerAccount'] = request.owner_account
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.resource_owner_acco