"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GithubActionsIdentityProvider = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const cdk = require("@aws-cdk/core");
/**
 * (experimental) Github Actions as OpenID Connect Identity Provider for AWS IAM. There can be only one (per AWS Account).
 *
 * Use `fromAccount` to retrieve a reference to existing Github OIDC provider.
 *
 * @see https://docs.github.com/en/actions/deployment/security-hardening-your-deployments/configuring-openid-connect-in-amazon-web-services
 * @experimental
 */
class GithubActionsIdentityProvider extends iam.OpenIdConnectProvider {
    /**
     * (experimental) Define a new Github OpenID Connect Identity PRovider for AWS IAM.
     *
     * There can be only one (per AWS Account).
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @experimental
     * @example
     *
     * new GithubActionsIdentityProvider(scope, "GithubProvider");
     */
    constructor(scope, id) {
        super(scope, id, {
            url: `https://${GithubActionsIdentityProvider.issuer}`,
            thumbprints: GithubActionsIdentityProvider.thumbprints,
            clientIds: ['sts.amazonaws.com'],
        });
    }
    /**
     * (experimental) Retrieve a reference to existing Github OIDC provider in your AWS account.
     *
     * An AWS account can only have single Github OIDC provider configured into it,
     * so internally the reference is made by constructing the ARN from AWS
     * Account ID & Github issuer URL.
     *
     * @param scope CDK Stack or Construct to which the provider is assigned to.
     * @param id CDK Construct ID given to the construct.
     * @returns a CDK Construct representing the Github OIDC provider
     * @experimental
     * @example
     *
     * GithubActionsIdentityProvider.fromAccount(scope, "GithubProvider");
     */
    static fromAccount(scope, id) {
        const accountId = cdk.Stack.of(scope).account;
        const providerArn = `arn:aws:iam::${accountId}:oidc-provider/${GithubActionsIdentityProvider.issuer}`;
        return iam.OpenIdConnectProvider.fromOpenIdConnectProviderArn(scope, id, providerArn);
    }
}
exports.GithubActionsIdentityProvider = GithubActionsIdentityProvider;
_a = JSII_RTTI_SYMBOL_1;
GithubActionsIdentityProvider[_a] = { fqn: "aws-cdk-github-oidc.GithubActionsIdentityProvider", version: "0.0.23" };
/**
 * @experimental
 */
GithubActionsIdentityProvider.issuer = 'token.actions.githubusercontent.com';
/**
 * @experimental
 */
GithubActionsIdentityProvider.thumbprints = [
    'a031c46782e6e6c662c2c87c76da9aa62ccabd8e',
    '6938fd4d98bab03faadb97b34396831e3780aea1',
];
//# sourceMappingURL=data:application/json;base64,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