"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnS3 = exports.CustomFieldType = exports.OcrLanguages = exports.SecurityTier = exports.toJson_User = exports.toJson_CustomField = exports.AwsAuthenticationType = exports.toJson_CfnS3Props = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Generated by cdk-import
const cdk = require("aws-cdk-lib");
/**
 * Converts an object of type 'CfnS3Props' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CfnS3Props(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Enabled': obj.enabled,
        'FriendlyName': obj.friendlyName,
        'Description': obj.description,
        'AwsAuthenticationType': obj.awsAuthenticationType,
        'AwsRoleSessionName': obj.awsRoleSessionName,
        'AwsRoleArn': obj.awsRoleArn,
        'AwsAccessKey': obj.awsAccessKey,
        'AwsSecretKey': obj.awsSecretKey,
        'AwsSessionToken': obj.awsSessionToken,
        'AwsRegion': obj.awsRegion,
        'BucketName': obj.bucketName,
        'IncludeExcludeFiles': obj.includeExcludeFiles,
        'FileTypesToExclude': obj.fileTypesToExclude,
        'FolderToScan': obj.folderToScan,
        'ScannerGroup': obj.scannerGroup,
        'TestConnectionTimeoutInSeconds': obj.testConnectionTimeoutInSeconds,
        'CustomFields': obj.customFields?.map(y => toJson_CustomField(y)),
        'BusinessOwners': obj.businessOwners?.map(y => toJson_User(y)),
        'ItOwners': obj.itOwners?.map(y => toJson_User(y)),
        'Location': obj.location,
        'Scope': obj.scope,
        'SecurityTier': obj.securityTier,
        'Comments': obj.comments,
        'NumberOfParsingThreads': obj.numberOfParsingThreads,
        'MetadataAclScanEnabled': obj.metadataAclScanEnabled,
        'DsAclScanEnabled': obj.dsAclScanEnabled,
        'EnabledOcr': obj.enabledOcr,
        'OcrTimeout': obj.ocrTimeout,
        'OcrLanguages': obj.ocrLanguages,
        'EnableClustering': obj.enableClustering,
        'EnableClassifiers': obj.enableClassifiers,
        'EnableAdvanceClassifiers': obj.enableAdvanceClassifiers,
        'SampleFolders': obj.sampleFolders,
        'SamplePercentage': obj.samplePercentage,
        'SampleFileContent': obj.sampleFileContent,
        'DifferentialScan': obj.differentialScan,
        'IsModifiedInXDays': obj.isModifiedInXDays,
        'XLastDays': obj.xLastDays,
        'ScanWindowName': obj.scanWindowName,
        'ParquetFileRegex': obj.parquetFileRegex,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CfnS3Props = toJson_CfnS3Props;
/* eslint-enable max-len, quote-props */
/**
 * AWS Authentication Type
 *
 * @schema AwsAuthenticationType
 */
var AwsAuthenticationType;
(function (AwsAuthenticationType) {
    /** isCredentialsAuth */
    AwsAuthenticationType["IS_CREDENTIALS_AUTH"] = "isCredentialsAuth";
    /** isIamRoleAuth */
    AwsAuthenticationType["IS_IAM_ROLE_AUTH"] = "isIamRoleAuth";
    /** isAnonymousAuth */
    AwsAuthenticationType["IS_ANONYMOUS_AUTH"] = "isAnonymousAuth";
    /** isCrossAccountAuth */
    AwsAuthenticationType["IS_CROSS_ACCOUNT_AUTH"] = "isCrossAccountAuth";
    /** isSTSAuth */
    AwsAuthenticationType["IS_STS_AUTH"] = "isSTSAuth";
})(AwsAuthenticationType = exports.AwsAuthenticationType || (exports.AwsAuthenticationType = {}));
/**
 * Converts an object of type 'CustomField' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_CustomField(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Name': obj.name,
        'Value': obj.value,
        'Encoded': obj.encoded,
        'Type': obj.type,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_CustomField = toJson_CustomField;
/**
 * Converts an object of type 'User' to JSON representation.
 */
/* eslint-disable max-len, quote-props */
function toJson_User(obj) {
    if (obj === undefined) {
        return undefined;
    }
    const result = {
        'Id': obj.id,
        'Origin': obj.origin,
        'Email': obj.email,
    };
    // filter undefined values
    return Object.entries(result).reduce((r, i) => (i[1] === undefined) ? r : ({ ...r, [i[0]]: i[1] }), {});
}
exports.toJson_User = toJson_User;
/* eslint-enable max-len, quote-props */
/**
 * Security Tier
 *
 * @schema SecurityTier
 */
var SecurityTier;
(function (SecurityTier) {
    /** 1 */
    SecurityTier["VALUE_1"] = "1";
    /** 2 */
    SecurityTier["VALUE_2"] = "2";
    /** 3 */
    SecurityTier["VALUE_3"] = "3";
    /** 4 */
    SecurityTier["VALUE_4"] = "4";
    /** 5 */
    SecurityTier["VALUE_5"] = "5";
})(SecurityTier = exports.SecurityTier || (exports.SecurityTier = {}));
/**
 * OCR Languages (only used when "EnabledOcr" is set to "true")
 *
 * @schema OcrLanguages
 */
var OcrLanguages;
(function (OcrLanguages) {
    /** eng */
    OcrLanguages["ENG"] = "eng";
    /** chi_sim+chi_tra */
    OcrLanguages["CHI_SIM_CHI_TRA"] = "chi_sim+chi_tra";
    /** ind */
    OcrLanguages["IND"] = "ind";
    /** jpn */
    OcrLanguages["JPN"] = "jpn";
    /** kor */
    OcrLanguages["KOR"] = "kor";
    /** tha */
    OcrLanguages["THA"] = "tha";
    /** vie */
    OcrLanguages["VIE"] = "vie";
    /** deu */
    OcrLanguages["DEU"] = "deu";
    /** fra */
    OcrLanguages["FRA"] = "fra";
    /** bul */
    OcrLanguages["BUL"] = "bul";
})(OcrLanguages = exports.OcrLanguages || (exports.OcrLanguages = {}));
/**
 * @schema CustomFieldType
 */
var CustomFieldType;
(function (CustomFieldType) {
    /** clear */
    CustomFieldType["CLEAR"] = "clear";
    /** encrypted */
    CustomFieldType["ENCRYPTED"] = "encrypted";
})(CustomFieldType = exports.CustomFieldType || (exports.CustomFieldType = {}));
/**
 * A CloudFormation `BigID::DataSource::S3`
 *
 * @cloudformationResource BigID::DataSource::S3
 * @stability external
 * @link https://github.com/aws-cloudformation/aws-cloudformation-rpdk.git
 */
class CfnS3 extends cdk.CfnResource {
    /**
     * Create a new `BigID::DataSource::S3`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnS3.CFN_RESOURCE_TYPE_NAME, properties: toJson_CfnS3Props(props) });
        this.props = props;
    }
}
exports.CfnS3 = CfnS3;
_a = JSII_RTTI_SYMBOL_1;
CfnS3[_a] = { fqn: "@cdk-cloudformation/bigid-datasource-s3.CfnS3", version: "1.1.0-alpha.7" };
/**
* The CloudFormation resource type name for this resource class.
*/
CfnS3.CFN_RESOURCE_TYPE_NAME = "BigID::DataSource::S3";
//# sourceMappingURL=data:application/json;base64,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