---
model_id: "text/legal-bert" 
model_name: "Legal Bert" 
vector_length: "768 (default)"
paper: "https://arxiv.org/abs/2010.02559"
repo: "https://huggingface.co/nlpaueb/legal-bert-base-uncased"
release_date: "2020-10-06"
installation: "pip install vectorhub[encoders-text-torch-transformers]"
category: text
short_description: We propose a systematic investigation of the available strategies when applying BERT in Legal domains.
---

## Description

The recent “Text-to-Text Transfer Transformer” (T5) leveraged a unified text-to-text format and scale to attain state-of-the-art results on a wide variety of English-language NLP tasks. In this paper, we introduce mT5, a multilingual variant of T5 that was pre-trained on a new Common Crawl-based dataset covering 101 languages. We describe the design and modified training of mT5 and demonstrate its state-of-the-art performance on many multilingual benchmarks. All of the code and model checkpoints

## Example

```python
#pip install vectorhub[encoders-text-torch-transformers]
from vectorhub.encoders.text.torch_transformers import T52Vec
model = T52Vec()
model.encode("I enjoy taking long walks along the beach with my dog.")
```
