"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ServiceDiscovery = exports.DnsResponseType = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Enum of DNS service discovery response type.
 *
 * @stability stable
 */
var DnsResponseType;
(function (DnsResponseType) {
    DnsResponseType["LOAD_BALANCER"] = "LOADBALANCER";
    DnsResponseType["ENDPOINTS"] = "ENDPOINTS";
})(DnsResponseType = exports.DnsResponseType || (exports.DnsResponseType = {}));
/**
 * Provides the Service Discovery method a VirtualNode uses.
 *
 * @stability stable
 */
class ServiceDiscovery {
    /**
     * Returns DNS based service discovery.
     *
     * @param responseType Specifies the DNS response type for the virtual node.
     * @stability stable
     */
    static dns(hostname, responseType) {
        jsiiDeprecationWarnings._aws_cdk_aws_appmesh_DnsResponseType(responseType);
        return new DnsServiceDiscovery(hostname, responseType);
    }
    /**
     * Returns Cloud Map based service discovery.
     *
     * @param service The AWS Cloud Map Service to use for service discovery.
     * @param instanceAttributes A string map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance.
     * @stability stable
     */
    static cloudMap(service, instanceAttributes) {
        return new CloudMapServiceDiscovery(service, instanceAttributes);
    }
}
exports.ServiceDiscovery = ServiceDiscovery;
_a = JSII_RTTI_SYMBOL_1;
ServiceDiscovery[_a] = { fqn: "@aws-cdk/aws-appmesh.ServiceDiscovery", version: "1.133.0" };
class DnsServiceDiscovery extends ServiceDiscovery {
    constructor(hostname, responseType) {
        super();
        this.hostname = hostname;
        this.responseType = responseType;
    }
    bind(_scope) {
        return {
            dns: {
                hostname: this.hostname,
                responseType: this.responseType,
            },
        };
    }
}
class CloudMapServiceDiscovery extends ServiceDiscovery {
    constructor(service, instanceAttributes) {
        super();
        this.service = service;
        this.instanceAttributes = instanceAttributes;
    }
    bind(_scope) {
        return {
            cloudmap: {
                namespaceName: this.service.namespace.namespaceName,
                serviceName: this.service.serviceName,
                attributes: renderAttributes(this.instanceAttributes),
            },
        };
    }
}
function renderAttributes(attrs) {
    if (attrs === undefined) {
        return undefined;
    }
    return Object.entries(attrs).map(([key, value]) => ({ key, value }));
}
//# sourceMappingURL=data:application/json;base64,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