"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.QueryParameterMatch = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Used to generate query parameter matching methods.
 *
 * @stability stable
 */
class QueryParameterMatch {
    /**
     * The value of the query parameter with the given name in the request must match the specified value exactly.
     *
     * @param queryParameterName the name of the query parameter to match against.
     * @param queryParameterValue The exact value to test against.
     * @stability stable
     */
    static valueIs(queryParameterName, queryParameterValue) {
        return new QueryParameterMatchImpl(queryParameterName, { exact: queryParameterValue });
    }
}
exports.QueryParameterMatch = QueryParameterMatch;
_a = JSII_RTTI_SYMBOL_1;
QueryParameterMatch[_a] = { fqn: "@aws-cdk/aws-appmesh.QueryParameterMatch", version: "1.133.0" };
class QueryParameterMatchImpl extends QueryParameterMatch {
    constructor(queryParameterName, matchProperty) {
        super();
        this.queryParameterName = queryParameterName;
        this.matchProperty = matchProperty;
    }
    bind(_scope) {
        return {
            queryParameterMatch: {
                match: this.matchProperty,
                name: this.queryParameterName,
            },
        };
    }
}
//# sourceMappingURL=data:application/json;base64,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