# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['pmlv']

package_data = \
{'': ['*']}

install_requires = \
['attrs>=21,<22', 'static-ffmpeg>=2.2,<3.0']

entry_points = \
{'console_scripts': ['pomalevi = pmlv.main:doitall',
                     'static_ffmpeg = static_ffmpeg.run:main_static_ffmpeg',
                     'static_ffprobe = static_ffmpeg.run:main_static_ffprobe']}

setup_kwargs = {
    'name': 'pomalevi',
    'version': '1.0',
    'description': 'Powerpoint-based maintainable lecture videos',
    'long_description': '# pomalevi\n\nPowerPoint-based maintainable lecture videos command-line tool\n\nSimple and effective.\n\nIf you are afraid of using the command-line, this is not for you.\n\n\n## What `pomalevi` is\n\nPowerPoint allows recording slide shows \nwith narration and even a webcam insert\nwith its SlideShow⟶RecordSlideShow function.\nThe media files are stored within the PPT file on a per-slide basis.\nThis can be turned into a video via "File⟶SaveAs⟶*.wmv"\n\npomalevi converts such a video file (or any other) as follows:\n\n- it turns the huge video produced by PowerPoint into a _much_ smaller one\n  by applying more reasonable compression settings\n- it can split the video into parts (separate, shorter videos) based on \n  when a user-defined `splitlogo` appears in the video\n- it produces an HTML page with table of content hyperlinks for these\n  parts based on a very simple text file containing parts descriptions\n- it provides a simple HTML player that will stop the video\n  when a user-defined `stoplogo` appears in the video,\n  so that the audience can ponder a question.\n\n\n## Why `pomalevi` exists\n\nI have previously used Camtasia to record lecture videos with Camtasia\'s\nPowerPoint plugin.\nI have inserted the stops I wanted (after I\'d asked the viewers a question)\nmanually in the Camtasia Editor and then cut the video\ninto the five-or-so pieces (of 10-20 minutes each) I want \nand exported ("produced") each piece individually using the Batch Production\nfeature.\n\nThis gives nice results, but is a lot of manual work. \nIt is acceptable for a one-time process, but what if I want to modify \ntwo of the slides next year? Or modify my narration? Aw!\n\nPowerPoint\'s "Record" function is a good answer to this:\nEach slide can be re-recorded individually.\nThen just re-export the whole video.\n\nBut I did not want to give up my chopping-into-five-parts\nand even less so the automated stops that Camtasia\'s SmartPlayer allows.\nThat\'s when the idea of pomalevi was born:\nLet\'s combine the strengths of PowerPoint\'s slidewise recording \nwith fully automated postprocessing.\nA couple of couples of hours later here we go.\n\n\n## Pros and cons\n\nPro:\n- Pomalevi-plus-Powerpoint produces very useful output with little effort\n- Subsequent changes are easy to make, your lecture videos become maintainable\n\nCon:\n- Depending on how fast your computer is, re-creating a pomalevi video\n  takes a substantial amount of time during which your machine is very busy.\n\nIn my case, it is typically about 1.5x the video play time,\nthe bigger part of which is needed by the Powerpoint video export.\n\n\n## How to install `pomalevi`\n\npomalevi is tested on Windows, but should also work on WSL or Linux proper.\nIt is a command-line application, so you need to work in cmd.exe or \nPowershell.\n\n- Install a recent version of Python (3.8 or higher) from\n  https://python.org.  \n  Commands `python` and `pip` must end up on your `PATH`.\n- Start cmd.exe or powershell and perform `pip install pomalevi`\n- That\'s all!  \n  You should now be able to call `pomalevi`.\n\nCaveats:\n- The above should work on personal computers.  \n  If you have a pre-installed version of Python but are not allowed to use\n `pip` as shown (you should be!),\n  - use `pip install --user pomalevi` instead to install to your\n    personal directory instead\n  - use `pip show pomalevi` to see (in the "Location:" entry) \n    where it ended up, e.g.\n    `c:\\Users\\<name>\\AppData\\Roaming\\Python\\Python310\\site-packages`\n  - put the neighboring `Scripts` directory in your `Path`, e.g.\n    `c:\\Users\\<name>\\AppData\\Roaming\\Python\\Scripts`.  \n    (To modify `Path`, use the Windows key, search for "environment"`,\n    and call "Edit environment variables for your account" (not "for system").\n    If your Windows is not running in English, the name will be different,\n    but the English search term should still work.)\n  Pomalevi should now work like after the original procedure.  \n  Alternatively, you could perform an additional install of Python\n  in "for me only" fashion and use the pip of that.\n- The above installation procedure is a shortcut: If used, pomalevi\n  could _in principle_ interfere with other Python packages installed on your\n  machine (although that is unlikely to be a problem).  \n  A cleaner way would use `pipx` instead of `pip`, which installs a\n  package in an isolated environment.\n  To do that, \n  - first install `pipx` by `pip install pipx`\n  - then install pomalevi by `pipx install pomalevi`\n  - and then put the path displayed by `pipx` into your `PATH`\n\n\n## How to use `pomalevi`\n\n\n### View demo.pptx (1 minute)\n\nFind the pomalevi install directory tree in the\ndirectory ending in `site-packages` which is shown when you execute \n`python -c "import sys; print(sys.path)"`.\n\nFrom the pomalevi install directory tree,\ncopy `ppt/demo.pptx` to any of your own directories.  \nOpen the copy with Powerpoint,  \nchoose "Powerpoint⟶Slide Show",  \ncheck the boxes for "Play Narrations" and "Use Timings",  \nstart the slide show.  \nView it, end it. Imagine this was your own presentation which you want\nto publish as several videos in pomalevi style.\n\nTo do that, "File⟶Save as" this file,\nselect file format "Windows Media Video (*.wmv)",\nand save it as `myslides.wmv`.\nThis file you can use as the `myslides.wmv` in the subsequent examples.\n\n\n### Very basic use: Compression only\n\n`pomalevi mydir/myslides.wmv`\n\nThe output is a directory `mydir/myslides/` with several files.\nYou can either use `mydir/myslides/index.html` \nto get the pomalevi player or\njust the video itself: `mydir/myslides/v1.mp4`.\n\n\n### Inserting stops: `-stop-at`\n\n- In Powerpoint, choose a **unique graphic** or text string that will appear in your\n  video to indicate to pomalevi where to insert a stop.\n- For instance, I use "Insert⟶Icons⟶Business"\n  pick the two people with the question mark (I have PowerPoint 2019),\n  keep the default size, fill the icon with my highlight color (dark red),\n  and put it in the lower left corner of my slide.\n  (Any corner can be made to work easily, other places are possible if needed.)\n- You could in principle also use the string "STOP!" or whatever other \n  fixed-and-unique visual element you like.\n- Insert an **Entrance animation** for the logo at the appropriate moment,\n  perhaps insert an Exit animation shortly thereafter.\n  Only the entrance moment is relevant; it is the stop moment.  \n  Note that the player is not capable of stopping at _exactly_ this moment;\n  expect a tolerance of +0.25 seconds (0.5 seconds for Firefox).\n- Export the video from PowerPoint.  \n  Play it at original scale (that is, size 100%).  \n  Stop it when the logo is visible.  \n  Make a rectangular-area **screenshot** of only the logo.  \n  Store it as PNG, e.g. `stoplogo.png`.\n- Here is what the result looks like in my case:\n  <img src="img/stoplogo.png" alt="Example pomalevi stop logo">\n- pomalevi makes a pixel-by-pixel search for this image and expects\n  a match of at least 80%, so beware of non-rectangular or transparent logos\n  if the slide background behind it will not always be the same.\n  See also section "Caveats" below.\n- Now produce the video with pomalevi:  \n  `pomalevi --stop-at ll:stoplogo.png mydir/myslides.wmv`  \n  (`ll` stands for **"lower left"**)\n- Searching for a stoplogo is a slooow process if done over the whole image.\n  Therefore, pomalevi expects the logo to be in one of the four corners\n  of the slide: one of `ul`, `ur`, `ll`, `lr` \n  in the `--stop-at` specification, meaning\n  upper left, upper right, lower left, lower right, respectively.  \n  It will find it there with a tolerance of up to half a logo width\n  and half a logo height towards the middle of the video.\n  If the logo hangs over the edge of the video even a bit, \n  it cannot be found reliably.  \n  The part after the position specifier can be a pathname.\n- In principle, you can also specify the search area by hand thusly:  \n  `--stop-at x=900..1000,y=500..600:stoplogo.png`\n  would look for the logo (specifically: the upper-left corner of the logo)\n  in that region of the video (near the middle).  \n  x=0,y=0 is the upper left corner.\n- Unlike for basic use, this time the `v1.mp4` file is not helpful,\n  because it knows nothing about the stops.  \n  Instead, you need to use `mydir/myslides/index.html`, which calls\n  the **pomalevi player** and feeds it the proper list of stop times.\n- Like most pomalevi options, `--stop-at` has **friendly defaults**:\n  - `--stop-at ll:stoplogo.png` will be assumed by default,\n    but if `stoplogo.png` is not found, no stoplogo search will be performed.\n  - The stoplogo will be searched for in several places:\n    - `./stoplogo.png`, in the local directory\n    - `mydir/stoplogo.png`, in the input file directory\n    - `mydir/../stoplogo.png`, in the parent of the input file directory\n    - `mydir/toc/stoplogo.png`, in the `toc` subdirectory of the input file \n      directory (see the description of `--toc` below).\n\n\n### Splitting into parts: `--split-at`\n\nThe output of pomalevi appears a bit silly unless you let pomalevi \nsplit your video into several parts.\n\n- Splitting works **much the same as stopping** (described above):  \n  Decide on a logo (of course not the same one as for stopping),  \n  insert it in your presentation (preferably again in the lower right),  \n  make a screenshot of it in the original size,  \n  store it as (preferably) `splitlogo.png`, and  \n  call pomalevi with it:    \n  `pomalevi --split-at ll:splitlogo.png input.wmv`  \n- Splitting creates a separate video file for each part, called\n  `v1.mp4`, `v2.mp4`, etc.\n- `mydir/myslides/index.html` provides navigation between those videos.\n- The same **friendly defaults** apply as for `--stop-at`.\n\n\n### Navigation with content description: `--toc`\n\nAll you get so far for navigation in the HTML file are generic section\ntitles "part 1", "part 2", etc. that are hyperlinks which load the respective\npart of the video.\nYou can get a text to the right of each number that describes the\ncontent of that video part and also get a meaningful title\nfor the HTML page by using the `--toc filename` option (table of contents):\n\nThe file given must be a UTF-8-encoded plain-text file\nwith a paragraph structure. \nUse any text editor (for instance MS Windows\' `notepad`)\nto produce them.\nParagraphs are separated simply by an empty line.\n\nThe first paragraph (paragraph 0) provides the title of the \n`index.html` page.  \nSubsequent paragraphs 1..N provide the content description for\nvideo parts 1..N.\n\nExample:\n```\nThis is the title\n\nThis is the description of video part 1. It is a longer one that\ntakes multiple lines. Those lines will be rendered as a flowing\nparagraph of text on the HTML page.\n\nThis is the description of the second video part, number 2.\n```\n\nLike most pomalevi options, `--toc` has **friendly defaults**:\n- `--toc myslides-toc.txt` will be assumed by default,\n  but if `myslides-toc.txt` is not found, the generic toc will be produced instead.\n- The toc file will be searched for in several places:\n  - `./myslides-toc.txt`, in the local directory\n  - `mydir/myslides-toc.txt`, in the input file directory\n  - `mydir/toc/stoplogo.png`, in the `toc` subdirectory of the input file \n     directory.\n\n\n### Output directory: `--out`\n\nSo far, we have always used the **friendly default** to tell\npomalevi where we want the output to end up:\nIf the input file is `mydir/myslides.wmv`, the output will go to\n`mydir/myslides/*`.\n\nIf you don\'t want this, specifiy a target directory with `--out`:  \n`pomalevi --out outputdir mydir/myslides.wmv`.\n\n\n### Friendly defaults rough summary\n\nTaking all of the above together, the explicit pomalevi call could be:  \n`pomalevi --split-at ll:splitlogo.png --stop-at ll:stoplogo.png --toc mydir/myslides-toc.txt --out mydir/myslides mydir/myslides.wmv`  \nbut the following is equivalent, courtesy of the defaults:  \n`pomalevi mydir/myslides.wmv`\n\n\n### Overlapping Powerpoint export and pomalevi: waiting\n\n- Powerpoint export takes a long time,\n  pomalevi encoding also takes a long time.\n  It would be nice if we could start pomalevi before Powerpoint has \n  finished exporting.  \n  Consider it done!\n- pomalevi will automatically wait until the given input file appears to \n  have been exported completely\n  and only then start the actual pomalevi work.\n\n\n### Encoding type and quality: `--format`\n\npomalevi can produce either \n`*.mp4` video files \n(encoded with H.264 video and AAC audio) or \n`*.webm` video files\n(encoded with VP8 video and Opus audio).\n\n`webm` encoding currently uses rather naive settings and is not recommended.\n\n`mp4` encoding is available with four different sets of settings, called\nq1 to q4, that produce different quality levels and file sizes.  \nq1 creates the smallest files with the lowest audio and video quality,  \nq4 creates the largest files with the highest quality.\n\nThese are selected using  \n`--format mp4q1`  \n`--format mp4q2`  \n`--format mp4q3`  \n`--format mp4q4`  \n`--format webm`\n\n`mp4q3` is the default.\n\n\n## How pomalevi works internally\n\npomalevi uses [ffmpeg](https://ffmpeg.org)\'s `find_rect` filter \nto find all frames that contain the respective logo PNG content.\nIt uses the time information of these frames to drive the splitting\ninto parts and to feed the pomalevi player with the stop times\nfor each part.\n\n`find_rect` cannot cope with scaling or rotation of the target image,\nworks only with a rectangular image, \nand it considers only a grayscale version of it with no alpha channel.\n\nIf you use a logo file `mylogo.png`, \nits grayscale derivative `mylogo.pgm` will appear\nin the output directory during encoding (and then disappear again).\n\n\n## Caveats\n\n- On my machine, the MP4 files produced by PowerPoint\'s "Export" function\n  are always broken: After a slide transition, when the new slide is already\n  visible, the old one shortly reappears for varying lengths of time from\n  a single frame to several tenths of a second.  \n  So I use "Save as" with target format WMV instead.\n  That\'s sort of silly (because WMV is the inferior format) but at least it works.\n- Because of how pomalevi works (see above), the search for stop logo or split logo\n  may fail if the background of the logo is colored.\n  There must be enough contrast between the logo color(s) and the\n  background color when converted to grayscale.\n- Because of how it works (see above), the search for stop logo or split logo\n  may fail if the logo has transparent parts and is placed onto other  \n  material. The logo match is fuzzy, but expects at least an 80% match.\n- Unless you place your logo _precisely_ in the corner, fine details in\n  the logo will make the match worse. Prefer simple logos.\n\n  \n## TODO\n\nImprovements waiting to be made:\n\n- make demo.ppt\n- command keywords `encode`, `compress`, `patch`, `get-logos`, `get-demo`.\n- `--ffmpeg-a`, `--ffmpeg-v` to submit encoding options\n- highlight current video in toc\n- make `pomalevi.css` mobile-ready\n- `--favicon file`: Name of a 32x32 pixel PNG file to be used as the favicon.\n\n\n## Versions\n\n- 0.7, 2022-03-18\n  - initial version, with most of the functionality:\n    encode with splits and stops, basic CSS, TOC\n- 0.8, 2022-04-28:\n  - lots of small additions to functionality\n  - obtain actual video resolution\n  - modularized internal structure\n  - friendly defaults for `--split-at`, `--stop-at`, `--toc`, `--out`.\n- 0.9, 2022-04-29:\n  - use `static-ffmpeg` Python package, no longer the system\'s ffmpeg\n  - use Poetry build system and produce `pomalevi.exe`\n- 1.0, 2022-05-06\n  - add `--format`\n  - add `ppt/demo.pptx`',
    'author': 'Lutz Prechelt',
    'author_email': 'prechelt@inf.fu-berlin.de',
    'maintainer': None,
    'maintainer_email': None,
    'url': 'https://github.com/prechelt/pomalevi/blob/main/README.md',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
