import pyfiglet
import time
import os
import random
from colorama import Fore, Style
import threading

def clear_terminal():
    """Membersihkan layar terminal (Windows & Linux/macOS)."""
    os.system("cls" if os.name == "nt" else "clear")

def print_static_text():
    """Menampilkan teks tambahan yang tidak berubah."""
    print("\n" + Fore.GREEN + "🔥 Stay Connected! 🔥" + Style.RESET_ALL)
    print(Fore.CYAN + "📢 Join Telegram Group: https://t.me/sam_xode" + Style.RESET_ALL)
    print(Fore.GREEN + "🐦 Follow Twitter: https://x.com/sam_xode" + Style.RESET_ALL)
    print(Fore.GREEN + "PRESS CTRL + C TO CONTINUE" + Style.RESET_ALL)

def get_random_color():
    """Mengembalikan warna acak dari colorama."""
    colors = [Fore.RED, Fore.BLUE, Fore.YELLOW, Fore.MAGENTA, Fore.CYAN, Fore.GREEN, Fore.WHITE]
    return random.choice(colors)

def color_change_effect_forever(text="<SAMXODE/>", font="big", delay=3):
    """Menampilkan teks dengan warna berubah-ubah setiap beberapa detik."""
    ascii_art = pyfiglet.figlet_format(text, font=font)  
    
    try:
        while True:
            clear_terminal()
            color = get_random_color()
            print(color + ascii_art + Style.RESET_ALL)
            print_static_text()
            time.sleep(delay)
    except KeyboardInterrupt:
        clear_terminal()
        print(Fore.RED + "Color effect stopped!" + Style.RESET_ALL)

def start_watermark():
    """Menjalankan efek watermark di thread terpisah."""
    thread = threading.Thread(target=color_change_effect_forever, daemon=True)
    thread.start()
