# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class TopologySpreadConstraint(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'label_selector': 'LabelSelector',
        'max_skew': 'int',
        'topology_key': 'str',
        'when_unsatisfiable': 'UnsatisfiableConstraintAction'
    }

    attribute_map = {
        'label_selector': 'labelSelector',
        'max_skew': 'maxSkew',
        'topology_key': 'topologyKey',
        'when_unsatisfiable': 'whenUnsatisfiable'
    }

    def __init__(self, label_selector=None, max_skew=None, topology_key=None, when_unsatisfiable=None):  # noqa: E501
        """TopologySpreadConstraint - a model defined in Swagger"""  # noqa: E501

        self._label_selector = None
        self._max_skew = None
        self._topology_key = None
        self._when_unsatisfiable = None
        self.discriminator = None

        if label_selector is not None:
            self.label_selector = label_selector
        if max_skew is not None:
            self.max_skew = max_skew
        if topology_key is not None:
            self.topology_key = topology_key
        if when_unsatisfiable is not None:
            self.when_unsatisfiable = when_unsatisfiable

    @property
    def label_selector(self):
        """Gets the label_selector of this TopologySpreadConstraint.  # noqa: E501


        :return: The label_selector of this TopologySpreadConstraint.  # noqa: E501
        :rtype: LabelSelector
        """
        return self._label_selector

    @label_selector.setter
    def label_selector(self, label_selector):
        """Sets the label_selector of this TopologySpreadConstraint.


        :param label_selector: The label_selector of this TopologySpreadConstraint.  # noqa: E501
        :type: LabelSelector
        """

        self._label_selector = label_selector

    @property
    def max_skew(self):
        """Gets the max_skew of this TopologySpreadConstraint.  # noqa: E501

        MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: +-------+-------+-------+  zone1 | zone2 | zone3 | +-------+-------+-------+    P   |   P   |       | +-------+-------+-------+ if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.  # noqa: E501

        :return: The max_skew of this TopologySpreadConstraint.  # noqa: E501
        :rtype: int
        """
        return self._max_skew

    @max_skew.setter
    def max_skew(self, max_skew):
        """Sets the max_skew of this TopologySpreadConstraint.

        MaxSkew describes the degree to which pods may be unevenly distributed. When `whenUnsatisfiable=DoNotSchedule`, it is the maximum permitted difference between the number of matching pods in the target topology and the global minimum. For example, in a 3-zone cluster, MaxSkew is set to 1, and pods with the same labelSelector spread as 1/1/0: +-------+-------+-------+  zone1 | zone2 | zone3 | +-------+-------+-------+    P   |   P   |       | +-------+-------+-------+ if MaxSkew is 1, incoming pod can only be scheduled to zone3 to become 1/1/1; scheduling it onto zone1(zone2) would make the ActualSkew(2-0) on zone1(zone2) violate MaxSkew(1). if MaxSkew is 2, incoming pod can be scheduled onto any zone. When `whenUnsatisfiable=ScheduleAnyway`, it is used to give higher precedence to topologies that satisfy it. It's a required field. Default value is 1 and 0 is not allowed.  # noqa: E501

        :param max_skew: The max_skew of this TopologySpreadConstraint.  # noqa: E501
        :type: int
        """

        self._max_skew = max_skew

    @property
    def topology_key(self):
        """Gets the topology_key of this TopologySpreadConstraint.  # noqa: E501

        TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a \"bucket\", and try to put balanced number of pods into each bucket. It's a required field.  # noqa: E501

        :return: The topology_key of this TopologySpreadConstraint.  # noqa: E501
        :rtype: str
        """
        return self._topology_key

    @topology_key.setter
    def topology_key(self, topology_key):
        """Sets the topology_key of this TopologySpreadConstraint.

        TopologyKey is the key of node labels. Nodes that have a label with this key and identical values are considered to be in the same topology. We consider each <key, value> as a \"bucket\", and try to put balanced number of pods into each bucket. It's a required field.  # noqa: E501

        :param topology_key: The topology_key of this TopologySpreadConstraint.  # noqa: E501
        :type: str
        """

        self._topology_key = topology_key

    @property
    def when_unsatisfiable(self):
        """Gets the when_unsatisfiable of this TopologySpreadConstraint.  # noqa: E501


        :return: The when_unsatisfiable of this TopologySpreadConstraint.  # noqa: E501
        :rtype: UnsatisfiableConstraintAction
        """
        return self._when_unsatisfiable

    @when_unsatisfiable.setter
    def when_unsatisfiable(self, when_unsatisfiable):
        """Sets the when_unsatisfiable of this TopologySpreadConstraint.


        :param when_unsatisfiable: The when_unsatisfiable of this TopologySpreadConstraint.  # noqa: E501
        :type: UnsatisfiableConstraintAction
        """

        self._when_unsatisfiable = when_unsatisfiable

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TopologySpreadConstraint, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TopologySpreadConstraint):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
