# coding: utf-8

"""
    Seldon Deploy API

    API to interact and manage the lifecycle of your machine learning models deployed through Seldon Deploy.  # noqa: E501

    OpenAPI spec version: v1alpha1
    Contact: hello@seldon.io
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from seldon_deploy_sdk.api_client import ApiClient


class PermissionManagementServiceApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def permission_management_service_create_policy(self, body, **kwargs):  # noqa: E501
        """Create an authorization policy. The user must have `grant` permissions on the resource in the policy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_create_policy(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1Policy body: (required)
        :return: V1CreatePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.permission_management_service_create_policy_with_http_info(body, **kwargs)  # noqa: E501
        else:
            (data) = self.permission_management_service_create_policy_with_http_info(body, **kwargs)  # noqa: E501
            return data

    def permission_management_service_create_policy_with_http_info(self, body, **kwargs):  # noqa: E501
        """Create an authorization policy. The user must have `grant` permissions on the resource in the policy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_create_policy_with_http_info(body, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param V1Policy body: (required)
        :return: V1CreatePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permission_management_service_create_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `permission_management_service_create_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/iam/policy', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1CreatePolicyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permission_management_service_delete_policy(self, action, resource, **kwargs):  # noqa: E501
        """Delete an authorization policy. The user must have `grant` permissions on the resource in the policy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_delete_policy(action, resource, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: The action part of the resource/action permission to revoke. (required)
        :param str resource: The resource part of the resource/action permission to revoke. (required)
        :param list[str] users: The user IDs from which to revoke the given resource/action permission.
        :param list[str] groups: The groups from which to revoke the given resource/action permission.
        :return: V1DeletePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.permission_management_service_delete_policy_with_http_info(action, resource, **kwargs)  # noqa: E501
        else:
            (data) = self.permission_management_service_delete_policy_with_http_info(action, resource, **kwargs)  # noqa: E501
            return data

    def permission_management_service_delete_policy_with_http_info(self, action, resource, **kwargs):  # noqa: E501
        """Delete an authorization policy. The user must have `grant` permissions on the resource in the policy.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_delete_policy_with_http_info(action, resource, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: The action part of the resource/action permission to revoke. (required)
        :param str resource: The resource part of the resource/action permission to revoke. (required)
        :param list[str] users: The user IDs from which to revoke the given resource/action permission.
        :param list[str] groups: The groups from which to revoke the given resource/action permission.
        :return: V1DeletePolicyResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'resource', 'users', 'groups']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permission_management_service_delete_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'action' is set
        if ('action' not in params or
                params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `permission_management_service_delete_policy`")  # noqa: E501
        # verify the required parameter 'resource' is set
        if ('resource' not in params or
                params['resource'] is None):
            raise ValueError("Missing the required parameter `resource` when calling `permission_management_service_delete_policy`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'users' in params:
            query_params.append(('users', params['users']))  # noqa: E501
            collection_formats['users'] = 'multi'  # noqa: E501
        if 'groups' in params:
            query_params.append(('groups', params['groups']))  # noqa: E501
            collection_formats['groups'] = 'multi'  # noqa: E501
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'resource' in params:
            query_params.append(('resource', params['resource']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/iam/policy', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1DeletePolicyResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permission_management_service_get_permissions(self, **kwargs):  # noqa: E501
        """List all permissions associated with the given users and groups. A regular user will be able to see only their permissions and the permissions of their groups. A user with `read` permission on `system/iam` can see all permissions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_get_permissions(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] users: The user IDs for which to list permission.
        :param list[str] groups: The groups for which to list permission.
        :param bool caller_permissions: If true will list the permissions of the user making the request. All users have permissions to check their permissions.
        :return: V1GetPermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.permission_management_service_get_permissions_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.permission_management_service_get_permissions_with_http_info(**kwargs)  # noqa: E501
            return data

    def permission_management_service_get_permissions_with_http_info(self, **kwargs):  # noqa: E501
        """List all permissions associated with the given users and groups. A regular user will be able to see only their permissions and the permissions of their groups. A user with `read` permission on `system/iam` can see all permissions.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_get_permissions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[str] users: The user IDs for which to list permission.
        :param list[str] groups: The groups for which to list permission.
        :param bool caller_permissions: If true will list the permissions of the user making the request. All users have permissions to check their permissions.
        :return: V1GetPermissionsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['users', 'groups', 'caller_permissions']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permission_management_service_get_permissions" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'users' in params:
            query_params.append(('users', params['users']))  # noqa: E501
            collection_formats['users'] = 'multi'  # noqa: E501
        if 'groups' in params:
            query_params.append(('groups', params['groups']))  # noqa: E501
            collection_formats['groups'] = 'multi'  # noqa: E501
        if 'caller_permissions' in params:
            query_params.append(('callerPermissions', params['caller_permissions']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/iam/policy/permissions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1GetPermissionsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def permission_management_service_get_policy_targets(self, action, resource, **kwargs):  # noqa: E501
        """List all users and groups who have access to the given resource/action pair. The user calling this endpoint must have `grant` access to the given resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_get_policy_targets(action, resource, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: The action a target should be able to perform on the given resource. (required)
        :param str resource: The resource a target should have access to. (required)
        :return: V1GetPolicyTargetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.permission_management_service_get_policy_targets_with_http_info(action, resource, **kwargs)  # noqa: E501
        else:
            (data) = self.permission_management_service_get_policy_targets_with_http_info(action, resource, **kwargs)  # noqa: E501
            return data

    def permission_management_service_get_policy_targets_with_http_info(self, action, resource, **kwargs):  # noqa: E501
        """List all users and groups who have access to the given resource/action pair. The user calling this endpoint must have `grant` access to the given resource.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.permission_management_service_get_policy_targets_with_http_info(action, resource, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str action: The action a target should be able to perform on the given resource. (required)
        :param str resource: The resource a target should have access to. (required)
        :return: V1GetPolicyTargetsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['action', 'resource']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method permission_management_service_get_policy_targets" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'action' is set
        if ('action' not in params or
                params['action'] is None):
            raise ValueError("Missing the required parameter `action` when calling `permission_management_service_get_policy_targets`")  # noqa: E501
        # verify the required parameter 'resource' is set
        if ('resource' not in params or
                params['resource'] is None):
            raise ValueError("Missing the required parameter `resource` when calling `permission_management_service_get_policy_targets`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'action' in params:
            query_params.append(('action', params['action']))  # noqa: E501
        if 'resource' in params:
            query_params.append(('resource', params['resource']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['OAuth2']  # noqa: E501

        return self.api_client.call_api(
            '/iam/policy/targets', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='V1GetPolicyTargetsResponse',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
