/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.codepolicy.SASScope;
import com.sas.text.Message;
import com.sas.util.OrderedMapSet;
import com.sas.util.RB;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

@SASScope
public class OrderedMap
implements Map {
    List keyList;
    List valueList;

    public OrderedMap() {
        this.keyList = new ArrayList();
        this.valueList = new ArrayList();
    }

    public OrderedMap(Class modelListClass) throws InstantiationException, IllegalAccessException {
        this.keyList = (List)modelListClass.newInstance();
        this.valueList = (List)modelListClass.newInstance();
    }

    @Override
    public int size() {
        return this.keyList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.keyList.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyList.contains(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.valueList.contains(value);
    }

    public Object get(Object key) {
        int index = this.keyList.indexOf(key);
        if (index == -1) {
            return null;
        }
        return this.valueList.get(index);
    }

    public Object put(Object key, Object value) {
        Object oldValue = this.get(key);
        if (this.containsKey(key)) {
            this.remove(key);
        }
        this.keyList.add(key);
        this.valueList.add(value);
        return oldValue;
    }

    public Object remove(Object key) {
        Object oldValue = this.get(key);
        int index = this.keyList.indexOf(key);
        if (index == -1) {
            return null;
        }
        this.keyList.remove(index);
        this.valueList.remove(index);
        return oldValue;
    }

    public void putAll(Map map) {
        for (Object key : map.keySet()) {
            this.put(key, map.get(key));
        }
    }

    @Override
    public void clear() {
        this.keyList.clear();
        this.valueList.clear();
    }

    public Set keySet() {
        return new OrderedMapSet(this.keyList);
    }

    public Collection values() {
        return new ArrayList(this.valueList);
    }

    public Set entrySet() {
        throw new IllegalStateException(Message.format(RB.getStringResource("notSupported.txt"), (Object)"entrySet()"));
    }

    @Override
    public boolean equals(Object otherMap) {
        return this.hashCode() == otherMap.hashCode();
    }

    @Override
    public int hashCode() {
        return ((Object)this.keyList).hashCode() + ((Object)this.valueList).hashCode();
    }

    public List getKeyList() {
        return this.keyList;
    }
}

