/*
 * Decompiled with CFR 0.152.
 */
package com.sas.models;

import com.sas.codepolicy.SASScope;
import com.sas.models.MutableAnnotatedValueInterface;
import com.sas.util.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

@SASScope
public class SimpleAnnotatedValue
implements MutableAnnotatedValueInterface,
Serializable {
    static final long serialVersionUID = -7066521835746807842L;
    private Map annotations;
    private Object value;

    public SimpleAnnotatedValue() {
    }

    public SimpleAnnotatedValue(Object value, Locale locale) {
        this.setValue(value, locale);
    }

    public SimpleAnnotatedValue(Object value, String key, Object annotationValue, Locale locale) {
        this.setValue(value, locale);
        this.setAnnotationValue(key, annotationValue, locale);
    }

    @Override
    public Collection getAnnotationKeys() {
        if (this.annotations == null) {
            return Collections.EMPTY_LIST;
        }
        Set keySet = this.annotations.keySet();
        ArrayList keys = new ArrayList(keySet.size());
        keys.addAll(keySet);
        return keys;
    }

    @Override
    public void setAnnotationValue(String key, Object value, Locale locale) {
        if (this.annotations == null) {
            this.annotations = new LinkedHashMap(1);
        }
        this.annotations.put(key, value);
    }

    @Override
    public Object getAnnotationValue(String key) {
        if (this.annotations.containsKey(key)) {
            return this.annotations.get(key);
        }
        throw new IllegalArgumentException("Specified annotation not found : " + key);
    }

    @Override
    public boolean isAnnotationValueAvailable(String key) {
        if (this.annotations == null) {
            return false;
        }
        return this.annotations.containsKey(key);
    }

    @Override
    public void clearAnnotationValue(String key) {
        if (this.annotations == null) {
            return;
        }
        this.annotations.remove(key);
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public void setValue(Object value, Locale locale) {
        this.value = value;
    }

    public boolean equals(Object otherValue) {
        if (otherValue instanceof SimpleAnnotatedValue) {
            SimpleAnnotatedValue otherItem = (SimpleAnnotatedValue)otherValue;
            if (!Util.equal(this.getValue(), otherItem.getValue())) {
                return false;
            }
            if (this.annotations != null && otherItem.annotations != null) {
                if (otherItem.annotations == this.annotations) {
                    return true;
                }
                if (otherItem.annotations.size() != this.annotations.size()) {
                    return false;
                }
                for (Map.Entry e : this.annotations.entrySet()) {
                    Object key = e.getKey();
                    Object value = e.getValue();
                    if (!(value == null ? otherItem.annotations.get(key) != null || !otherItem.annotations.containsKey(key) : !Util.equal(value, otherItem.annotations.get(key)))) continue;
                    return false;
                }
            } else if (!Util.equal(this.annotations, otherItem.annotations)) {
                return false;
            }
            return true;
        }
        return false;
    }
}

