/*
 * Decompiled with CFR 0.152.
 */
package com.sas.lang;

import com.sas.codepolicy.SASScope;
import com.sas.security.BaseSecuritySupport;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class RunnableQueue
implements Runnable {
    public static final int defaultCount = 1;
    private ThreadGroup group = null;
    private Thread[] serviceThreads = null;
    private int[] threadCensus = null;
    private List taskList = null;
    private boolean shutDown = false;
    private Runnable shutDownTask = null;

    public RunnableQueue() {
        this(null, null, 1);
    }

    public RunnableQueue(int count) {
        this(null, null, count);
    }

    public RunnableQueue(String name) {
        this(null, name, 1);
    }

    public RunnableQueue(String name, int count) {
        this(null, name, count);
    }

    public RunnableQueue(ThreadGroup group) {
        this(group, null, 1);
    }

    public RunnableQueue(ThreadGroup group, int count) {
        this(group, null, count);
    }

    public RunnableQueue(ThreadGroup group, String name) {
        this(group, name, 1);
    }

    public RunnableQueue(ThreadGroup group, String name, int count) {
        if (count < 1) {
            throw new IllegalArgumentException();
        }
        if (group == null) {
            group = Thread.currentThread().getThreadGroup();
        }
        this.group = group;
        this.taskList = new ArrayList();
        this.serviceThreads = new Thread[count];
        StringBuffer nameBuffer = new StringBuffer();
        BaseSecuritySupport securitySupport = BaseSecuritySupport.securitySupport;
        for (int i = 0; i < count; ++i) {
            Thread serviceThread;
            this.serviceThreads[i] = serviceThread = securitySupport.createThread(this);
            final String threadName = name == null ? null : nameBuffer.append(name).append(" ").append(i).toString();
            nameBuffer.setLength(0);
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    if (threadName != null) {
                        serviceThread.setName(threadName);
                    }
                    serviceThread.setDaemon(true);
                    return null;
                }
            };
            securitySupport.doThreadPrivileged(action);
            serviceThread.start();
        }
        this.threadCensus = new int[1];
        this.threadCensus[0] = count;
        this.shutDownTask = new Runnable(){

            @Override
            public void run() {
                RunnableQueue.this.shutDown = true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Object object;
        Runnable task = null;
        boolean done = false;
        do {
            object = this.taskList;
            synchronized (object) {
                try {
                    while (this.taskList.size() == 0 && !this.shutDown) {
                        this.taskList.wait();
                    }
                    if (!this.shutDown) {
                        task = (Runnable)this.taskList.remove(0);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                }
            }
            if (task != null) {
                try {
                    task.run();
                }
                catch (ThreadDeath td) {
                    done = true;
                }
                catch (Throwable t) {
                    this.group.uncaughtException(Thread.currentThread(), t);
                }
                finally {
                    task = null;
                }
            } else {
                done = true;
            }
        } while (!done);
        object = this.threadCensus;
        synchronized (this.threadCensus) {
            this.threadCensus[0] = this.threadCensus[0] - 1;
            this.threadCensus.notifyAll();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean enqueueTask(Runnable task) {
        if (this.isShutDown()) {
            return false;
        }
        List list = this.taskList;
        synchronized (list) {
            this.taskList.add(task);
            this.taskList.notifyAll();
        }
        return true;
    }

    public void shutDown() {
        this.shutDown(true, false);
    }

    public void shutDown(boolean waitForCompletion) {
        this.shutDown(waitForCompletion, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutDown(boolean waitForCompletion, boolean executePendingCommands) {
        Object object;
        if (executePendingCommands) {
            this.enqueueTask(this.shutDownTask);
        } else {
            object = this.taskList;
            synchronized (object) {
                this.shutDown = true;
                this.taskList.notifyAll();
            }
        }
        if (waitForCompletion) {
            try {
                object = this.threadCensus;
                synchronized (this.threadCensus) {
                    while (this.threadCensus[0] > 0) {
                        this.threadCensus.wait();
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        {
            return;
        }
    }

    public void setDaemon(final boolean daemon) {
        for (int i = 0; i < this.serviceThreads.length; ++i) {
            final Thread serviceThread = this.serviceThreads[i];
            PrivilegedAction action = new PrivilegedAction(){

                public Object run() {
                    serviceThread.setDaemon(daemon);
                    return null;
                }
            };
            BaseSecuritySupport.securitySupport.doThreadPrivileged(action);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutDown() {
        List list = this.taskList;
        synchronized (list) {
            return this.shutDown || this.taskList.contains(this.shutDownTask);
        }
    }
}

