/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.models.Hyperlink;
import com.sas.models.HyperlinkInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class HyperlinkType
extends BaseDataType {
    public static final String RB_KEY = "HyperlinkType.";
    public static final HyperlinkType DEFAULT_INSTANCE = new HyperlinkType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof HyperlinkInterface) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            return this.createHyperlinkFromString((String)inputValue, inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "hyperlinkValueNotValid.ex.txt", inputLocale), inputValue));
    }

    private HyperlinkInterface createHyperlinkFromString(String text, Locale locale) throws IllegalArgumentException {
        return new Hyperlink(text, locale);
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        HyperlinkInterface hyperlink = (HyperlinkInterface)value;
        return hyperlink.getLinkLocation() + " :: " + hyperlink.getLinkLabel().getText(outputLocale);
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((HyperlinkInterface)value).getLinkLocation();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        return this.coerceValue(input, Locale.US);
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        if (value == null) {
            return null;
        }
        return ((HyperlinkInterface)value).toString();
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof HyperlinkInterface && retVal == value) {
            HyperlinkInterface link = (HyperlinkInterface)retVal;
            Hyperlink outPut = new Hyperlink();
            outPut.setLinkLocation(link.getLinkLocation());
            outPut.setLinkLabel(link.getLinkLabel());
            return outPut;
        }
        return retVal;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        HyperlinkInterface link = (HyperlinkInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (link.getLinkLabel(Locale.US) != null) {
            map.put(baseMacroVariableName, link.getLinkLabel(Locale.US));
        }
        if (link.getLinkLocation() != null) {
            map.put(baseMacroVariableName + "_path", link.getLinkLocation());
        }
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        extensions.add("");
        extensions.add("_path");
        return extensions;
    }
}

