/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class ColorType
extends BaseDataType {
    public static final String RB_KEY = "ColorType.";
    public static final ColorType DEFAULT_INSTANCE = new ColorType();
    private static final String ZEROS = "000000";

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof Color) {
            return inputValue;
        }
        if (inputValue instanceof Number) {
            return new Color(((Number)inputValue).intValue(), false);
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            String stringValue = (String)inputValue;
            int stringLength = (stringValue = stringValue.toLowerCase().trim()).length();
            if (stringLength == 0) {
                return null;
            }
            if (stringLength > 2 && (stringValue.startsWith("cx") || stringValue.startsWith("0x"))) {
                stringValue = stringValue.substring(2);
            } else if (stringLength > 1 && stringValue.startsWith("#")) {
                stringValue = stringValue.substring(1);
            }
            try {
                int colorValue = Integer.parseInt(stringValue, 16);
                return new Color(colorValue, false);
            }
            catch (NumberFormatException nfe) {
                throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "colorValueNotValid.ex.txt", inputLocale), inputValue));
            }
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "colorValueNotValid.ex.txt", inputLocale), inputValue));
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        Color c = (Color)value;
        int colorValue = c.getRed() * 65536 + c.getGreen() * 256 + c.getBlue();
        return "cx" + this.convertToHex(colorValue);
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object obj = this.coerceValue(input, Locale.US);
        return obj;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    private String convertToHex(int value) {
        String hex = Integer.toHexString(value);
        if (hex.length() < 6) {
            hex = ZEROS.substring(0, 6 - hex.length()) + hex;
        }
        return hex;
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put(baseMacroVariableName, this.getValueAsString(value, Locale.US));
        return map;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        return this.coerceValue(value, inputLocale);
    }
}

