# auto generated by update_py.py
import typing
from dataclasses import dataclass

from .constant import CommMethod, CommType, FistType


@dataclass
class AddrInfo:
    comm_method: int = None
    port: int = None
    file: str = None
    key: str = None

    def __post_init__(self):
        self.comm_method = CommMethod.parse(self.comm_method)

    def to_dict(self):
        return {
            'comm_method': CommMethod.read(self.comm_method),
            'port': self.port,
            'file': self.file,
            'key': self.key,
        }


@dataclass
class FistInfo:
    is_running: bool = None
    source_id: int = None
    fist_name: str = None
    env_name: str = None
    fist_type: int = None
    pid: int = None
    start_nano: int = None
    end_nano: int = None
    addrs: typing.Dict[int, AddrInfo] = None

    def __post_init__(self):
        self.fist_type = FistType.parse(self.fist_type)
        if self.addrs:
            temp = {}
            for comm_type, info in self.addrs.items():
                temp[comm_type] = AddrInfo(**info)
            self.addrs = temp

    def to_dict(self):
        return {
            'is_running': self.is_running,
            'source_id': self.source_id,
            'fist_name': self.fist_name,
            'env_name': self.env_name,
            'fist_type': FistType.read(self.fist_type),
            'pid': self.pid,
            'start_nano': self.start_nano,
            'end_nano': self.end_nano,
            'addrs': {
                k: v.to_dict() for k, v in self.addrs.items()
            } if self.addrs else None
        }


@dataclass
class EnvInfo:
    env_name: str = None
    private_ip: str = None
    public_ip: str = None

    def to_dict(self):
        return {
            'env_name': self.env_name,
            'private_ip': self.private_ip,
            'public_ip': self.public_ip,
        }
    
    def __str__(self):
        return f'<Env (name){self.env_name} (private){self.private_ip} (public){self.public_ip}>'


@dataclass
class FistAddrUpdate:
    fist_type: int = None
    fist_name: str = None
    comm_type: int = None
    addr: str = None

    def __post_init__(self):
        self.fist_type = FistType.parse(self.fist_type)
        self.comm_type = CommType.parse(self.comm_type)

    def to_dict(self):
        return {
            'fist_type': FistType.read(self.fist_type),
            'fist_name': self.fist_name,
            'comm_type': CommType.read(self.comm_type),
            'addr': self.addr,
        }


@dataclass
class FistStartCommand:
    fist_type: str = None
    run_by: str = None
    run_cmd: str = None

    def to_dict(self):
        return {
            'fist_type': self.fist_type,
            'run_by': self.run_by,
            'run_cmd': self.run_cmd,
        }