# auto generated by update_py.py

import ctypes
from tlclient.linker.constant import MASTER_ERR_MSG_MAX_LIMIT, FIST_NAME_MAX_LIMIT, FIST_ADDR_MAX_LIMIT, NOTIFICATION_MESSAGE_LIMIT, NOTIFICATION_TITLE_LIMIT
from tlclient.linker.constant import FistType, HeartBeatStatus

class ReqFistCreate(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('fist_type', ctypes.c_short),
        ('fist_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
        ('env_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
        ('pid', ctypes.c_int)
    ]

class RspFistCreate(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('source', ctypes.c_size_t),
        ('err_msg', ctypes.c_char * MASTER_ERR_MSG_MAX_LIMIT)
    ]

class ReqFistSet(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('comm_type', ctypes.c_short)
    ]

class RspFistSet(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('is_allowed', ctypes.c_bool),
        ('err_msg', ctypes.c_char * MASTER_ERR_MSG_MAX_LIMIT),
        ('addr', ctypes.c_char * FIST_ADDR_MAX_LIMIT)
    ]

class ReqFistSuicide(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('fist_name', ctypes.c_char * FIST_NAME_MAX_LIMIT)
    ]

class ReqFistReg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('comm_type', ctypes.c_short),
        ('fist_name', ctypes.c_char * FIST_NAME_MAX_LIMIT)
    ]

class RspFistReg(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('input_running', ctypes.c_bool),
        ('input_registered', ctypes.c_bool),
        ('input_connectable', ctypes.c_bool),
        ('addr', ctypes.c_char * FIST_ADDR_MAX_LIMIT)
    ]

class ReqNotify(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('title', ctypes.c_char * NOTIFICATION_TITLE_LIMIT),
        ('message', ctypes.c_char * NOTIFICATION_MESSAGE_LIMIT),
        ('type', ctypes.c_short)
    ]

class RspNotify(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('accepted', ctypes.c_bool),
        ('err_msg', ctypes.c_char * MASTER_ERR_MSG_MAX_LIMIT)
    ]

class MsgHeartBeat(ctypes.Structure):
    _pack_ = 1
    _fields_ = [
        ('fist_type', ctypes.c_short),
        ('fist_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
        ('desc_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
        ('hb_status', ctypes.c_short),
        ('router_name', ctypes.c_char * FIST_NAME_MAX_LIMIT),
    ]

    def __str__(self):
        return '<hb fist_type={} fist_name={} desc_name={} hb_status={} mounted={}>'.format(
            FistType.read(self.fist_type), self.fist_name, self.desc_name, HeartBeatStatus.read(self.hb_status), self.router_name
        )

class ReqCommand:
    # init from a dict (parsed from json)
    def __init__(self, d=None):
        self.request_id = None if d is None else d['request_id']
        self.target_fist_name = None if d is None else d['target_fist_name']
        self.from_fist_name = None if d is None else d['from_fist_name']
        self.content = None if d is None else d['content']
    
    def to_dict(self):
        return {
            'request_id': self.request_id,
            'target_fist_name': self.target_fist_name,
            'from_fist_name': self.from_fist_name,
            'content': self.content
        }

class RspCommand:
    # init from a dict (parsed from json)
    def __init__(self, d=None):
        self.request_id = None if d is None else d['request_id']
        self.fist_name = None if d is None else d['fist_name']
        self.content = None if d is None else d['content']

    def to_dict(self):
        return {
            'request_id': self.request_id,
            'fist_name': self.fist_name,
            'content': self.content
        }
