"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ActionSecretStack = void 0;
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_secretsmanager_1 = require("aws-cdk-lib/aws-secretsmanager");
const constructs_1 = require("../../constructs");
class ActionSecretStack extends aws_cdk_lib_1.Stack {
    constructor(scope, id, props) {
        super(scope, id, props);
        const sourceSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'secretToStoreInGitHub', 'testcdkgithub');
        const githubTokenSecret = aws_secretsmanager_1.Secret.fromSecretNameV2(this, 'ghSecret', 'GITHUB_TOKEN');
        new constructs_1.ActionSecret(this, 'GitHubActionSecret', {
            githubTokenSecret,
            repositoryName: 'cdk-github',
            repositoryOwner: 'wtfjoke',
            repositorySecretName: 'aRandomGitHubSecret',
            sourceSecret,
        });
    }
}
exports.ActionSecretStack = ActionSecretStack;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiYWN0aW9uLXNlY3JldC1zdGFjay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uL3NyYy9leGFtcGxlcy9hY3Rpb24tc2VjcmV0L2FjdGlvbi1zZWNyZXQtc3RhY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7O0FBQUEsNkNBQWdEO0FBQ2hELHVFQUF3RDtBQUV4RCxpREFBZ0Q7QUFFaEQsTUFBYSxpQkFBa0IsU0FBUSxtQkFBSztJQUMxQyxZQUFZLEtBQWdCLEVBQUUsRUFBVSxFQUFFLEtBQWtCO1FBQzFELEtBQUssQ0FBQyxLQUFLLEVBQUUsRUFBRSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXhCLE1BQU0sWUFBWSxHQUFHLDJCQUFNLENBQUMsZ0JBQWdCLENBQUMsSUFBSSxFQUFFLHVCQUF1QixFQUFFLGVBQWUsQ0FBQyxDQUFDO1FBQzdGLE1BQU0saUJBQWlCLEdBQUcsMkJBQU0sQ0FBQyxnQkFBZ0IsQ0FBQyxJQUFJLEVBQUUsVUFBVSxFQUFFLGNBQWMsQ0FBQyxDQUFDO1FBRXBGLElBQUkseUJBQVksQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLEVBQUU7WUFDM0MsaUJBQWlCO1lBQ2pCLGNBQWMsRUFBRSxZQUFZO1lBQzVCLGVBQWUsRUFBRSxTQUFTO1lBQzFCLG9CQUFvQixFQUFFLHFCQUFxQjtZQUMzQyxZQUFZO1NBQ2IsQ0FBQyxDQUFDO0lBQ0wsQ0FBQztDQUNGO0FBZkQsOENBZUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBTdGFjaywgU3RhY2tQcm9wcyB9IGZyb20gJ2F3cy1jZGstbGliJztcbmltcG9ydCB7IFNlY3JldCB9IGZyb20gJ2F3cy1jZGstbGliL2F3cy1zZWNyZXRzbWFuYWdlcic7XG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IEFjdGlvblNlY3JldCB9IGZyb20gJy4uLy4uL2NvbnN0cnVjdHMnO1xuXG5leHBvcnQgY2xhc3MgQWN0aW9uU2VjcmV0U3RhY2sgZXh0ZW5kcyBTdGFjayB7XG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzPzogU3RhY2tQcm9wcykge1xuICAgIHN1cGVyKHNjb3BlLCBpZCwgcHJvcHMpO1xuXG4gICAgY29uc3Qgc291cmNlU2VjcmV0ID0gU2VjcmV0LmZyb21TZWNyZXROYW1lVjIodGhpcywgJ3NlY3JldFRvU3RvcmVJbkdpdEh1YicsICd0ZXN0Y2RrZ2l0aHViJyk7XG4gICAgY29uc3QgZ2l0aHViVG9rZW5TZWNyZXQgPSBTZWNyZXQuZnJvbVNlY3JldE5hbWVWMih0aGlzLCAnZ2hTZWNyZXQnLCAnR0lUSFVCX1RPS0VOJyk7XG5cbiAgICBuZXcgQWN0aW9uU2VjcmV0KHRoaXMsICdHaXRIdWJBY3Rpb25TZWNyZXQnLCB7XG4gICAgICBnaXRodWJUb2tlblNlY3JldCxcbiAgICAgIHJlcG9zaXRvcnlOYW1lOiAnY2RrLWdpdGh1YicsXG4gICAgICByZXBvc2l0b3J5T3duZXI6ICd3dGZqb2tlJyxcbiAgICAgIHJlcG9zaXRvcnlTZWNyZXROYW1lOiAnYVJhbmRvbUdpdEh1YlNlY3JldCcsXG4gICAgICBzb3VyY2VTZWNyZXQsXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==